---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：38-ノンストップモード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/config.rs` 90行目（CookConfig.nonstopフィールド）
- E-02: `src/config.rs` 93-94行目（COOKBOOK_NONSTOP環境変数）
- E-03: `src/bin/repo.rs` 391行目（--nonstopオプション解析）
- E-04: `src/bin/repo.rs` 1459-1462行目（TUIモードでのノンストップ処理）
- E-05: `src/bin/repo.rs` 627-632行目（コンソールモードでのノンストップ処理）
- E-06: `src/bin/repo.rs` 1746-1752行目（PromptOption列挙型）
- E-07: `src/bin/repo.rs` 253-262行目（失敗カウント計算）
- E-08: `src/bin/repo.rs` 268-280行目（サマリー出力）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CookConfig.nonstopでノンストップモードを管理 | E-01 | ○ |
| C-02 | COOKBOOK_NONSTOP環境変数で有効化可能 | E-02 | ○ |
| C-03 | --nonstopオプションで有効化可能 | E-03 | ○ |
| C-04 | TUIモードでnonstop時はprompting=3 | E-04 | ○ |
| C-05 | コンソールモードでnonstop時は継続 | E-05 | ○ |
| C-06 | prompting=3はSkip相当 | E-06 | ○ |
| C-07 | 環境変数は"1"で有効化 | E-02 | ○ |
| C-08 | 失敗カウントを計算 | E-07 | ○ |
| C-09 | サマリーでエラー一覧を表示 | E-08 | ○ |
| C-10 | エラー時のプロンプト表示をスキップ | E-04 | ○ |
| C-11 | 失敗パッケージを記録 | E-07 | ○ |
| C-12 | 失敗があれば終了コード1 | E-08 | ○ |
| C-13 | PromptOptionはRetry/Skip/Exitの3つ | E-06 | ○ |
| C-14 | prompting値の意味は0-4の5種類 | E-04, E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張がソースコードで確認可能）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] prompting変数の各値の意味が正確か確認
- [ ] TUIモードとコンソールモードの処理分岐が正確か確認
- [ ] サマリー出力の内容が正確か確認
- [ ] 終了コードの判定ロジックが正確か確認
