---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-ソース取得（パス参照）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. **更新検出ロジックの動作確認**：日時比較の正確性
  2. **copy_dir_all()の非アトミック性**：中断時の状態

## 2) 参照した情報（Evidence一覧）

- E-01: `src/recipe.rs` 29-33行目 - SourceRecipe::Path variant定義
- E-02: `src/cook/fetch.rs` 141-159行目 - Path処理ブロック
- E-03: `src/cook/fs.rs` 52-64行目 - copy_dir_all()関数
- E-04: `src/cook/fs.rs` 163-172行目 - modified_dir()関数
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SourceRecipe::Pathはpathフィールド1つを持つ | E-01 | ○ |
| C-02 | sourceディレクトリが存在しない場合はコピー実行 | E-02 | ○ |
| C-03 | 指定パスがsourceより新しい場合はコピー実行 | E-02 | ○ |
| C-04 | copy_dir_all()で再帰的にコピー | E-03 | ○ |
| C-05 | ディレクトリ構造を保持してコピー | E-03 | ○ |
| C-06 | source_identifierは"local_source"固定 | E-02 | ○ |
| C-07 | modified_dir()でディレクトリの更新日時を取得 | E-04 | ○ |
| C-08 | repo fetchコマンドとの連携がある | E-05 | ○ |
| C-09 | ファイルはfs::copy()でコピー | E-03 | ○ |
| C-10 | ディレクトリはfs::create_dir_all()で作成 | E-03 | ○ |
| C-11 | DEBUG: 更新メッセージを出力 | E-02 | ○ |
| C-12 | コピーエラー時はエラーメッセージを返却 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特に不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルなファイルコピー処理
- 1: 中リスク - copy_dir_all()が非アトミックのため中断時の状態に注意

## 6) レビュアーチェックリスト（最小）
- [ ] modified_dir()の更新日時比較が正確か確認
- [ ] 大きなディレクトリでのコピー性能確認
- [ ] コピー中断時の部分的なsourceディレクトリの扱い確認
- [ ] 相対パスと絶対パスの両方で動作確認
