---
generated_at: 2026-01-22 23:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：41-環境変数オーバーライド

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **BR-41-01の適用順序**：cookbook.tomlと環境変数の優先度関係の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/config.rs` 5-27行目 - CookConfigOpt構造体定義
- E-02: `src/config.rs` 29-39行目 - CookConfig構造体定義
- E-03: `src/config.rs` 56-64行目 - CookbookConfig構造体定義
- E-04: `src/config.rs` 66行目 - CONFIG静的変数定義
- E-05: `src/config.rs` 68-121行目 - init_config関数
- E-06: `src/config.rs` 123-129行目 - extract_env関数
- E-07: `src/config.rs` 131-133行目 - get_config関数
- E-08: `src/config.rs` 80-82行目 - CI環境変数によるTUI判定
- E-09: `src/config.rs` 83-90行目 - COOKBOOK_MAKE_JOBS処理
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 46行目 - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | COOKBOOK_*環境変数で設定を上書きする | E-05, E-06, E-09 | ○ |
| C-02 | CookConfigOptはOption型でラップされている | E-01 | ○ |
| C-03 | CookConfigは実際の設定値を保持 | E-02 | ○ |
| C-04 | extract_env関数はジェネリック実装 | E-06 | ○ |
| C-05 | パース失敗時はデフォルト値を使用 | E-06 125行目 | ○ |
| C-06 | CI環境変数でTUI無効化を判定 | E-08 | ○ |
| C-07 | ジョブ数未指定時はCPU並列度を使用 | E-09 86-88行目 | ○ |
| C-08 | COOKBOOK_LOGS環境変数をサポート | E-05 91-93行目 | ○ |
| C-09 | COOKBOOK_OFFLINE環境変数をサポート | E-05 94-96行目 | ○ |
| C-10 | COOKBOOK_VERBOSE環境変数をサポート | E-05 97-99行目 | ○ |
| C-11 | COOKBOOK_NONSTOP環境変数をサポート | E-05 100-102行目 | ○ |
| C-12 | COOKBOOK_CLEAN_BUILD環境変数をサポート | E-05 103-105行目 | ○ |
| C-13 | COOKBOOK_CLEAN_TARGET環境変数をサポート | E-05 106-108行目 | ○ |
| C-14 | OnceLockでスレッドセーフに設定保持 | E-04 | ○ |
| C-15 | cookbook.toml未設定時のみ環境変数適用 | E-05 | ○ |
| C-16 | repo cookコマンド画面と連携 | E-10 | ○ |
| C-17 | CONFIG.set()が2回呼ばれるとpanic | E-05 120行目 | ○ |
| C-18 | tomlと環境変数の具体的な優先度ルール | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18について：cookbook.tomlで明示的に値が設定された場合の環境変数との関係は、コードを見る限りcookbook.tomlの値が優先されるが、明示的なドキュメントが見つからなかった
  - 候補：設計仕様書 / 開発者向けドキュメント / テストコード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本機能は設定管理のみで、ビルド処理に直接影響しない
- 0: 低リスク - extract_env関数はパース失敗時にデフォルト値を返すため安全

## 6) レビュアーチェックリスト（最小）
- [ ] CookConfigOptの各フィールドがOption型であることを確認
- [ ] extract_env関数のデフォルト値処理が正しいことを確認
- [ ] CI環境変数によるTUI判定ロジックの妥当性を確認
- [ ] 各COOKBOOK_*環境変数のデフォルト値が適切であることを確認
