---
generated_at: 2026-01-22 23:55:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：46-PTY管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cook/pty.rs` 34-57行目 - setup_pty関数
- E-02: `src/cook/pty.rs` 111-153行目 - openpty関数
- E-03: `src/cook/pty.rs` 70-75行目 - spawn_to_pipe関数
- E-04: `src/cook/pty.rs` 249-294行目 - PtyFd::spawn_command
- E-05: `src/cook/pty.rs` 185-198行目 - PtyFd::read
- E-06: `src/cook/pty.rs` 59-68行目 - flush_pty関数
- E-07: `src/cook/pty.rs` 18-30行目 - log_to_pty!マクロ
- E-08: `src/cook/pty.rs` 86-98行目 - PtySize構造体
- E-09: `src/cook/pty.rs` 100-109行目 - PtySize::default
- E-10: `src/cook/pty.rs` 314-330行目 - cloexec関数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | setup_ptyはPTYペアを作成する | E-01 | ○ |
| C-02 | デフォルト端末サイズは24行x80列 | E-09 102-107行目 | ○ |
| C-03 | openptyはlibc::openptyをラップ | E-02 122-132行目 | ○ |
| C-04 | CLOEXECをPTYファイルディスクリプタに設定 | E-02 149-150行目, E-10 | ○ |
| C-05 | spawn_to_pipeはスレーブPTYを子プロセスに接続 | E-03, E-04 | ○ |
| C-06 | pre_execでシグナルをデフォルトにリセット | E-04 259-268行目 | ○ |
| C-07 | pre_execでsetsid()を呼び出す | E-04 273-276行目 | ○ |
| C-08 | EIOをEOFとして扱う | E-05 187-193行目 | ○ |
| C-09 | flush_ptyで100msスリープを挿入 | E-06 65, 67行目 | ○ |
| C-10 | log_to_pty!はPTY有無で分岐 | E-07 21-28行目 | ○ |
| C-11 | pty_readerはtry_clone_reader()で取得 | E-01 49-52行目 | ○ |
| C-12 | ログパイプはstd::io::pipe()で作成 | E-01 54行目 | ○ |
| C-13 | stdout/stderrをPTYに接続 | E-04 252-254行目 | ○ |
| C-14 | 子プロセス起動後にstdout/stderrをtake | E-04 290-291行目 | ○ |
| C-15 | PtySizeはrows, cols, pixel_width, pixel_heightを持つ | E-08 | ○ |
| C-16 | PtyPairはmaster, slaveを持つ | E-02 155-160行目参照（実際は162-170行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - unsafe blockを含むため、メモリ安全性に注意
- 1: 中リスク - libc直接呼び出しのため、プラットフォーム依存性あり

## 6) レビュアーチェックリスト（最小）
- [ ] openptyのエラーハンドリングが正しいか確認
- [ ] CLOEXECの設定が正しいか確認
- [ ] pre_execのシグナルリセットが適切か確認
- [ ] EIOハンドリングの動作が正しいか確認
