---
generated_at: 2026-01-23 00:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：48-依存関係ツリー表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cook/tree.rs` 12-17行目 - WalkTreeEntry列挙型
- E-02: `src/cook/tree.rs` 19-36行目 - display_tree_entry関数
- E-03: `src/cook/tree.rs` 38-107行目 - walk_tree_entry関数
- E-04: `src/cook/tree.rs` 109-124行目 - display_pkg_fn関数
- E-05: `src/cook/tree.rs` 126-164行目 - walk_file_tree関数
- E-06: `src/cook/tree.rs` 166-174行目 - format_size関数
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 54-56行目 - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WalkTreeEntryは4状態（Built, NotBuilt, Deduped, Missing） | E-01 | ○ |
| C-02 | display_tree_entryはwalk_tree_entryを呼び出す | E-02 27-35行目 | ○ |
| C-03 | walk_tree_entryは再帰的に依存関係を走査 | E-03 94-104行目 | ○ |
| C-04 | 重複パッケージはvisitedセットでスキップ | E-03 58, 67-69行目 | ○ |
| C-05 | Builtパッケージのサイズを累積 | E-03 72-74行目 | ○ |
| C-06 | stage.tomlの依存情報を優先 | E-03 78-82行目 | ○ |
| C-07 | recipe.tomlの依存をフォールバック | E-03 83-85行目 | ○ |
| C-08 | 最後の子は"└── "を使用 | E-04 121行目 | ○ |
| C-09 | それ以外は"├── "を使用 | E-04 121行目 | ○ |
| C-10 | display_pkg_fnで1行表示 | E-04 122行目 | ○ |
| C-11 | format_sizeでサイズを人間可読形式に変換 | E-06 | ○ |
| C-12 | repo treeコマンドで使用される | E-07 | ○ |
| C-13 | Missingの場合は早期リターン | E-03 47-53行目 | ○ |
| C-14 | fs::metadata()でビルド状態判定 | E-03 59-63行目 | ○ |
| C-15 | walk_file_treeはディレクトリツリーを表示 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本機能は読み取り専用の表示機能
- 1: 中リスク - 再帰呼び出しのため、非常に深い依存ツリーではスタックオーバーフローの可能性

## 6) レビュアーチェックリスト（最小）
- [ ] WalkTreeEntryの状態遷移が正しいか確認
- [ ] 重複スキップのロジックが正しいか確認
- [ ] ツリー記号の表示が正しいか確認
- [ ] サイズ累積のロジックが正しいか確認
