---
generated_at: 2026-01-23 00:10:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：49-ファイルサイズフォーマット

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cook/tree.rs` 166-174行目 - format_size関数
- E-02: `src/cook/tree.rs` 167-169行目 - ゼロチェック
- E-03: `src/cook/tree.rs` 170行目 - UNITS配列定義
- E-04: `src/cook/tree.rs` 171行目 - 単位インデックス計算
- E-05: `src/cook/tree.rs` 172行目 - サイズ値計算
- E-06: `src/cook/tree.rs` 173行目 - フォーマット文字列生成
- E-07: `src/cook/tree.rs` 116行目 - display_pkg_fnでの使用
- E-08: `src/cook/tree.rs` 157行目 - walk_file_treeでの使用
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 56行目 - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 0バイトは"0 B"を返却 | E-02 | ○ |
| C-02 | 単位はB, KiB, MiB, GiB, TiBの5種類 | E-03 | ○ |
| C-03 | log(1024)で単位インデックスを計算 | E-04 | ○ |
| C-04 | 1024のi乗で割ってサイズを計算 | E-05 | ○ |
| C-05 | 小数点以下2桁でフォーマット | E-06 "{:.2}" | ○ |
| C-06 | display_pkg_fnで使用される | E-07 | ○ |
| C-07 | walk_file_treeで使用される | E-08 | ○ |
| C-08 | repo treeコマンドで使用される | E-09 | ○ |
| C-09 | バイナリプレフィックス（1024進数）を使用 | E-03, E-04 | ○ |
| C-10 | 戻り値はString型 | E-01 戻り値型 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本機能は純粋な計算関数で副作用なし
- 1: 中リスク - TiBを超えるサイズでは配列インデックス範囲外となる可能性

## 6) レビュアーチェックリスト（最小）
- [ ] ゼロチェックが正しいか確認
- [ ] 単位インデックス計算が正しいか確認
- [ ] サイズ値計算が正しいか確認
- [ ] フォーマット文字列が正しいか確認
