---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-ソース取得（同一ソース参照）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. **無限ループ検出ロジックの動作確認**：パス深度50の妥当性
  2. **既存ディレクトリ競合時のエラーメッセージ**：ユーザーフレンドリーさ
  3. **再帰的fetch呼び出し**：深い再帰の影響

## 2) 参照した情報（Evidence一覧）

- E-01: `src/recipe.rs` 21-28行目 - SourceRecipe::SameAs variant定義
- E-02: `src/cook/fetch.rs` 134-140行目 - SameAs処理ブロック
- E-03: `src/cook/fetch.rs` 431-452行目 - fetch_resolve_canon()関数
- E-04: `src/cook/fetch.rs` 408-429行目 - fetch_make_symlink()関数
- E-05: `src/cook/fetch.rs` 672-680行目 - fetch_get_source_info()関数
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SourceRecipe::SameAsはsame_asフィールド1つを持つ | E-01 | ○ |
| C-02 | fetch_resolve_canon()で参照先パスを解決 | E-03 | ○ |
| C-03 | パス内の'/'が50を超える場合は無限ループとしてエラー | E-03 | ○ |
| C-04 | 参照先が存在しない場合はエラー | E-03 | ○ |
| C-05 | CookRecipe::from_path()で参照先レシピを読み込み | E-03 | ○ |
| C-06 | fetch()を再帰的に呼び出して参照先のソースを取得 | E-02 | ○ |
| C-07 | fetch_make_symlink()でシンボリックリンクを作成 | E-04 | ○ |
| C-08 | sourceがシンボリックリンクでなくディレクトリの場合はエラー | E-04 | ○ |
| C-09 | std::os::unix::fs::symlink()でリンク作成 | E-04 | ○ |
| C-10 | fetch_get_source_info()で参照先のsource_identifierを取得 | E-05 | ○ |
| C-11 | repo fetchコマンドとの連携がある | E-06 | ○ |
| C-12 | sourceが既にシンボリックリンクの場合は既存リンクを使用 | E-04 | ○ |
| C-13 | エラーメッセージでsourceディレクトリの手動削除を案内 | E-04 | ○ |
| C-14 | 参照先パスは相対パスで指定 | E-01, E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特に不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンボリックリンク作成は標準的なOS操作
- 1: 中リスク - 再帰的fetch呼び出しの深さに注意
- 0: 低リスク - 無限ループ検出により安全性を確保

## 6) レビュアーチェックリスト（最小）
- [ ] パス深度50の閾値が適切か確認
- [ ] 既存ディレクトリ競合時のエラーメッセージが明確か確認
- [ ] 複数段階の再帰参照（A→B→C）が正しく動作するか確認
- [ ] シンボリックリンクの相対パスが正しいか確認
