---
generated_at: 2026-01-23 00:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：50-ソース識別子管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cook/ident.rs` 7-10行目 - IdentifierConfig構造体
- E-02: `src/cook/ident.rs` 13-31行目 - IdentifierConfig::new
- E-03: `src/cook/ident.rs` 14-17行目 - get_git_head_rev呼び出し
- E-04: `src/cook/ident.rs` 19-28行目 - dateコマンド実行
- E-05: `src/cook/ident.rs` 34行目 - IDENTIFIER_CONFIG静的変数
- E-06: `src/cook/ident.rs` 36-40行目 - get_ident関数
- E-07: `src/cook/ident.rs` 42-46行目 - init_ident関数
- E-08: `src/cook/fetch.rs` 648-660行目 - fetch_apply_source_info
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 65行目 - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IdentifierConfigはcommitとtimeを持つ | E-01 | ○ |
| C-02 | new()でget_git_head_revを呼び出す | E-03 | ○ |
| C-03 | new()でdateコマンドを実行 | E-04 | ○ |
| C-04 | dateコマンドは-uオプションでUTC | E-04 21行目 | ○ |
| C-05 | 時刻はISO 8601形式 | E-04 22行目 | ○ |
| C-06 | OnceLockでスレッドセーフに保持 | E-05 | ○ |
| C-07 | get_ident()で識別子を取得 | E-06 | ○ |
| C-08 | init_ident()で初期化 | E-07 | ○ |
| C-09 | 2回呼び出すとpanic | E-07 45行目 | ○ |
| C-10 | Git失敗時は空文字列 | E-03 17行目 unwrap_or | ○ |
| C-11 | fetch_apply_source_infoで使用される | E-08 | ○ |
| C-12 | source_info.tomlに書き込まれる | E-08 667行目 | ○ |
| C-13 | repo_builderコマンドで使用される | E-09 | ○ |
| C-14 | 戻り値は&'static IdentifierConfig | E-06 戻り値型 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本機能は識別子の管理のみ
- 1: 中リスク - dateコマンドに依存するため、環境によっては動作が異なる可能性

## 6) レビュアーチェックリスト（最小）
- [ ] IdentifierConfig::newのエラーハンドリングが正しいか確認
- [ ] dateコマンドのフォーマットが正しいか確認
- [ ] OnceLockの使用が正しいか確認
- [ ] source_info.tomlへの書き込み形式が正しいか確認
