---
generated_at: 2026-01-22 23:30:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：51-ターゲット判定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cook/package.rs` - package_target関数の実装（192-198行目）
- E-02: `src/cook/cook_build.rs` - TARGET環境変数の設定（394行目）
- E-03: `src/recipe.rs` - CookRecipe構造体でのtarget設定（229行目）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能51の定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面との関連定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | パッケージ名からビルドターゲットを判定する | E-01 | ○ |
| C-02 | ホストパッケージの場合はredoxer::host_target()を返却 | E-01 (193-194行目) | ○ |
| C-03 | 通常パッケージの場合はredoxer::target()を返却 | E-01 (195-197行目) | ○ |
| C-04 | TARGET環境変数としてビルドスクリプトに渡される | E-02 | ○ |
| C-05 | CookRecipe構造体でtargetフィールドが設定される | E-03 | ○ |
| C-06 | repo cookコマンド画面との関連 | E-05 | ○ |
| C-07 | cookbook_redoxerコマンド画面との関連 | E-05 | ○ |
| C-08 | 入力はPackageName型 | E-01 | ○ |
| C-09 | 出力は&'static str型 | E-01 | ○ |
| C-10 | is_host()メソッドで判定を行う | E-01 | ○ |
| C-11 | 機能説明がパッケージ名からビルドターゲットを判定 | E-04 | ○ |
| C-12 | package.rsに実装がある | E-04 (備考欄) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] package_target関数の実装が正しく記載されているか確認
- [ ] redoxerライブラリの外部依存が明示されているか確認
- [ ] ホストパッケージの命名規則が正確か確認
