---
generated_at: 2026-01-22 23:34:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：53-動的/静的リンク切替

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cook/script.rs` - SHARED_PRESCRIPT内のDYNAMIC_INIT関数（1-46行目）
- E-02: `src/cook/script.rs` - DYNAMIC_STATIC_INIT関数（48-74行目）
- E-03: `src/cook/cook_build.rs` - full_script構築（418-421行目）
- E-04: `src/cook/cook_build.rs` - BuildKindに応じたスクリプト生成（342-367行目）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能53の定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面との関連定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DYNAMIC_INIT関数で動的リンクビルド設定を適用 | E-01, E-05 | ○ |
| C-02 | autotools_recursive_regenerateヘルパー関数を定義 | E-01 (4-9行目) | ○ |
| C-03 | i586-unknown-redoxは動的リンク非対応 | E-01 (12-14行目) | ○ |
| C-04 | riscv64gc-unknown-redoxは動的リンク非対応 | E-01 (12-14行目) | ○ |
| C-05 | 非対応時は警告出力して終了 | E-01 (14-15行目) | ○ |
| C-06 | COOKBOOK_CONFIGURE_FLAGSを設定 | E-01 (21-26行目) | ○ |
| C-07 | --enable-shared、--disable-staticを設定 | E-01 (24-25行目) | ○ |
| C-08 | COOKBOOK_CMAKE_FLAGSを設定 | E-01 (28-32行目) | ○ |
| C-09 | BUILD_SHARED_LIBS=Trueを設定 | E-01 (29行目) | ○ |
| C-10 | COOKBOOK_MESON_FLAGSを設定 | E-01 (34-40行目) | ○ |
| C-11 | -Ddefault_library=sharedを設定 | E-01 (38行目) | ○ |
| C-12 | LDFLAGSを設定（rpath-link） | E-01 (43行目) | ○ |
| C-13 | RUSTFLAGS=-C target-feature=-crt-staticを設定 | E-01 (44行目) | ○ |
| C-14 | COOKBOOK_DYNAMIC=1を設定 | E-01 (45行目) | ○ |
| C-15 | DYNAMIC_STATIC_INITも提供されている | E-02 | ○ |
| C-16 | repo cookコマンド画面との連携 | E-03, E-06 | ○ |
| C-17 | BuildKindごとにDYNAMIC_INITが自動挿入 | E-04 | ○ |
| C-18 | COOKBOOK_VERBOSEでデバッグメッセージ出力 | E-01 (14, 19行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] DYNAMIC_INIT関数の実装が正しく記載されているか確認
- [ ] 各ビルドシステム（autotools/CMake/Meson）のフラグが正確か確認
- [ ] 非対応ターゲットの判定ロジックが正確か確認
