---
generated_at: 2026-01-22 23:46:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：59-AppStreamメタデータ更新

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cook/script.rs` - BUILD_POSTSCRIPT内のAppStream処理（336-343行目）
- E-02: `src/cook/cook_build.rs` - full_script構築（418-421行目）
- E-03: `src/bin/repo_builder.rs` - AppStreamカタログ生成
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能59の定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面との関連定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BUILD_POSTSCRIPTの一部として実行される | E-01, E-02 | ○ |
| C-02 | share/metainfoとusr/share/metainfoを対象とする | E-01 (337行目) | ○ |
| C-03 | ディレクトリ存在確認を行う | E-01 (339行目) | ○ |
| C-04 | findコマンドでファイル検索 | E-01 (341行目) | ○ |
| C-05 | -name '*.xml'パターンで検索 | E-01 (341行目) | ○ |
| C-06 | sed -iでin-place更新 | E-01 (341行目) | ○ |
| C-07 | </component>タグを置換 | E-01 (341行目) | ○ |
| C-08 | pkgnameタグを挿入 | E-01 (341行目) | ○ |
| C-09 | COOKBOOK_NAMEを使用 | E-01 (341行目) | ○ |
| C-10 | full_scriptの最後に追加される | E-02 | ○ |
| C-11 | repo cookコマンド画面との連携 | E-05 | ○ |
| C-12 | メタデータXMLへのpkgnameタグ追加 | E-04 | ○ |
| C-13 | BUILD_POSTSCRIPTで定義 | E-01 | ○ |
| C-14 | repo_builderでpkgnameが利用される | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] AppStream処理の対象ディレクトリが正しいか確認
- [ ] sed置換パターンが正確か確認
- [ ] COOKBOOK_NAMEの利用が正確か確認
