---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-リモートパッケージ取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. **リモートサーバーの可用性確認**：外部依存
  2. **署名検証のタイミング**：ダウンロード後の検証
  3. **オフラインモードの動作確認**

## 2) 参照した情報（Evidence一覧）

- E-01: `src/recipe.rs` 96-98行目 - BuildKind::Remote variant定義
- E-02: `src/cook/fetch.rs` 517-580行目 - fetch_remote()関数
- E-03: `src/cook/fetch.rs` 503-511行目 - get_remote_url()関数
- E-04: `src/cook/fetch.rs` 513-515行目 - get_pubkey_url()関数
- E-05: `src/lib.rs` 12行目 - REMOTE_PKG_SOURCE定数
- E-06: `src/cook/fs.rs` 278-288行目 - download_wget()関数
- E-07: `src/cook/fs.rs` 268-276行目 - offline_check_exists()関数
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BuildKind::Remoteはtemplate="remote"で指定 | E-01 | ○ |
| C-02 | REMOTE_PKG_SOURCEは"https://static.redox-os.org/pkg" | E-05 | ○ |
| C-03 | fetch_remote()がメインのダウンロード処理を行う | E-02 | ○ |
| C-04 | get_remote_url()でパッケージURLを生成 | E-03 | ○ |
| C-05 | get_pubkey_url()で公開鍵URLを生成 | E-04 | ○ |
| C-06 | download_wget()でファイルをダウンロード | E-06 | ○ |
| C-07 | オフラインモードではoffline_check_exists()で存在確認 | E-07 | ○ |
| C-08 | ターゲット別のサブディレクトリからダウンロード | E-03 | ○ |
| C-09 | メインパッケージとオプショナルパッケージを全てダウンロード | E-02 | ○ |
| C-10 | .pkgarと.tomlの両方をダウンロード | E-02 | ○ |
| C-11 | source.tomlからsource_identifierを抽出 | E-02 | ○ |
| C-12 | repo fetchコマンドとの連携がある | E-08 | ○ |
| C-13 | id_ed25519.pub.tomlを最初にダウンロード | E-02 | ○ |
| C-14 | オフラインモードでファイルがない場合はエラー | E-07 | ○ |
| C-15 | redoxer::target()でターゲットを取得 | E-03 | ○ |
| C-16 | pkg::Package::from_toml()でメタデータを解析 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特に不足情報なし

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 外部サーバーへの依存（可用性リスク）
- 0: 低リスク - ダウンロード処理は標準的なwget使用
- 0: 低リスク - オフラインモードの存在確認は明確

## 6) レビュアーチェックリスト（最小）
- [ ] REMOTE_PKG_SOURCEのURLが有効か確認
- [ ] 署名検証がビルド時に正しく実行されるか確認
- [ ] オフラインモードでの動作確認
- [ ] ターゲット名が正しく解決されるか確認
- [ ] オプショナルパッケージのダウンロードが正しく動作するか確認
