---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-パッチ適用

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. **パッチ適用失敗時のリカバリ**：部分適用の扱い
  2. **パッチの順序依存性**：複数パッチの適用順
  3. **Gitリセット処理との連携**

## 2) 参照した情報（Evidence一覧）

- E-01: `src/recipe.rs` 49-50行目 - Git sourceのpatches
- E-02: `src/recipe.rs` 62-63行目 - Tar sourceのpatches
- E-03: `src/cook/fetch.rs` 606-646行目 - fetch_apply_patches()関数
- E-04: `src/cook/fs.rs` 220-252行目 - run_command_stdin()関数
- E-05: `src/cook/fetch.rs` 284-290行目 - Gitソースでのgit reset --hard
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | patchesはVec<String>型でパッチファイル名のリスト | E-01, E-02 | ○ |
| C-02 | Gitソース、Tarソース両方でpatches指定可能 | E-01, E-02 | ○ |
| C-03 | fetch_apply_patches()でパッチを適用 | E-03 | ○ |
| C-04 | パッチファイルの存在確認を行う | E-03 | ○ |
| C-05 | fs::read_to_string()でパッチ内容を読み込む | E-03 | ○ |
| C-06 | patchコマンドを使用してパッチを適用 | E-03 | ○ |
| C-07 | --strip=1オプションを使用 | E-03 | ○ |
| C-08 | --directoryオプションでソースディレクトリを指定 | E-03 | ○ |
| C-09 | 標準入力からパッチ内容を渡す | E-03, E-04 | ○ |
| C-10 | パッチはpatches配列の順序で適用 | E-03 | ○ |
| C-11 | パッチファイル不在時はエラー | E-03 | ○ |
| C-12 | Gitソースの場合、パッチ適用前にgit reset --hard実行 | E-05 | ○ |
| C-13 | repo fetchコマンドとの連携がある | E-06 | ○ |
| C-14 | スクリプトも同時に実行可能 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特に不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - patchコマンドは標準的なツール
- 1: 中リスク - 部分適用後のロールバック不可
- 0: 低リスク - パッチ順序は配列順で明確

## 6) レビュアーチェックリスト（最小）
- [ ] --strip=1が全てのパッチ形式に適切か確認
- [ ] パッチ適用失敗時のエラーメッセージが明確か確認
- [ ] Gitソースでのgit reset --hardが正しく実行されるか確認
- [ ] 複数パッチの適用順序が期待通りか確認
