---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-ビルド前スクリプト実行

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. **SHARED_PRESCRIPTの関数仕様**：クロスコンパイル設定の詳細
  2. **エラー時の状態管理**：部分実行後の復旧
  3. **ターゲット別の動的リンク設定**

## 2) 参照した情報（Evidence一覧）

- E-01: `src/recipe.rs` 51-52行目 - Git sourceのscript
- E-02: `src/recipe.rs` 64-65行目 - Tar sourceのscript
- E-03: `src/cook/script.rs` 1-79行目 - SHARED_PRESCRIPT定義
- E-04: `src/cook/fetch.rs` 636-645行目 - script実行部分
- E-05: `src/cook/fs.rs` 220-252行目 - run_command_stdin()関数
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | scriptはOption<String>型 | E-01, E-02 | ○ |
| C-02 | Gitソース、Tarソース両方でscript指定可能 | E-01, E-02 | ○ |
| C-03 | bash -exでスクリプトを実行 | E-04 | ○ |
| C-04 | current_dirでsource_dirを設定 | E-04 | ○ |
| C-05 | SHARED_PRESCRIPTをスクリプト先頭に結合 | E-04 | ○ |
| C-06 | run_command_stdin()で標準入力からスクリプトを渡す | E-04, E-05 | ○ |
| C-07 | DYNAMIC_INIT関数が提供される | E-03 | ○ |
| C-08 | DYNAMIC_STATIC_INIT関数が提供される | E-03 | ○ |
| C-09 | autotools_recursive_regenerate関数が提供される | E-03 | ○ |
| C-10 | GNU_CONFIG_GET関数が提供される | E-03 | ○ |
| C-11 | -eオプションでエラー時停止 | E-04 | ○ |
| C-12 | -xオプションでコマンドエコー | E-04 | ○ |
| C-13 | repo fetchコマンドとの連携がある | E-06 | ○ |
| C-14 | scriptがNoneの場合はスキップ | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特に不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - bash実行は標準的な処理
- 1: 中リスク - SHARED_PRESCRIPTの関数が正しく動作するか確認推奨
- 0: 低リスク - -exオプションによるログ出力で追跡可能

## 6) レビュアーチェックリスト（最小）
- [ ] DYNAMIC_INIT関数がターゲット別に正しく設定されるか確認
- [ ] autotools_recursive_regenerate関数の動作確認
- [ ] スクリプトエラー時のエラーメッセージが明確か確認
- [ ] COOKBOOK_AUTORECONFの設定が正しいか確認
