---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-Cargoビルド

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **cookbook_redoxerの動作詳細**：クロスコンパイル設定
  2. **DYNAMIC_INITとRUSTFLAGS**：動的リンク設定
  3. **BUILD_POSTSCRIPTの処理内容**

## 2) 参照した情報（Evidence一覧）

- E-01: `src/recipe.rs` 99-106行目 - BuildKind::Cargo variant定義
- E-02: `src/cook/cook_build.rs` 342-351行目 - Cargoビルドスクリプト生成
- E-03: `src/cook/script.rs` 134-144行目 - cookbook_cargo関数
- E-04: `src/cook/script.rs` 81-132行目 - BUILD_PRESCRIPT前半
- E-05: `src/cook/script.rs` 308-344行目 - BUILD_POSTSCRIPT
- E-06: `src/cook/script.rs` 1-79行目 - SHARED_PRESCRIPT, DYNAMIC_INIT
- E-07: `src/cook/cook_build.rs` 369-422行目 - cookbook_redoxerによるビルド実行
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BuildKind::Cargoはtemplate="cargo"で指定 | E-01 | ○ |
| C-02 | package_pathでCargo.tomlのサブディレクトリを指定可能 | E-01, E-02 | ○ |
| C-03 | cargoflagsで追加フラグを指定可能 | E-01, E-02 | ○ |
| C-04 | DYNAMIC_INITが最初に呼び出される | E-02 | ○ |
| C-05 | cookbook_cargo関数でビルド実行 | E-02, E-03 | ○ |
| C-06 | --lockedオプションを使用 | E-03 | ○ |
| C-07 | --no-trackオプションを使用 | E-03 | ○ |
| C-08 | --pathでソースディレクトリを指定 | E-03 | ○ |
| C-09 | --rootでステージディレクトリを指定 | E-03 | ○ |
| C-10 | -jで並列ジョブ数を指定 | E-03 | ○ |
| C-11 | CARGO_TARGET_DIRが設定される | E-04 | ○ |
| C-12 | BUILD_POSTSCRIPTでstripを実行 | E-05 | ○ |
| C-13 | BUILD_POSTSCRIPTで.laファイルを削除 | E-05 | ○ |
| C-14 | BUILD_POSTSCRIPTで.crates*.tomlを削除 | E-05 | ○ |
| C-15 | DYNAMIC_INITでRUSTFLAGSを設定 | E-06 | ○ |
| C-16 | cookbook_redoxerでクロスコンパイル環境を設定 | E-07 | ○ |
| C-17 | repo cookコマンドとの連携がある | E-08 | ○ |
| C-18 | COOKBOOK_CARGOはCOOKBOOK_REDOXERを使用 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特に不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - cargoコマンドは標準的なRustツール
- 1: 中リスク - クロスコンパイル設定の複雑さ
- 0: 低リスク - BUILD_POSTSCRIPTの処理は標準的

## 6) レビュアーチェックリスト（最小）
- [ ] DYNAMIC_INITのターゲット別動作確認
- [ ] cookbook_redoxerの環境変数設定確認
- [ ] --locked使用時のCargo.lock存在確認
- [ ] 並列ビルドの安定性確認
