---
generated_at: 2026-01-22 22:50:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bin/repo.rs` - repoコマンドのメインソースコード（TUI実装含む）
- E-02: `src/bin/repo_builder.rs` - repo_builderコマンドのソースコード
- E-03: `src/bin/cookbook_redoxer.rs` - cookbook_redoxerコマンドのソースコード
- E-04: `REPO_HELP_STR`定数（repo.rs 42-75行目）- ヘルプメッセージ定義
- E-05: `CliCommand`列挙型（repo.rs 90-145行目）- コマンド種別定義
- E-06: `TuiApp`構造体（repo.rs 812-869行目）- TUIアプリケーション状態管理
- E-07: `FailurePrompt`構造体（repo.rs 1754-1784行目）- 失敗時プロンプト定義
- E-08: `run_tui_cook`関数（repo.rs 1012-1501行目）- TUIメインループ実装
- E-09: `draw_prompt`関数（repo.rs 1635-1707行目）- プロンプト描画実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TUIメイン画面が存在し、Fetch Queue、Cook Queue、Logパネルの3分割レイアウトを持つ | E-01, E-06, E-08 | ○ |
| C-02 | 失敗時プロンプトダイアログが存在し、Retry/Skip/Exitの選択肢を提供する | E-01, E-07, E-09 | ○ |
| C-03 | repo fetchコマンドが存在する | E-01, E-04, E-05 | ○ |
| C-04 | repo cookコマンドが存在し、TUIモードとCIモードを切り替え可能 | E-01, E-04, E-05, E-08 | ○ |
| C-05 | repo unfetchコマンドが存在する | E-01, E-04, E-05 | ○ |
| C-06 | repo cleanコマンドが存在する | E-01, E-04, E-05 | ○ |
| C-07 | repo pushコマンドが存在する | E-01, E-04, E-05 | ○ |
| C-08 | repo treeコマンドが存在する | E-01, E-04, E-05 | ○ |
| C-09 | repo findコマンドが存在する | E-01, E-04, E-05 | ○ |
| C-10 | repo_builderコマンドが存在し、repo.tomlを生成する | E-02 | ○ |
| C-11 | cookbook_redoxerコマンドが存在し、redoxerのラッパーとして機能する | E-03 | ○ |
| C-12 | ヘルプ画面が--helpまたは-hフラグで表示される | E-01, E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - すべての画面に対してソースコード上の根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードに基づいている

**注意点**:
- 本プロジェクトはGUIアプリケーションではなく、CLIツール＋TUIのビルドシステム
- 「画面」の定義をCLIコマンドインターフェースおよびTUI画面として解釈した
- ratatuiによるTUI実装は`repo.rs`内に集約されている

## 6) レビュアーチェックリスト（最小）
- [ ] TUIメイン画面のレイアウト（3分割）が正確に記載されているか確認
- [ ] 各CLIコマンドの説明が`REPO_HELP_STR`の内容と一致しているか確認
- [ ] 失敗時プロンプトの選択肢（Retry/Skip/Exit）が実装と一致しているか確認
- [ ] キー操作の説明が実際の`handle_main_event`関数の実装と一致しているか確認
