# 画面遷移図

本プロジェクト（Redox OS Build System）における画面遷移を示します。

## 1. repoコマンド全体の画面遷移

```mermaid
flowchart TD
    subgraph CLI["CLIインターフェース"]
        START([repo コマンド実行]) --> HELP{--help/-h?}
        HELP -->|Yes| HELP_SCREEN[ヘルプ画面]
        HELP -->|No| CMD{コマンド判定}

        CMD -->|fetch| FETCH[repo fetchコマンド画面]
        CMD -->|cook| COOK_CHECK{TUIモード?}
        CMD -->|unfetch| UNFETCH[repo unfetchコマンド画面]
        CMD -->|clean| CLEAN[repo cleanコマンド画面]
        CMD -->|push| PUSH[repo pushコマンド画面]
        CMD -->|tree| TREE[repo treeコマンド画面]
        CMD -->|find| FIND[repo findコマンド画面]

        COOK_CHECK -->|Yes<br/>CI環境変数未設定| TUI_MAIN
        COOK_CHECK -->|No<br/>CI環境変数設定| COOK[repo cookコマンド画面]

        FETCH --> END_SUCCESS([成功終了])
        FETCH --> END_FAIL([失敗終了])
        COOK --> END_SUCCESS
        COOK --> END_FAIL
        UNFETCH --> END_SUCCESS
        CLEAN --> END_SUCCESS
        PUSH --> END_SUCCESS
        PUSH --> END_FAIL
        TREE --> END_SUCCESS
        FIND --> END_SUCCESS
        HELP_SCREEN --> END_EXIT([終了])
    end

    subgraph TUI["TUIインターフェース"]
        TUI_MAIN[TUIメイン画面]
        TUI_MAIN -->|ビルド失敗| PROMPT[失敗時プロンプトダイアログ]
        PROMPT -->|Retry| TUI_MAIN
        PROMPT -->|Skip| TUI_MAIN
        PROMPT -->|Exit| END_FAIL
        TUI_MAIN -->|全ビルド完了| REPO_BUILD[repo_builderコマンド画面]
        TUI_MAIN -->|cキー押下| END_FAIL
        REPO_BUILD --> END_SUCCESS
    end
```

## 2. TUIメイン画面の詳細構成

```mermaid
flowchart LR
    subgraph TUI_LAYOUT["TUIメイン画面レイアウト"]
        subgraph LEFT["左パネル"]
            FETCH_QUEUE[Fetch Queue<br/>キー: 1]
        end
        subgraph CENTER["中央パネル"]
            COOK_QUEUE[Cook Queue<br/>キー: 2]
        end
        subgraph RIGHT["右パネル"]
            LOG_PANEL[Log パネル<br/>PageUp/Down: スクロール<br/>End: ログ追従]
        end
    end

    FETCH_QUEUE -.->|フェッチ完了時<br/>パネル非表示| COOK_QUEUE
```

## 3. TUI画面状態遷移

```mermaid
stateDiagram-v2
    [*] --> TUIMain: repo cook実行<br/>（TUIモード）

    state TUIMain {
        [*] --> Fetching: レシピ開始
        Fetching --> Fetched: フェッチ成功
        Fetching --> FetchFailed: フェッチ失敗
        Fetched --> Cooking: クック開始
        Cooking --> Done: クック成功
        Cooking --> CookFailed: クック失敗
        FetchFailed --> FailurePrompt
        CookFailed --> FailurePrompt

        state FailurePrompt {
            [*] --> Exit: 選択中
            Exit --> Retry: 左/右キー
            Exit --> Skip: 左/右キー
            Retry --> Exit: 左/右キー
            Retry --> Skip: 左/右キー
            Skip --> Exit: 左/右キー
            Skip --> Retry: 左/右キー
        }

        FailurePrompt --> [*]: Exit選択
        FailurePrompt --> Fetching: Retry選択
        FailurePrompt --> Fetching: Skip選択<br/>（次のレシピへ）
    }

    TUIMain --> [*]: 全レシピ完了<br/>またはExit
```

## 4. CLIコマンド別の処理フロー

```mermaid
flowchart TD
    subgraph FETCH_FLOW["fetchコマンドフロー"]
        F1[レシピ名取得] --> F2[ソースダウンロード]
        F2 --> F3{成功?}
        F3 -->|Yes| F4[完了メッセージ]
        F3 -->|No| F5[エラーメッセージ]
        F5 --> F6{nonstopモード?}
        F6 -->|Yes| F1
        F6 -->|No| F7[終了]
    end

    subgraph COOK_FLOW["cookコマンドフロー"]
        C1[レシピ名取得] --> C2[fetch処理]
        C2 --> C3[build処理]
        C3 --> C4[package処理]
        C4 --> C5{成功?}
        C5 -->|Yes| C6[repo_builder実行]
        C5 -->|No| C7[エラー処理]
    end

    subgraph PUSH_FLOW["pushコマンドフロー"]
        P1[レシピ名取得] --> P2[pkgarアーカイブ取得]
        P2 --> P3[sysrootに展開]
        P3 --> P4[完了メッセージ]
    end
```

## 5. 補助ツールの関係

```mermaid
flowchart LR
    REPO[repo コマンド] -->|パッケージ公開| REPO_BUILDER[repo_builder コマンド]
    REPO_BUILDER -->|repo.toml生成| REPO_TOML[(repo.toml)]

    REPO -->|ビルド実行| COOKBOOK_REDOXER[cookbook_redoxer コマンド]
    COOKBOOK_REDOXER -->|redoxer呼び出し| REDOXER[redoxer]
```
