# 画面設計書 1-TUIメイン画面

## 概要

本ドキュメントは、Redox OS Build System（cookbook）のTUIメイン画面の設計仕様を定義します。この画面は`repo cook`コマンドをTUIモードで実行した際に表示される対話型ビルド管理インターフェースです。

### 本画面の処理概要

TUIメイン画面は、ratatuiライブラリを使用したターミナルベースのユーザーインターフェースで、複数のレシピを並列にフェッチ・ビルドする際の進捗状況をリアルタイムで可視化します。

**業務上の目的・背景**：Redox OSのパッケージビルドシステムにおいて、多数のレシピを一括でビルドする際、各レシピのフェッチ状態やビルド状態を視覚的に把握する必要があります。従来のCLI出力では進捗状況の把握が困難であったため、TUIを導入することでビルドプロセス全体の可視性を向上させ、エラー発生時の迅速な対応を可能にしています。

**画面へのアクセス方法**：`repo cook <レシピ名>...`コマンドを実行し、かつ環境変数`CI`が設定されていない場合に自動的にTUIモードで起動します。`repo cook --tui`フラグでも明示的にTUIモードを有効化できます。

**主要な操作・処理内容**：
1. Fetch Queue パネルでソースコードダウンロードの進捗を確認
2. Cook Queue パネルでビルド処理の進捗を確認
3. Log パネルでリアルタイムのビルドログを表示
4. キーボード操作によるログのスクロール、パネル切り替え、ビルドの停止

**画面遷移**：
- 遷移元：repo cookコマンド実行（TUIモード有効時）
- 遷移先：ビルド失敗時 → 失敗時プロンプトダイアログ、全ビルド完了時 → repo_builderコマンド（自動実行）

**権限による表示制御**：特になし。すべてのユーザーが同一の表示を閲覧可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 27 | fetchコマンド | 主機能 | Fetch Queueパネルでソースコードダウンロードの進捗表示と状態管理 |
| 28 | cookコマンド | 主機能 | Cook Queueパネルでビルド処理の進捗表示と状態管理 |
| 35 | 並列ビルドTUI | 主機能 | ratatuiベースの3分割レイアウトによる並列fetch/cookの進捗表示 |
| 36 | ビルドログ出力 | 補助機能 | Logパネルでのビルドログのリアルタイム表示とファイル保存 |
| 1 | レシピ解析 | API連携 | ビルド対象レシピのrecipe.toml解析 |
| 14 | 依存関係解決 | API連携 | ビルド対象パッケージの依存関係を再帰的に解決 |

## 画面種別

TUI（Terminal User Interface）- 対話型ターミナル画面

## URL/ルーティング

コマンドラインインターフェース経由でのアクセス：
```
repo cook [--tui] <recipe1> <recipe2> ...
```

## 入出力項目

### 入力項目（コマンドライン引数）

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| recipe | String[] | Yes | ビルド対象のレシピ名（複数指定可） |
| --cookbook | Path | No | recipesフォルダのパス（デフォルト: $PWD/recipes） |
| --repo | Path | No | repoフォルダのパス（デフォルト: $PWD/repo） |
| --with-package-deps | Flag | No | パッケージ依存関係を含める |
| --filesystem | Path | No | installerファイルでレシピビルドルールを上書き |

### 環境変数

| 変数名 | 型 | デフォルト | 説明 |
|--------|-----|----------|------|
| CI | Any | 未設定 | 設定するとTUIを無効化 |
| COOKBOOK_LOGS | Bool | !CI | ビルドログをキャプチャするか |
| COOKBOOK_NONSTOP | Bool | false | レシピ失敗時も継続するか |
| COOKBOOK_VERBOSE | Bool | true | 成功/失敗メッセージを表示するか |

## 表示項目

### 3分割レイアウト構成

| パネル名 | 位置 | 幅 | 説明 |
|---------|------|-----|------|
| Fetch Queue | 左 | 22文字固定 | フェッチ待ち・実行中のレシピ一覧 |
| Cook Queue | 中央 | 22文字固定 | ビルド待ち・実行中・完了のレシピ一覧 |
| Log | 右 | 残り領域 | 現在アクティブなジョブのログ出力 |

### Fetch Queue パネル表示項目

| 項目 | 表示形式 | 説明 |
|------|---------|------|
| スピナー | アニメーション文字（- \ | /） | フェッチ中を示す |
| レシピ名 | テキスト | パッケージ名 |
| ステータス色 | 黄色: フェッチ中、白: 待機中 | 状態を色で識別 |

### Cook Queue パネル表示項目

| 項目 | 表示形式 | 説明 |
|------|---------|------|
| アイコン | 文字（スピナー/X/空白） | 状態を示すアイコン |
| レシピ名 | テキスト | パッケージ名 |
| ステータス色 | シアン: フェッチ完了、黄色: ビルド中、緑: 完了、赤: 失敗 | 状態を色で識別 |

### Log パネル表示項目

| 項目 | 表示形式 | 説明 |
|------|---------|------|
| タイトル | "Fetch Log: {レシピ名}" または "Cook Log: {レシピ名}" | 現在表示中のログ種別とレシピ |
| ログ内容 | ANSIカラー対応テキスト | ビルド出力のリアルタイム表示 |
| 操作説明 | フッターテキスト | 利用可能なキー操作の説明 |

## イベント仕様

### 1-キーボード操作

| キー | 処理内容 |
|------|---------|
| 1 | Fetch Logの表示に切り替え |
| 2 | Cook Logの表示に切り替え |
| c | ビルドプロセス全体を停止（kill_everything関数を実行） |
| PageUp | ログを20行上にスクロール |
| PageDown | ログを20行下にスクロール |
| Up | ログを1行上にスクロール |
| Down | ログを1行下にスクロール |
| End | 自動スクロールを有効化（ログ末尾を追従） |
| Home | ログ先頭に移動、自動スクロールを無効化 |

### 2-ステータス更新イベント

| イベント | 発生条件 | 処理内容 |
|---------|---------|---------|
| StartFetch | フェッチ開始時 | active_fetchを更新、ログバッファを初期化 |
| Fetched | フェッチ成功時 | ステータスをFetchedに更新、cook_queueに追加 |
| FailFetch | フェッチ失敗時 | 失敗時プロンプトダイアログを表示 |
| StartCook | ビルド開始時 | active_cookを更新、ログバッファを初期化 |
| Cooked | ビルド成功時 | ステータスをDoneに更新 |
| FailCook | ビルド失敗時 | 失敗時プロンプトダイアログを表示 |
| PushLog | ログ受信時 | ログバッファに追加、表示を更新 |
| FlushLog | ログ書き込み時 | ログファイルに保存 |
| FetchThreadFinished | 全フェッチ完了時 | fetch_completeをtrue、左パネルを非表示 |
| CookThreadFinished | 全ビルド完了時 | cook_completeをtrue、TUIを終了 |

## データベース更新仕様

本画面はファイルシステムベースの操作を行い、データベースは使用しません。

### ファイルシステム操作

| 操作 | 対象パス | 操作種別 | 概要 |
|------|---------|---------|------|
| ログ保存 | build/logs/{target}/{recipe}.log | WRITE | ビルドログをファイルに保存 |
| ソース取得 | recipes/{category}/{recipe}/source | CREATE | フェッチ処理でソースコードを配置 |
| ビルド成果物 | recipes/{category}/{recipe}/target | CREATE/UPDATE | ビルド処理で成果物を生成 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG_NO_LOGS | 情報 | "No logs yet" | ログが存在しない場合 |
| MSG_KEYS | 情報 | "Keys: [c] Stop [PageUp/Down] Scroll..." | 常時フッターに表示 |
| MSG_UNRENDERABLE | 警告 | "--unrenderable line--" | ANSI解析に失敗した行 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| フェッチ失敗 | 失敗時プロンプトダイアログを表示し、Retry/Skip/Exitを選択可能 |
| ビルド失敗 | 失敗時プロンプトダイアログを表示し、Retry/Skip/Exitを選択可能 |
| ノンストップモード時の失敗 | 自動的にSkipし、次のレシピに進む |
| IO Error | ログパネルに"[IO Error] {詳細}"を表示 |
| TUIスレッド切断 | ログリーダースレッドを終了 |

## 備考

- TUIはratatuiライブラリとtermionバックエンドを使用して実装
- フェッチとビルドは別スレッドで並列実行される
- ログはPTY（擬似端末）経由で取得し、ANSIエスケープシーケンスを保持
- 環境変数CIが設定されている場合、TUIは無効化されCLIモードで動作
- ティックレートは100msで画面を更新

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

TUI画面の状態管理に使用されるデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | repo.rs | `src/bin/repo.rs` | TuiApp構造体（812-836行目）でTUI全体の状態を管理 |
| 1-2 | repo.rs | `src/bin/repo.rs` | RecipeStatus列挙型（772-780行目）でレシピの状態を定義 |
| 1-3 | repo.rs | `src/bin/repo.rs` | StatusUpdate列挙型（782-794行目）でスレッド間メッセージを定義 |

**読解のコツ**: TuiAppは状態管理の中心。recipes, fetch_queue, cook_queue, logs, active_fetch, active_cookフィールドが主要な状態を保持。

#### Step 2: エントリーポイントを理解する

TUIモードの起動から終了までの流れを把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | repo.rs | `src/bin/repo.rs` | main_inner関数（182-249行目）でコマンドを解析し、TUIモード判定 |
| 2-2 | repo.rs | `src/bin/repo.rs` | run_tui_cook関数（1012-1501行目）がTUIのメインループ |

**主要処理フロー**:
1. **194行目**: `command == CliCommand::Cook && config.cook.tui`でTUIモード判定
2. **195行目**: `run_tui_cook`関数を呼び出してTUIを起動
3. **1016-1017行目**: mpsc::channelでスレッド間通信を確立
4. **1027-1110行目**: Cooker Thread（ビルド実行スレッド）を起動
5. **1136-1218行目**: Fetcher Thread（フェッチ実行スレッド）を起動
6. **1228-1488行目**: メインループで画面描画と入力処理

#### Step 3: 画面描画を理解する

ratatuiによる3分割レイアウトの描画ロジックを把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | repo.rs | `src/bin/repo.rs` | terminal.draw（1230-1475行目）内で画面描画 |
| 3-2 | repo.rs | `src/bin/repo.rs` | Layout::default（1240-1243行目）で3分割レイアウトを定義 |
| 3-3 | repo.rs | `src/bin/repo.rs` | fetch_items（1247-1265行目）でFetch Queueのリスト項目を生成 |
| 3-4 | repo.rs | `src/bin/repo.rs` | cook_items（1274-1300行目）でCook Queueのリスト項目を生成 |
| 3-5 | repo.rs | `src/bin/repo.rs` | log_lines（1356-1414行目）でログパネルの内容を生成 |

**主要処理フロー**:
- **1234-1243行目**: Constraint::Length(22)で左・中央パネル固定幅、Constraint::Min(20)で右パネル可変幅
- **1252-1264行目**: RecipeStatusに応じてスタイル（色）とアイコン（スピナー）を設定
- **1387-1399行目**: ANSIエスケープシーケンスをratatui形式に変換（into_text）

#### Step 4: 入力処理を理解する

キーボード・マウスイベントの処理ロジックを把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | repo.rs | `src/bin/repo.rs` | handle_main_event関数（1517-1597行目）でキーボード入力を処理 |
| 4-2 | repo.rs | `src/bin/repo.rs` | handle_prompt_input関数（1610-1633行目）でダイアログ入力を処理 |

**主要処理フロー**:
- **1520-1526行目**: '1'/'2'キーでログ表示を切り替え
- **1526-1529行目**: 'c'キーでkill_everything関数を呼び出し
- **1530-1548行目**: スクロール系キーでlog_scrollを更新

#### Step 5: 状態更新を理解する

スレッドからのメッセージによる状態更新ロジックを把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | repo.rs | `src/bin/repo.rs` | TuiApp::update_status関数（921-1009行目）で状態を更新 |

**主要処理フロー**:
- **923-929行目**: StartFetchでactive_fetchを更新、ログバッファを初期化
- **942-956行目**: PushLogでログバッファに追加、改行で分割
- **991-1008行目**: キューの再計算（pending→fetch_queue, fetched→cook_queue）

### プログラム呼び出し階層図

```
main() [repo.rs:174]
    │
    ├─ main_inner() [repo.rs:182]
    │      │
    │      ├─ parse_args() [repo.rs:373]
    │      │
    │      └─ run_tui_cook() [repo.rs:1012]
    │             │
    │             ├─ [thread] Cooker Thread [repo.rs:1027-1110]
    │             │      └─ handle_cook() [repo.rs:568]
    │             │             ├─ build() [cook_build.rs]
    │             │             └─ package() [package.rs]
    │             │
    │             ├─ [thread] Fetcher Thread [repo.rs:1136-1218]
    │             │      └─ handle_fetch() [repo.rs:553]
    │             │             └─ fetch() [fetch.rs:117]
    │             │
    │             ├─ [thread] Input Thread [repo.rs:1121-1129]
    │             │
    │             └─ [main loop] terminal.draw() [repo.rs:1230-1475]
    │                    ├─ TuiApp::get_active_log() [repo.rs:879]
    │                    ├─ handle_main_event() [repo.rs:1517]
    │                    └─ handle_prompt_input() [repo.rs:1610]
    │
    └─ publish_packages() [repo.rs:357]
           └─ repo_builder [repo_builder.rs]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

コマンドライン引数 ────▶ parse_args() ────▶ CliConfig, recipes
       │
       ▼
  recipe.toml ────────▶ CookRecipe::from_path() ────▶ CookRecipeリスト
       │
       ▼
  [Fetcher Thread]
  Git/Tar/Path ────────▶ fetch() ────▶ source_dir
       │                    │
       │                    ├─────▶ StatusUpdate::Fetched ────▶ [TUI]
       │                    │
       ▼                    ▼
  [Cooker Thread]      (work_rx)
  source_dir ──────────▶ handle_cook() ────▶ stage_dir, .pkgar
       │                    │
       │                    ├─────▶ StatusUpdate::Cooked ────▶ [TUI]
       │                    │
       ▼                    ▼
  [Logger]             (status_tx)
  PTY出力 ─────────────▶ PushLog ────▶ TuiApp.logs ────▶ [TUI Log Panel]
       │
       ▼
  build/logs/*.log ◀── FlushLog
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| repo.rs | `src/bin/repo.rs` | ソース | repoコマンドのエントリーポイント、TUI実装 |
| fetch.rs | `src/cook/fetch.rs` | ソース | ソースコード取得処理 |
| cook_build.rs | `src/cook/cook_build.rs` | ソース | ビルド処理 |
| package.rs | `src/cook/package.rs` | ソース | パッケージング処理 |
| pty.rs | `src/cook/pty.rs` | ソース | PTYセットアップ、ログキャプチャ |
| recipe.rs | `src/recipe.rs` | ソース | レシピ解析 |
| config.rs | `src/config.rs` | ソース | 設定管理（CookConfig） |
| Cargo.toml | `Cargo.toml` | 設定 | 依存関係（ratatui, termion等） |
