# 画面設計書 10-repo_builderコマンド画面

## 概要

本ドキュメントは、Redox OS Build System（cookbook）の`repo_builder`コマンド画面の設計仕様を定義します。この画面はビルド済みパッケージをリポジトリに公開するCLIインターフェースです。

### 本画面の処理概要

`repo_builder`コマンドは、指定されたレシピのビルド済みパッケージ（pkgar形式）をリポジトリディレクトリにコピーし、パッケージ一覧を管理する`repo.toml`を生成・更新します。オプションでAppStreamメタデータの生成にも対応します。

**業務上の目的・背景**：Redox OSのパッケージ配布システムにおいて、ビルド済みパッケージをリポジトリとして公開する必要があります。repo_builderは、pkgarファイルとメタデータ（stage.toml）をリポジトリディレクトリに配置し、パッケージマネージャーが参照するrepo.tomlを自動生成します。これにより、パッケージの配布準備が自動化されます。

**画面へのアクセス方法**：ターミナルから`repo_builder <REPO_DIR> <recipe1> <recipe2> ...`コマンドを実行します。

**主要な操作・処理内容**：
1. 指定されたレシピのパッケージを再帰的に解決
2. pkgarファイルとstage.tomlをリポジトリにコピー
3. 古いパッケージの識別と記録
4. repo.tomlの生成・更新
5. （オプション）AppStreamメタデータの生成

**画面遷移**：
- 遷移元：ターミナル（コマンドライン）/ ビルドスクリプト
- 遷移先：なし（パッケージ公開処理のみ）

**権限による表示制御**：特になし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 34 | publishコマンド | 主機能 | リポジトリへのパッケージ公開 |
| 14 | 依存関係解決 | API連携 | パッケージ依存関係の再帰的解決 |
| 1 | レシピ解析 | API連携 | レシピのロードとパッケージ情報取得 |

## 画面種別

CLI（Command Line Interface）- テキストベースコマンド画面

## URL/ルーティング

コマンドラインインターフェース経由でのアクセス：
```
repo_builder <REPO_DIR> <recipe1> <recipe2> ...
```

## 入出力項目

### 入力項目（コマンドライン引数）

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| REPO_DIR | Path | Yes | リポジトリ出力ディレクトリのパス |
| recipe | String[] | Yes | 公開対象のレシピ名（複数指定可） |

### 環境変数

| 変数名 | 型 | デフォルト | 説明 |
|--------|-----|----------|------|
| COOKBOOK_APPSTREAM | String | (未設定) | "true"設定時にAppStreamメタデータを生成 |
| ROOT | Path | "." | プロジェクトルートディレクトリ |
| TARGET | String | "x86_64-unknown-linux-gnu" | ターゲットアーキテクチャ |
| COOKBOOK_CROSS_TARGET | String | (空) | 設定時はクロスターゲットビルドとしてスキップ |

### 出力項目

| 項目 | 型 | 説明 |
|------|-----|------|
| repo.toml | File | パッケージ一覧とバージョン情報 |
| *.pkgar | File | パッケージアーカイブ（リポジトリにコピー） |
| *.toml | File | パッケージメタデータ（stage.toml由来） |
| repo-appstream.pkgar | File | AppStreamメタデータ（オプション） |

## 表示項目

### ターミナル出力

| メッセージ | 色 | 表示条件 |
|----------|-----|---------|
| "repo - publishing {recipe}" | 緑色（ANSI 155） | パッケージ公開時 |
| "repo - generating appstream data" | 緑色（ANSI 155） | AppStream生成時 |
| "repo - generating repo.toml" | 緑色（ANSI 155） | repo.toml生成時 |
| "repo - marking {recipe} as outdated" | 赤色（ANSI 91） | パッケージが古い場合 |
| "recipe {name} not found" | デフォルト | レシピが見つからない場合 |
| "recipe {name} is missing stage.toml" | デフォルト | stage.tomlがない場合 |

### 出力例

```
repo - publishing hello
repo - publishing world
repo - marking old_package as outdated: BuildError
repo - generating appstream data
repo - generating repo.toml
```

## イベント仕様

### 1-パッケージ公開処理

| 処理ステップ | 処理内容 |
|-------------|---------|
| 引数解析 | CliConfig::parse_args()でREPO_DIRとレシピリストを取得 |
| 対象フィルタ | ホストパッケージを除外（!is_host()） |
| 依存関係解決 | Package::new_recursive_nonstop()で再帰的に依存関係を解決 |
| レシピ処理ループ | 各レシピのpkgarとstage.tomlをリポジトリにコピー |
| 鮮度チェック | is_newer()で更新が必要な場合のみコピー |
| AppStreamメタデータ収集 | usr/share/metainfoが存在する場合に記録 |

### 2-repo.toml生成処理

| 処理ステップ | 処理内容 |
|-------------|---------|
| 既存toml読み込み | 既存のrepo.tomlを読み込み、packages/outdated_packagesをマージ |
| tomlスキャン | リポジトリ内の*.tomlファイルからblake3/versionを取得 |
| シリアライズ | Repository構造体をTOML形式でシリアライズ |
| ファイル書き込み | repo.tomlに出力 |

### 3-AppStream生成処理（オプション）

| 処理ステップ | 処理内容 |
|-------------|---------|
| 環境確認 | COOKBOOK_APPSTREAM="true"の場合のみ実行 |
| ディレクトリ準備 | build/{target}/appstreamディレクトリを作成 |
| compose実行 | appstreamcli composeコマンドを実行 |
| pkgar作成 | pkgar::create()でメタデータをpkgarにパッケージ化 |

## データベース更新仕様

本画面はファイルシステムへの書き込みを行います。

### 生成/更新するファイル

| ファイル | 用途 |
|---------|------|
| repo/{target}/repo.toml | パッケージ一覧（名前→バージョン/blake3ハッシュ） |
| repo/{target}/*.pkgar | パッケージアーカイブ（コピー） |
| repo/{target}/*.toml | パッケージメタデータ（stage.tomlからコピー） |
| repo/{target}/repo-appstream.pkgar | AppStreamメタデータ（オプション） |

### 参照するファイル

| ファイル | 用途 |
|---------|------|
| recipes/{category}/{recipe}/recipe.toml | レシピ定義 |
| recipes/{category}/{recipe}/target/{target}/stage.toml | ビルド後メタデータ |
| recipes/{category}/{recipe}/target/{target}/{package}/stage.pkgar | パッケージアーカイブ |
| build/id_ed25519.toml | Ed25519秘密鍵（署名用） |

### repo.toml構造

```toml
[packages]
hello = "abc123def456..."  # blake3ハッシュまたはバージョン
world = "xyz789..."

[outdated_packages]
old_pkg = { source_identifier = "...", commit_identifier = "...", time_identifier = "..." }
```

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG_PUBLISH | 進捗 | "repo - publishing {recipe}" | パッケージ公開時 |
| MSG_APPSTREAM | 進捗 | "repo - generating appstream data" | AppStream生成時 |
| MSG_REPO_TOML | 進捗 | "repo - generating repo.toml" | repo.toml生成時 |
| MSG_OUTDATED | 警告 | "repo - marking {recipe} as outdated: {error}" | ビルド失敗パッケージ |
| MSG_NOT_FOUND | エラー | "recipe {name} not found" | レシピが見つからない |
| MSG_UNREADABLE | エラー | "recipe {name} unable to read" | レシピ読み込み失敗 |
| MSG_MISSING_STAGE | エラー | "recipe {name} is missing stage.toml" | stage.toml欠落 |
| MSG_SOURCE_UNIDENT | エラー | "source of {recipe} is not identifiable: {error}" | ソース識別失敗 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| レシピが見つからない | 警告を出力して次のレシピに進む |
| レシピ読み込み失敗 | 警告を出力して次のレシピに進む |
| stage.toml欠落 | 警告を出力して次のレシピに進む |
| ゼロパッケージ | "Zero packages are passing the build"でエラー終了 |
| appstreamcli失敗 | "appstreamcli failed"でエラー終了 |
| ファイルコピー失敗 | Rustのエラーハンドリングで伝播 |
| クロスターゲットビルド | 何もせずに正常終了 |

## 備考

- ホストパッケージ（is_host()=true）は公開対象から除外される
- クロスターゲットビルド（COOKBOOK_CROSS_TARGET設定時）は処理をスキップ
- is_newer()による鮮度チェックで、変更がない場合はコピーをスキップ
- outdated_packagesはビルドに失敗したパッケージを追跡し、将来のリビルド判断に使用
- source_identifierは、ソースのバージョン追跡に使用（Git commitハッシュなど）
- AppStream対応は環境変数COOKBOOK_APPSTREAM="true"で有効化

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | repo_builder.rs | `src/bin/repo_builder.rs` | main関数（49-53行目）でinit_identとpublish_packagesを呼び出し |
| 1-2 | repo_builder.rs | `src/bin/repo_builder.rs` | CliConfig::parse_args()（36-46行目）で引数解析 |

**主要処理フロー**:
1. **49-53行目**: main()でinit_ident()を呼び出し、CliConfigをパースしてpublish_packages()を実行
2. **36-46行目**: REPO_DIR（第1引数）とレシピリスト（残り引数）、環境変数COOKBOOK_APPSTREAMをパース

#### Step 2: パッケージ公開処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | repo_builder.rs | `src/bin/repo_builder.rs` | publish_packages関数（56-276行目） |
| 2-2 | repo_builder.rs | `src/bin/repo_builder.rs` | ホストパッケージ除外（63-68行目） |
| 2-3 | repo_builder.rs | `src/bin/repo_builder.rs` | 依存関係解決（84行目） |
| 2-4 | repo_builder.rs | `src/bin/repo_builder.rs` | パッケージコピーループ（96-132行目） |

**主要処理フロー**:
- **63-68行目**: is_host()でホストパッケージを除外
- **75-77行目**: COOKBOOK_CROSS_TARGETが設定されていたらスキップ
- **84行目**: Package::new_recursive_nonstop()で依存関係を再帰的に解決
- **96-132行目**: 各レシピに対してpkgarとstage.tomlをリポジトリにコピー
- **120-126行目**: is_newer()で更新が必要な場合のみコピー

#### Step 3: repo.toml生成処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | repo_builder.rs | `src/bin/repo_builder.rs` | 既存repo.toml読み込み（219-241行目） |
| 3-2 | repo_builder.rs | `src/bin/repo_builder.rs` | tomlスキャン（243-266行目） |
| 3-3 | repo_builder.rs | `src/bin/repo_builder.rs` | repo.toml書き込み（268-273行目） |

**主要処理フロー**:
- **221-229行目**: 既存のrepo.tomlを読み込んでpackagesをマージ
- **243-266行目**: リポジトリ内の*.tomlをスキャンしてblake3/versionを取得
- **268-273行目**: Repository構造体をシリアライズしてrepo.tomlに書き込み

#### Step 4: AppStream生成処理を理解する（オプション）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | repo_builder.rs | `src/bin/repo_builder.rs` | AppStream生成（134-174行目） |

**主要処理フロー**:
- **135-136行目**: config.appstreamがtrueの場合のみ実行
- **151-166行目**: appstreamcli composeコマンドを実行
- **168-172行目**: pkgar::create()でAppStreamメタデータをpkgar化

#### Step 5: 古いパッケージの処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | repo_builder.rs | `src/bin/repo_builder.rs` | outdated_packages処理（176-215行目） |

**主要処理フロー**:
- **177-180行目**: recipe_mapからエラーのあるパッケージを抽出
- **195-197行目**: fetch_get_source_info()でソース識別子を取得
- **199-212行目**: ソース識別失敗時は"missing_source"で記録

### プログラム呼び出し階層図

```
main() [repo_builder.rs:49]
    │
    ├─ init_ident() [ident.rs]
    │
    ├─ CliConfig::parse_args() [repo_builder.rs:36]
    │
    └─ publish_packages() [repo_builder.rs:56]
           │
           ├─ Package::new_recursive_nonstop() [pkg crate]
           │      └─ (依存関係の再帰的解決)
           │
           ├─ [パッケージコピーループ] [repo_builder.rs:96-132]
           │      ├─ recipes::find()
           │      ├─ CookRecipe::from_path()
           │      ├─ is_newer() [repo_builder.rs:16]
           │      └─ fs::copy()
           │
           ├─ [AppStream生成] [repo_builder.rs:134-174] (オプション)
           │      ├─ Command::new("appstreamcli").arg("compose")...
           │      └─ pkgar::create()
           │
           ├─ [outdated処理] [repo_builder.rs:176-215]
           │      └─ fetch::fetch_get_source_info()
           │
           └─ [repo.toml生成] [repo_builder.rs:217-273]
                  ├─ fs::read_dir()
                  ├─ toml::from_str()
                  └─ File::create().write_all()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

コマンドライン引数 ────▶ CliConfig::parse_args()
       │                      │
       ▼                      ▼
  recipe_list ─────────▶ Package::new_recursive_nonstop()
       │                      │
       ▼                      ▼
  (recipe_list,          [パッケージコピーループ]
   recipe_map) ─────────────▶│
       │                      ├──▶ pkgarコピー ────────▶ repo/{target}/*.pkgar
       │                      └──▶ tomlコピー ────────▶ repo/{target}/*.toml
       │
       ▼
  recipe_map ──────────▶ [outdated処理] ────────▶ outdated_packages
  (エラーあり)                │
       │                      ▼
       │               fetch_get_source_info()
       │
       ▼
  metainfo存在 ─────────▶ [AppStream生成] ────────▶ repo-appstream.pkgar
  (オプション)               │
       │                      ▼
       │               appstreamcli compose
       │                      │
       │                      ▼
       │               pkgar::create()
       │
       ▼
  packages,            [repo.toml生成]
  outdated_packages ────────▶│
       │                      ├──▶ 既存toml読み込み
       │                      ├──▶ *.tomlスキャン
       │                      └──▶ シリアライズ ────────▶ repo/{target}/repo.toml
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| repo_builder.rs | `src/bin/repo_builder.rs` | ソース | メインロジック（277行） |
| fetch.rs | `src/cook/fetch.rs` | ソース | fetch_get_source_info()でソース識別子を取得 |
| ident.rs | `src/cook/ident.rs` | ソース | init_ident()、get_ident()でビルド識別子を管理 |
| package.rs | `src/cook/package.rs` | ソース | package_stage_paths()でステージパスを取得 |
| recipe.rs | `src/recipe.rs` | ソース | CookRecipe構造体とfrom_path() |
