# 画面設計書 11-cookbook_redoxerコマンド画面

## 概要

本ドキュメントは、Redox OSビルドシステムにおける `cookbook_redoxer` コマンドのCLIインターフェースについて記述した画面設計書である。

### 本画面の処理概要

本画面は、Redox OS向けのクロスコンパイル環境でコマンドを実行するためのラッパーCLIインターフェースである。

**業務上の目的・背景**：Redox OSはUnixライクなマイクロカーネルOSであり、Linux等の既存OS上でRedox向けのパッケージをビルドするためにはクロスコンパイル環境が必要となる。`cookbook_redoxer`は外部ライブラリである`redoxer`クレートをラップし、ビルド時のコマンド実行を適切なクロスコンパイル環境内で行うことを可能にする。これにより、開発者はホストOS上でRedox向けのパッケージを効率的にビルドできる。

**画面へのアクセス方法**：
- `repo cook`コマンドの内部処理から自動的に呼び出される
- `src/cook/cook_build.rs`の385行目付近で`cookbook_redoxer`バイナリが起動される
- 直接コマンドラインから`cookbook_redoxer <サブコマンド> [引数...]`として実行することも可能

**主要な操作・処理内容**：
1. コマンドライン引数を受け取り、redoxerライブラリに渡す形式に変換
2. `write-exec`サブコマンドの場合、COOKBOOK_STAGE環境変数からステージディレクトリ情報を取得
3. ステージディレクトリが設定されている場合、`--root`と`--folder`オプションを引数に挿入
4. すべてのフラグが正しく処理されるよう、引数リストに`--`セパレータを挿入
5. `redoxer::main()`関数を呼び出してクロスコンパイル環境内でコマンドを実行

**画面遷移**：
- 遷移元：`repo cook`コマンド処理（src/cook/cook_build.rs）からの内部呼び出し
- 遷移先：処理完了後は呼び出し元に制御を返す（終了コードを返却）

**権限による表示制御**：特になし（CLIツールのため）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 52 | cookbook_redoxer | 主機能 | Redox向けクロスコンパイル環境でのコマンド実行 |
| 51 | ターゲット判定 | API連携 | パッケージ名からビルドターゲットの判定 |
| 54 | CMakeクロスファイル生成 | 補助機能 | CMakeツールチェインファイル生成（redoxer経由） |
| 55 | Mesonクロスファイル生成 | 補助機能 | Mesonクロスファイル生成（redoxer経由） |
| 53 | 動的/静的リンク切替 | 補助機能 | DYNAMIC_INIT関数での動的リンク設定適用 |

## 画面種別

CLI（コマンドラインインターフェース）

## URL/ルーティング

コマンドライン実行：
```bash
cookbook_redoxer <サブコマンド> [引数...]
cookbook_redoxer write-exec [引数...]
```

## 入出力項目

### 入力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| サブコマンド | 文字列 | Yes | 実行するredoxerサブコマンド（例：env, write-exec） |
| 引数 | 文字列リスト | No | サブコマンドに渡す追加引数 |

### 環境変数入力

| 環境変数名 | 説明 | デフォルト値 |
|-----------|------|-------------|
| COOKBOOK_STAGE | ビルドステージディレクトリパス | - |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 終了コード | 整数 | redoxerコマンドの実行結果（0: 成功, その他: エラー） |
| 標準出力 | テキスト | redoxerコマンドからの出力 |
| 標準エラー出力 | テキスト | redoxerコマンドからのエラーメッセージ |

## 表示項目

CLIコマンドのため、出力はredoxerライブラリが生成するテキストメッセージとなる。

## イベント仕様

### 1-コマンド実行

1. プログラム起動時にコマンドライン引数を収集
2. 引数が2つ以上ある場合（サブコマンドあり）：
   - 引数リストの3番目の位置に`--`セパレータを挿入
   - サブコマンドが`write-exec`の場合：
     - `COOKBOOK_STAGE`環境変数をチェック
     - 設定されていれば`--root`と`--folder`オプションを引数に追加
3. `redoxer::main(&args)`を呼び出し
4. redoxerの終了コードでプロセス終了

## データベース更新仕様

データベースは使用しない。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| エラー | redoxerライブラリからのエラーメッセージ | コマンド実行失敗時 |
| 情報 | redoxerライブラリからの進捗メッセージ | 処理中 |

## 例外処理

| 例外状況 | 処理内容 |
|----------|----------|
| 引数なし | redoxerのデフォルト動作に委譲 |
| COOKBOOK_STAGE未設定 | write-execでも追加オプションなしでredoxerを実行 |
| redoxer実行エラー | redoxerからの終了コードをそのまま返却 |

## 備考

- 本コマンドは`repo cook`の内部処理から呼び出されることが主な使用方法
- redoxerライブラリ（外部依存）の詳細機能については、redoxerプロジェクトのドキュメントを参照
- Redox OS上で実行される場合は本コマンドは使用されず、直接bashが使用される（src/cook/cook_build.rs 379-383行目）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本コマンドはシンプルなラッパーであり、主要なデータ構造は引数配列（`Vec<String>`）のみである。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | cookbook_redoxer.rs | `src/bin/cookbook_redoxer.rs` | 引数処理の全体構造を理解する |

**読解のコツ**: Rustの`std::env::args()`がコマンドライン引数を`Vec<String>`として返すことを理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cookbook_redoxer.rs | `src/bin/cookbook_redoxer.rs` | main関数の処理フロー |

**主要処理フロー**:
1. **4行目**: コマンドライン引数を収集 `env::args().collect()`
2. **6行目**: 引数数のチェック `args.len() >= 2`
3. **7行目**: `--`セパレータの挿入
4. **8-15行目**: write-execサブコマンド時の特別処理
5. **17行目**: redoxerライブラリのmain関数呼び出し

#### Step 3: 呼び出し元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cook_build.rs | `src/cook/cook_build.rs` | cookbook_redoxerの呼び出し箇所 |

**主要処理フロー**:
- **379-391行目**: Redox以外のプラットフォームでcookbook_redoxerを使用する条件分岐
- **385行目**: cookbook_redoxerバイナリパスの取得
- **388-390行目**: Commandオブジェクトの構築とCOOKBOOK_REDOXER環境変数の設定

#### Step 4: 関連するビルドスクリプトを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | script.rs | `src/cook/script.rs` | BUILD_PRESCRIPT, DYNAMIC_INIT関数の定義 |

**主要処理フロー**:
- DYNAMIC_INIT関数がビルドスクリプト内で呼び出され、動的リンク設定を適用

### プログラム呼び出し階層図

```
repo cook (src/bin/repo.rs)
    │
    └─ handle_cook (src/bin/repo.rs)
           │
           └─ build (src/cook/cook_build.rs:170)
                  │
                  └─ Command::new(&cookbook_redoxer) (385行目)
                         │
                         └─ cookbook_redoxer (src/bin/cookbook_redoxer.rs)
                                │
                                └─ redoxer::main(&args) (17行目)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

コマンドライン引数 ─────────┐
                           │
                           ▼
                    ┌────────────────┐
                    │ args収集       │
                    │ (env::args())  │
                    └───────┬────────┘
                           │
COOKBOOK_STAGE ────────────┤
環境変数                    │
                           ▼
                    ┌────────────────┐
                    │ 引数変換処理   │
                    │ --root/--folder│
                    │ 挿入           │
                    └───────┬────────┘
                           │
                           ▼
                    ┌────────────────┐
                    │ redoxer::main  │
                    │ 呼び出し       │─────────▶ 標準出力/エラー出力
                    └───────┬────────┘
                           │
                           ▼
                      終了コード
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cookbook_redoxer.rs | `src/bin/cookbook_redoxer.rs` | ソース | cookbook_redoxerコマンドのエントリーポイント |
| cook_build.rs | `src/cook/cook_build.rs` | ソース | cookbook_redoxerの呼び出し元、ビルド処理 |
| script.rs | `src/cook/script.rs` | ソース | DYNAMIC_INIT等のビルドスクリプト定義 |
| fetch.rs | `src/cook/fetch.rs` | ソース | フェッチ処理でのcookbook_redoxer使用（491行目） |
| Cargo.toml | `Cargo.toml` | 設定 | cookbook_redoxerバイナリの定義とredoxer依存関係 |
