# 画面設計書 12-ヘルプ画面

## 概要

本ドキュメントは、Redox OSビルドシステムにおける `repo` コマンドのヘルプ情報を表示するCLIインターフェースについて記述した画面設計書である。

### 本画面の処理概要

本画面は、`repo`コマンドの使用方法、利用可能なサブコマンド、オプションフラグ、環境変数設定について包括的なヘルプ情報を提供するCLIインターフェースである。

**業務上の目的・背景**：`repo`コマンドはRedox OSのパッケージビルドシステムの中核となるCLIツールである。開発者がこのツールを効果的に使用するためには、利用可能なコマンド、フラグ、環境変数の設定方法を理解する必要がある。本ヘルプ画面は、開発者がコマンドの使用方法を素早く参照できるようにすることで、ビルドプロセスの効率化と学習コストの軽減を目的としている。

**画面へのアクセス方法**：
- `repo --help` または `repo -h` コマンドを実行
- 引数なしで `repo` コマンドを実行

**主要な操作・処理内容**：
1. コマンドライン引数を解析
2. `--help`または`-h`フラグの有無、または引数なしを検出
3. 定数`REPO_HELP_STR`に定義されたヘルプテキストを標準出力に表示
4. 終了コード1でプログラム終了

**画面遷移**：
- 遷移元：ターミナルからの直接コマンド実行
- 遷移先：なし（ヘルプ表示後にプログラム終了）

**権限による表示制御**：特になし（CLIツールのため）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 27 | fetchコマンド | 補助機能 | fetchコマンドの説明表示 |
| 28 | cookコマンド | 補助機能 | cookコマンドの説明表示 |
| 29 | unfetchコマンド | 補助機能 | unfetchコマンドの説明表示 |
| 30 | cleanコマンド | 補助機能 | cleanコマンドの説明表示 |
| 31 | pushコマンド | 補助機能 | pushコマンドの説明表示 |
| 32 | treeコマンド | 補助機能 | treeコマンドの説明表示 |
| 33 | findコマンド | 補助機能 | findコマンドの説明表示 |

## 画面種別

CLI（コマンドラインインターフェース）- ヘルプ情報表示

## URL/ルーティング

コマンドライン実行：
```bash
repo --help
repo -h
repo          # 引数なしの場合もヘルプを表示
```

## 入出力項目

### 入力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| --help | フラグ | No | ヘルプ表示フラグ（長形式） |
| -h | フラグ | No | ヘルプ表示フラグ（短形式） |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ヘルプテキスト | テキスト | コマンドの使用方法と設定オプションの説明 |
| 終了コード | 整数 | 1（ヘルプ表示後は常に1で終了） |

## 表示項目

### ヘルプテキスト内容

```
    Usage: repo <command> [flags] <recipe1> <recipe2> ...

    command list:
        fetch     download recipe sources
        cook      build recipe packages
        unfetch   delete recipe sources
        clean     delete recipe artifacts
        push      extract package into sysroot
        find      find path of recipe packages
        tree      show tree of recipe packages

    common flags:
        --cookbook=<cookbook_dir>  the "recipes" folder, default to $PWD/recipes
        --repo=<repo_dir>          the "repo" folder, default to $PWD/repo
        --sysroot=<sysroot_dir>    the "root" folder used for "push" command
            For Redox, defaults to "/", else default to $PWD/sysroot
        --with-package-deps        include package deps
        --all                      apply to all recipes in <cookbook_dir>
        --category=<category>      apply to all recipes in <cookbook_dir>/<category>
        --filesystem=<filesystem>  override recipes config using installer file
        --repo-binary              override recipes config to use repo_binary

    cook env and their defaults:
        CI=                         set to any value to disable TUI
        COOKBOOK_LOGS=              whether to capture build logs (default is !CI)
        COOKBOOK_OFFLINE=false      prevent internet access if possible
                                        ignored when command "fetch" is used
        COOKBOOK_NONSTOP=false      keep running even a recipe build failed
        COOKBOOK_VERBOSE=true       print success/error on each recipe
        COOKBOOK_CLEAN_BUILD=false  remove build directory before building
        COOKBOOK_CLEAN_TARGET=false remove target directory after building
        COOKBOOK_MAKE_JOBS=         override build jobs count from nproc
```

### 表示項目詳細

| セクション | 説明 |
|-----------|------|
| Usage | 基本的なコマンド構文 |
| command list | 利用可能なサブコマンド一覧（7種類） |
| common flags | 共通オプションフラグ（8種類） |
| cook env | 環境変数設定とデフォルト値（8種類） |

## イベント仕様

### 1-ヘルプ表示

1. `main_inner()`関数でコマンドライン引数を解析（185行目）
2. 以下の条件でヘルプを表示：
   - 引数が空の場合（`args.is_empty()`）
   - `--help`が引数に含まれる場合
   - `-h`が引数に含まれる場合
3. `REPO_HELP_STR`定数を標準出力に`println!`で出力（186行目）
4. `process::exit(1)`でプログラム終了（187行目）

## データベース更新仕様

データベースは使用しない。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 情報 | REPO_HELP_STR（ヘルプテキスト全文） | ヘルプ表示条件成立時 |

## 例外処理

| 例外状況 | 処理内容 |
|----------|----------|
| 該当なし | ヘルプ表示は常に成功し、終了コード1を返す |

## 備考

- ヘルプテキストは`REPO_HELP_STR`定数として`src/bin/repo.rs`の42-75行目に定義されている
- 終了コード1は、ヘルプ表示が「正常な処理の完了」ではなく「処理を実行せずに終了」したことを示す
- 不明なコマンドが指定された場合もヘルプテキストがエラーメッセージと共に表示される（128行目）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ヘルプ画面では特別なデータ構造は使用しない。主要なデータは文字列定数のみ。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | repo.rs | `src/bin/repo.rs` | REPO_HELP_STR定数の定義（42-75行目） |

**読解のコツ**: Rustの生文字列リテラル（`r#"..."#`）の書式を理解する。この記法により複数行の文字列を整形済みの状態で定義できる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | repo.rs | `src/bin/repo.rs` | main関数とmain_inner関数の構造 |

**主要処理フロー**:
1. **174行目**: `main()`関数がエントリーポイント
2. **175行目**: `init_config()`で設定初期化
3. **176行目**: `main_inner()`を呼び出し
4. **182行目**: `main_inner()`開始
5. **183行目**: コマンドライン引数を収集（`env::args().skip(1).collect()`）
6. **185行目**: ヘルプ表示条件のチェック
7. **186行目**: ヘルプテキスト出力
8. **187行目**: `process::exit(1)`で終了

#### Step 3: ヘルプテキスト定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | repo.rs | `src/bin/repo.rs` | REPO_HELP_STR定数（42-75行目）の構造 |

**主要処理フロー**:
- **42行目**: 定数定義開始 `const REPO_HELP_STR: &str = r#"`
- **43行目**: Usage行
- **45-52行目**: コマンド一覧
- **54-63行目**: 共通フラグ一覧
- **65-74行目**: 環境変数一覧
- **75行目**: 定数定義終了

#### Step 4: 関連するコマンド処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | repo.rs | `src/bin/repo.rs` | CliCommand列挙型（90-99行目）とFromStr実装 |

**主要処理フロー**:
- **116-131行目**: CliCommandのFromStr実装で不明なコマンド時にヘルプを表示

### プログラム呼び出し階層図

```
repo コマンド実行
    │
    └─ main() (174行目)
           │
           ├─ init_config() (175行目)
           │
           └─ main_inner() (176行目)
                  │
                  ├─ env::args().skip(1).collect() (183行目)
                  │
                  ├─ [ヘルプ条件チェック] (185行目)
                  │      │
                  │      └─ args.is_empty() OR
                  │         args.contains("--help") OR
                  │         args.contains("-h")
                  │
                  ├─ println!("{}", REPO_HELP_STR) (186行目)
                  │
                  └─ process::exit(1) (187行目)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

コマンドライン引数 ─────────┐
    --help                 │
    -h                     │
    (引数なし)              │
                           ▼
                    ┌────────────────┐
                    │ args収集       │
                    │ env::args()    │
                    └───────┬────────┘
                           │
                           ▼
                    ┌────────────────┐
                    │ 条件チェック   │
                    │ - is_empty()   │
                    │ - contains     │
                    └───────┬────────┘
                           │
                           ▼
                    ┌────────────────┐
                    │ REPO_HELP_STR  │
                    │ 出力           │─────────▶ 標準出力（ヘルプテキスト）
                    └───────┬────────┘
                           │
                           ▼
                      process::exit(1)
                           │
                           ▼
                      終了コード: 1
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| repo.rs | `src/bin/repo.rs` | ソース | repoコマンドのメインエントリーポイント、ヘルプ定数含む |
| Cargo.toml | `Cargo.toml` | 設定 | repoバイナリの定義（14-16行目） |
| 画面一覧.csv | `docs/code-to-docs/画面一覧/画面一覧.csv` | 設計 | 画面No.12の定義 |
| 画面遷移図.md | `docs/code-to-docs/画面一覧/画面遷移図.md` | 設計 | ヘルプ画面への遷移フロー |
| 画面機能マッピング.csv | `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` | 設計 | ヘルプ画面と関連機能のマッピング |
