# 画面設計書 2-失敗時プロンプトダイアログ

## 概要

本ドキュメントは、Redox OS Build System（cookbook）の失敗時プロンプトダイアログの設計仕様を定義します。この画面はTUIモードでビルドまたはフェッチが失敗した際に表示されるモーダルダイアログです。

### 本画面の処理概要

失敗時プロンプトダイアログは、ビルドプロセス中にエラーが発生した際にユーザーに対処方法を選択させるモーダルウィンドウです。FailurePrompt構造体で実装され、draw_prompt関数で描画されます。

**業務上の目的・背景**：複数のレシピを一括ビルドする際、1つのレシピで失敗が発生した場合に、全体のビルドを中止するか、そのレシピをスキップして継続するか、あるいはリトライするかをユーザーが選択できるようにする必要があります。このダイアログにより、ビルドプロセスの柔軟な制御が可能となり、開発効率が向上します。

**画面へのアクセス方法**：TUIメイン画面でビルドまたはフェッチ処理が失敗した際に自動的に表示されます。ユーザーが意図的に表示することはできません。ただし、環境変数`COOKBOOK_NONSTOP=true`が設定されている場合は自動的にスキップされ、ダイアログは表示されますが即座に次の処理に進みます。

**主要な操作・処理内容**：
1. 失敗したレシピ名とエラーメッセージの確認
2. 左右キーまたはTabキーで選択肢を移動
3. Enterキーで選択を確定
4. q/Esc/Ctrl+Cで即座に終了

**画面遷移**：
- 遷移元：TUIメイン画面（ビルドまたはフェッチ失敗時）
- 遷移先（Retry選択時）：TUIメイン画面（同じレシピを再実行）
- 遷移先（Skip選択時）：TUIメイン画面（次のレシピに進む）
- 遷移先（Exit選択時）：プログラム終了

**権限による表示制御**：特になし。COOKBOOK_NONSTOPモード時はRetryオプションが非表示となります。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 35 | 並列ビルドTUI | 主機能 | FailurePrompt構造体によるエラーダイアログ表示 |
| 38 | ノンストップモード | 補助機能 | COOKBOOK_NONSTOPモード時のスキップ処理 |

## 画面種別

モーダルダイアログ（TUI内ポップアップ）

## URL/ルーティング

TUIメイン画面内で表示されるモーダルのため、個別のルーティングはありません。

## 入出力項目

### 入力項目（イベント）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| FailFetch | StatusUpdate | フェッチ失敗時に発生するイベント |
| FailCook | StatusUpdate | ビルド失敗時に発生するイベント |

### 出力項目（選択結果）

| 項目名 | 型 | 値 | 説明 |
|--------|-----|-----|------|
| PromptOption | u32 | 2 (Retry) | リトライを選択 |
| PromptOption | u32 | 3 (Skip) | スキップを選択 |
| PromptOption | u32 | 4 (Exit) | 終了を選択 |

## 表示項目

### ダイアログ構成

| 要素 | 位置 | 内容 |
|------|------|------|
| タイトル | 上部ボーダー | " FAILURE in {レシピ名} " または " FAILURE in {レシピ名} (skipped) " |
| エラーメッセージ | 本文上部 | エラー内容（最大100文字に切り詰め） |
| ボタン群 | 本文下部 | [Skip] [Exit] [Retry] |

### タイトルスタイル

| 条件 | 背景色 | 文字色 |
|------|--------|--------|
| 通常 | 赤 | 白 |

### ボタンスタイル

| 状態 | 背景色 | 文字色 |
|------|--------|--------|
| 選択中 | 白 | 黒 |
| 非選択 | なし | デフォルト |

### ダイアログサイズ

| 項目 | 値 | 説明 |
|------|-----|------|
| x位置 | area.width / 4 | 画面幅の1/4の位置 |
| y位置 | area.height / 3 | 画面高さの1/3の位置 |
| 幅 | area.width / 2 | 画面幅の半分 |
| 高さ | 10行固定 | ダイアログの高さ |

## イベント仕様

### 1-キーボード操作

| キー | 処理内容 |
|------|---------|
| Left / BackTab | 選択を前のオプションに移動 |
| Right / Tab | 選択を次のオプションに移動 |
| Enter | 選択を確定 |
| q / Ctrl+C / Esc | Exit（終了）を選択して確定 |

### 2-選択肢の遷移

選択肢は循環的に移動します：

```
Retry ←→ Skip ←→ Exit ←→ Retry（ループ）
```

### 3-選択確定時の処理

| 選択肢 | prompting値 | 処理内容 |
|--------|------------|---------|
| Retry | 2 | 同じレシピのフェッチ/ビルドを再実行 |
| Skip | 3 | handle_nonstop_fail()を呼び出し、次のレシピに進む |
| Exit | 4 | 現在のログを保存し、TUIを終了 |

## データベース更新仕様

本画面はファイルシステムベースの操作を行い、データベースは使用しません。

### ファイルシステム操作

| 操作 | 対象パス | 操作種別 | 概要 |
|------|---------|---------|------|
| Skip選択時 | recipes/{category}/{recipe}/target/stage | DELETE | handle_nonstop_fail()でstageディレクトリを削除 |
| Exit選択時 | build/logs/{target}/{recipe}.log | WRITE | 現在のログをファイルに保存 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| TITLE_NORMAL | 情報 | " FAILURE in {レシピ名} " | 通常モード |
| TITLE_SKIPPED | 情報 | " FAILURE in {レシピ名} (skipped) " | ノンストップモード |
| ERR_TRUNCATED | 警告 | "{先頭100文字}..{末尾100文字}" | エラーメッセージが200文字超 |
| ERR_PARTIAL | 警告 | "{先頭100文字}.." | エラーメッセージが100-200文字 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| ノンストップモードでRetry選択 | Skipに自動変更（1445-1447行目） |
| マウスイベント | 無視（1629行目） |
| prompting状態が不正 | unreachable!()マクロでパニック |

## 備考

- FailurePrompt構造体は1754-1758行目で定義
- デフォルトの選択肢はExit（1765行目）
- ノンストップモード時はRetryボタンが非表示（1673-1676行目）
- エラーメッセージは最大200文字に切り詰められる（1641-1648行目）
- ダイアログ背景は Clear ウィジェットでクリアされる（1705行目）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ダイアログの状態管理に使用されるデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | repo.rs | `src/bin/repo.rs` | PromptOption列挙型（1746-1752行目）で選択肢を定義 |
| 1-2 | repo.rs | `src/bin/repo.rs` | FailurePrompt構造体（1754-1758行目）でダイアログ状態を管理 |

**読解のコツ**: PromptOptionは#[repr(u32)]でu32に変換可能。Retry=2, Skip=3, Exit=4という値がスレッド間通信で使用される。

#### Step 2: ダイアログ表示トリガーを理解する

どのような条件でダイアログが表示されるかを把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | repo.rs | `src/bin/repo.rs` | update_status関数内のFailFetch処理（932-935行目） |
| 2-2 | repo.rs | `src/bin/repo.rs` | update_status関数内のFailCook処理（971-974行目） |

**主要処理フロー**:
1. **932-935行目**: FailFetchイベント受信時にFailurePrompt::new()でダイアログ生成
2. **971-974行目**: FailCookイベント受信時にFailurePrompt::new()でダイアログ生成
3. **833行目**: TuiApp.promptフィールドにOption<FailurePrompt>として保持

#### Step 3: ダイアログ描画を理解する

ratatuiによるダイアログ描画ロジックを把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | repo.rs | `src/bin/repo.rs` | draw_prompt関数（1635-1707行目）でダイアログを描画 |
| 3-2 | repo.rs | `src/bin/repo.rs` | 1444-1449行目でdraw_promptを呼び出し |

**主要処理フロー**:
- **1636-1639行目**: タイトル文字列を生成（ノンストップモード時は"(skipped)"を追加）
- **1640-1648行目**: エラーメッセージを切り詰め
- **1651-1665行目**: 各ボタンのスタイルを選択状態に応じて設定
- **1667-1676行目**: ボタンのSpanを生成（ノンストップ時はRetry非表示）
- **1684-1696行目**: Paragraphウィジェットを構築
- **1697-1703行目**: ダイアログの位置とサイズを計算
- **1705-1706行目**: Clearで背景をクリアし、Paragraphを描画

#### Step 4: 入力処理を理解する

キーボード入力によるダイアログ操作ロジックを把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | repo.rs | `src/bin/repo.rs` | handle_prompt_input関数（1610-1633行目） |
| 4-2 | repo.rs | `src/bin/repo.rs` | FailurePrompt::next/prev関数（1769-1783行目） |

**主要処理フロー**:
- **1617-1619行目**: q/Ctrl+C/EscでExit確定
- **1621行目**: Left/BackTabでprev()を呼び出し
- **1622行目**: Right/Tabでnext()を呼び出し
- **1623-1626行目**: Enterで選択を確定しpromptを消費

#### Step 5: 選択確定後の処理を理解する

選択肢確定後のスレッド制御ロジックを把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | repo.rs | `src/bin/repo.rs` | メインループ内のhandle_prompt_input呼び出し（1457-1470行目） |
| 5-2 | repo.rs | `src/bin/repo.rs` | Cooker Thread内のprompting待機ループ（1079-1102行目） |
| 5-3 | repo.rs | `src/bin/repo.rs` | Fetcher Thread内のprompting待機ループ（1187-1210行目） |

**主要処理フロー**:
- **1459行目**: prompting.swap()でAtomicU32に選択結果を書き込み
- **1084-1099行目**: Cooker Threadがprompting値を読み取り分岐
  - 2: Retry（break 'wait でループ継続）
  - 3: Skip（handle_nonstop_fail()を呼び、break 'again で次へ）
  - 4: Exit（break 'done でスレッド終了）

### プログラム呼び出し階層図

```
TUIメインループ [repo.rs:1228-1488]
    │
    ├─ [描画] terminal.draw()
    │      │
    │      └─ draw_prompt() [repo.rs:1635-1707]
    │             ├─ Paragraph::new()
    │             ├─ Clear (背景クリア)
    │             └─ f.render_widget()
    │
    ├─ [入力] handle_prompt_input() [repo.rs:1610-1633]
    │      │
    │      ├─ FailurePrompt::prev() [repo.rs:1777-1783]
    │      ├─ FailurePrompt::next() [repo.rs:1769-1775]
    │      └─ prompting.swap() [AtomicU32]
    │
    └─ [状態更新] TuiApp::update_status()
           │
           ├─ StatusUpdate::FailFetch
           │      └─ FailurePrompt::new() [repo.rs:1760-1767]
           │
           └─ StatusUpdate::FailCook
                  └─ FailurePrompt::new()

[Cooker Thread]                      [Fetcher Thread]
    │                                    │
    └─ prompting.load()                  └─ prompting.load()
           │                                    │
           ├─ 2: continue (Retry)               ├─ 2: continue (Retry)
           ├─ 3: handle_nonstop_fail() (Skip)   ├─ 3: handle_nonstop_fail() (Skip)
           └─ 4: break 'done (Exit)             └─ 4: break 'done (Exit)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

fetch/cook失敗 ────────▶ StatusUpdate::Fail* ────▶ TuiApp.prompt
       │                                               │
       ▼                                               ▼
  FailurePrompt::new() ────────────────────────▶ ダイアログ表示
       │
       ▼
  キーボード入力 ────────▶ handle_prompt_input()
       │                         │
       ├─ Left/Right ───────────▶ prev()/next() ────▶ selected更新
       │
       └─ Enter/q/Esc ──────────▶ prompting.swap()
                                        │
                                        ▼
                              [Cooker/Fetcher Thread]
                                        │
                              ┌─────────┼─────────┐
                              ▼         ▼         ▼
                           Retry     Skip      Exit
                              │         │         │
                              ▼         ▼         ▼
                        再実行   nonstop_fail  TUI終了
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| repo.rs | `src/bin/repo.rs` | ソース | ダイアログ実装（FailurePrompt, draw_prompt, handle_prompt_input） |
| cook_build.rs | `src/cook/cook_build.rs` | ソース | handle_nonstop_fail()で呼び出されるremove_stage_dir |
