# 画面設計書 3-repo fetchコマンド画面

## 概要

本ドキュメントは、Redox OS Build System（cookbook）の`repo fetch`コマンド画面の設計仕様を定義します。この画面はレシピのソースコードをダウンロードするCLIインターフェースです。

### 本画面の処理概要

`repo fetch`コマンドは、指定されたレシピのソースコードを各種ソース（Git、Tar、ローカルパス、同一ソース参照、リモートパッケージ）から取得し、レシピディレクトリ内のsourceフォルダに配置します。

**業務上の目的・背景**：Redox OSのビルドシステムでは、各パッケージ（レシピ）のソースコードを外部リポジトリやアーカイブから取得する必要があります。fetchコマンドは、ビルド前の準備段階としてソースコードを取得・展開し、必要に応じてパッチを適用する役割を担います。オフラインビルドのための事前ダウンロードにも使用されます。

**画面へのアクセス方法**：ターミナルから`repo fetch <レシピ名>...`コマンドを実行します。複数のレシピを同時に指定可能です。

**主要な操作・処理内容**：
1. 指定されたレシピのrecipe.tomlを解析してソース情報を取得
2. ソースタイプに応じた取得処理（Git clone/fetch、Tar download/extract、ファイルコピー等）
3. 指定されたパッチファイルの適用
4. ビルド前スクリプト（script）の実行
5. Cargoプロジェクトの場合はcargo fetchも実行

**画面遷移**：
- 遷移元：ターミナル（コマンドライン）
- 遷移先：成功時 → 完了メッセージ表示、失敗時 → エラーメッセージ表示

**権限による表示制御**：特になし。ファイルシステムの書き込み権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 27 | fetchコマンド | 主機能 | CLIからのソースコードダウンロード実行 |
| 2 | ソース取得（Git） | API連携 | Gitリポジトリからのソースクローン・フェッチ |
| 3 | ソース取得（Tar） | API連携 | Tarアーカイブのダウンロードと展開 |
| 4 | ソース取得（パス参照） | API連携 | ローカルファイルシステムからのソースコピー |
| 5 | ソース取得（同一ソース参照） | API連携 | 別パッケージソースへのシンボリックリンク作成 |
| 6 | リモートパッケージ取得 | API連携 | 事前ビルド済みパッケージのダウンロード |
| 7 | パッチ適用 | API連携 | ソースコードへのパッチファイル適用 |
| 8 | ビルド前スクリプト実行 | API連携 | ソース準備用カスタムスクリプト実行 |
| 37 | オフラインモード | 補助機能 | COOKBOOK_OFFLINEによるローカルキャッシュからのビルド |
| 1 | レシピ解析 | API連携 | recipe.tomlの解析とソース取得設定の取得 |

## 画面種別

CLI（Command Line Interface）- テキストベースコマンド画面

## URL/ルーティング

コマンドラインインターフェース経由でのアクセス：
```
repo fetch [flags] <recipe1> <recipe2> ...
```

## 入出力項目

### 入力項目（コマンドライン引数）

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| recipe | String[] | Yes | フェッチ対象のレシピ名（複数指定可） |
| --cookbook | Path | No | recipesフォルダのパス（デフォルト: $PWD/recipes） |
| --repo | Path | No | repoフォルダのパス（デフォルト: $PWD/repo） |
| --with-package-deps | Flag | No | パッケージ依存関係を含める |
| --all | Flag | No | 全レシピを対象（cleaningコマンドでのみ有効） |
| --category | Path | No | 指定カテゴリ内の全レシピを対象 |
| --filesystem | Path | No | installerファイルでレシピを指定 |

### 環境変数

| 変数名 | 型 | デフォルト | 説明 |
|--------|-----|----------|------|
| COOKBOOK_OFFLINE | Bool | false | オフラインモードを有効化（fetchでは無視される） |
| COOKBOOK_NONSTOP | Bool | false | 失敗時も継続 |
| COOKBOOK_VERBOSE | Bool | true | 詳細メッセージを表示 |

### 出力項目

| 項目 | 型 | 説明 |
|------|-----|------|
| 成功メッセージ | String | "fetch {レシピ名} - successful" |
| 失敗メッセージ | String | "fetch {レシピ名} - failed" |
| ソースディレクトリ | Path | recipes/{category}/{recipe}/source |

## 表示項目

### コマンド実行時の出力

| 項目 | 表示形式 | 説明 |
|------|---------|------|
| 成功メッセージ | 緑色太字テキスト | ANSIカラーコード46 |
| 失敗メッセージ | 赤色太字テキスト | ANSIカラーコード196 |
| Git出力 | 標準出力 | git clone/fetch/checkoutの出力 |
| パッチ適用出力 | 標準出力 | patchコマンドの出力 |
| 警告メッセージ | 黄色テキスト | blake3ハッシュ未設定時など |

## イベント仕様

### 1-Gitソース取得

| 処理ステップ | 条件 | 処理内容 |
|-------------|------|---------|
| 新規クローン | source_dirが存在しない | git clone --recursive [--branch] [--filter=tree:0] |
| リモート更新 | source_dirが存在する | git remote set-url origin, git fetch origin |
| リビジョンチェックアウト | revが指定されている | git checkout {rev} |
| ブランチリセット | revが未指定かつパッチあり | git reset --hard, GIT_RESET_BRANCH実行 |
| サブモジュール更新 | 常時 | git submodule sync --recursive, git submodule update --init --recursive |
| パッチ適用 | patchesが指定されている | patch --directory {source_dir} --strip=1 |
| スクリプト実行 | scriptが指定されている | bash -ex で実行 |

### 2-Tarソース取得

| 処理ステップ | 条件 | 処理内容 |
|-------------|------|---------|
| ダウンロード | source.tarが存在しない | wget でダウンロード |
| blake3検証 | blake3が指定されている | ハッシュ値を比較、不一致なら再ダウンロードまたはエラー |
| 展開 | source_dirが存在しない | tar --extract --strip-components=1 |
| パッチ適用 | patchesが指定されている | patch --directory {source_dir} --strip=1 |

### 3-パス参照ソース取得

| 処理ステップ | 条件 | 処理内容 |
|-------------|------|---------|
| コピー | pathで指定されたディレクトリが新しい | copy_dir_all()でコピー |

### 4-同一ソース参照

| 処理ステップ | 条件 | 処理内容 |
|-------------|------|---------|
| 参照先フェッチ | 常時 | same_asで指定されたレシピを再帰的にfetch |
| シンボリックリンク作成 | source_dirが存在しない | symlink を作成 |

### 5-リモートパッケージ取得

| 処理ステップ | 条件 | 処理内容 |
|-------------|------|---------|
| 公開鍵ダウンロード | 常時 | id_ed25519.pub.toml をダウンロード |
| パッケージダウンロード | 各パッケージ | {name}.pkgar, {name}.toml をダウンロード |

## データベース更新仕様

本画面はファイルシステムベースの操作を行い、データベースは使用しません。

### ファイルシステム操作

| 操作 | 対象パス | 操作種別 | 概要 |
|------|---------|---------|------|
| ソース配置 | recipes/{category}/{recipe}/source | CREATE | ソースコードを配置 |
| tarアーカイブ保存 | recipes/{category}/{recipe}/source.tar | CREATE | ダウンロードしたtarを保存 |
| 一時ディレクトリ | recipes/{category}/{recipe}/source.tmp | CREATE/DELETE | 展開中の一時ディレクトリ |
| ソース情報保存 | recipes/{category}/{recipe}/target/{target}/source_info.toml | CREATE | ソース識別子を保存 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG_SUCCESS | 成功 | "fetch {レシピ名} - successful" | フェッチ成功時 |
| MSG_FAILED | エラー | "fetch {レシピ名} - failed" | フェッチ失敗時 |
| MSG_BLAKE3_MISMATCH | エラー | "The downloaded tar blake3 '{hash}' is not equal to blake3 in recipe.toml" | blake3ハッシュ不一致 |
| MSG_BLAKE3_WARNING | 警告 | "WARNING: set blake3 for '{path}' to '{hash}'" | blake3未設定 |
| MSG_NOT_GIT_REPO | エラー | "'{path}' is not a git repository, but recipe indicated git source" | .gitディレクトリ不在 |
| MSG_SYMLINK_EXISTS | エラー | "'{dir}' is a directory, but recipe indicated a symlink" | シンボリックリンク期待だがディレクトリが存在 |
| MSG_NO_SOURCE | 警告 | "WARNING: Recipe without source section expected source dir at '{path}'" | sourceセクション未定義 |
| MSG_PATCH_NOT_FOUND | エラー | "failed to find patch file '{path}'" | パッチファイル不在 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| Gitクローン失敗 | エラーメッセージを表示し、nonstopモードでなければ終了 |
| Tarダウンロード失敗 | エラーメッセージを表示し、nonstopモードでなければ終了 |
| blake3不一致 | 再ダウンロードを試行、それでも不一致ならエラー終了 |
| パッチ適用失敗 | エラーメッセージを表示し終了 |
| ディスク容量不足 | IOエラーを表示し終了 |
| ネットワークエラー | wgetのエラーメッセージを表示し終了 |
| 無限ループ検出（same_as） | パス深度が50を超えた場合"Infinite loop detected"エラー |

## 備考

- fetchコマンドはCOOKBOOK_OFFLINE環境変数が設定されていても無視される（常にネットワークアクセスを試行）
- Cargoプロジェクト（template=cargo）の場合、ソース取得後に自動的にcargo fetchも実行される
- shallow_clone=trueの場合、`--filter=tree:0 --also-filter-submodules`オプションが使用される
- ソース識別子（source_info.toml）にはcommit_identifier、time_identifier、source_identifierが保存される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ソース取得に関連するデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | recipe.rs | `src/recipe.rs` | SourceRecipe列挙型でソースタイプを定義（Git, Tar, Path, SameAs） |
| 1-2 | recipe.rs | `src/recipe.rs` | CookRecipe構造体でレシピ全体の設定を保持 |

**読解のコツ**: SourceRecipeは4つのバリアント（Git, Tar, Path, SameAs）を持ち、それぞれのソース取得方法を表現。

#### Step 2: エントリーポイントを理解する

fetchコマンドの処理起点から実際の取得処理までの流れを把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | repo.rs | `src/bin/repo.rs` | main_inner関数（182-249行目）でコマンドを解析 |
| 2-2 | repo.rs | `src/bin/repo.rs` | repo_inner関数（286-355行目）でFetchコマンドを処理 |
| 2-3 | repo.rs | `src/bin/repo.rs` | handle_fetch関数（553-566行目）でfetch関数を呼び出し |

**主要処理フロー**:
1. **191行目**: parse_args()でコマンドライン引数を解析
2. **214行目**: repo_inner()で各レシピに対してフェッチ実行
3. **292-299行目**: CliCommand::Fetch時にhandle_fetch()を呼び出し

#### Step 3: ソース取得処理を理解する

fetch.rs内の各ソースタイプ別の取得ロジックを把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | fetch.rs | `src/cook/fetch.rs` | fetch関数（117-406行目）がメインのフェッチ処理 |
| 3-2 | fetch.rs | `src/cook/fetch.rs` | 161-317行目：Gitソース取得処理 |
| 3-3 | fetch.rs | `src/cook/fetch.rs` | 318-380行目：Tarソース取得処理 |
| 3-4 | fetch.rs | `src/cook/fetch.rs` | 141-159行目：Pathソース取得処理 |
| 3-5 | fetch.rs | `src/cook/fetch.rs` | 134-140行目：SameAsソース取得処理 |

**主要処理フロー**:
- **121-131行目**: BuildKind::NoneまたはRemoteの特殊処理
- **133-393行目**: SourceRecipeのマッチによる分岐処理
- **395-401行目**: Cargoプロジェクトの場合、cargo fetchを追加実行
- **403行目**: fetch_apply_source_info()でソース識別子を保存

#### Step 4: パッチ適用処理を理解する

パッチファイルの適用とスクリプト実行のロジックを把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | fetch.rs | `src/cook/fetch.rs` | fetch_apply_patches関数（606-646行目） |

**主要処理フロー**:
- **613-634行目**: 各パッチファイルを読み込み、`patch --strip=1`で適用
- **636-645行目**: scriptが指定されている場合、bash -exで実行

#### Step 5: オフラインモードを理解する

オフラインモード時の代替処理を把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | fetch.rs | `src/cook/fetch.rs` | fetch_offline関数（37-115行目） |

**主要処理フロー**:
- **559-563行目**: config.cook.offlineフラグでfetch_offline/fetchを切り替え
- **74-77行目**: Gitソースの場合、source_dirの存在確認のみ
- **78-109行目**: Tarソースの場合、blake3検証付きでローカルからの展開

### プログラム呼び出し階層図

```
main() [repo.rs:174]
    │
    └─ main_inner() [repo.rs:182]
           │
           ├─ parse_args() [repo.rs:373]
           │      └─ CookRecipe::get_build_deps_recursive()
           │
           └─ repo_inner() [repo.rs:286]
                  │
                  └─ handle_fetch() [repo.rs:553]
                         │
                         ├─ fetch() [fetch.rs:117]
                         │      │
                         │      ├─ [Git] git clone/fetch/checkout
                         │      │      └─ fetch_apply_patches()
                         │      │
                         │      ├─ [Tar] download_wget()
                         │      │      ├─ get_blake3() [fetch.rs:21]
                         │      │      ├─ fetch_extract_tar() [fetch.rs:454]
                         │      │      └─ fetch_apply_patches()
                         │      │
                         │      ├─ [Path] copy_dir_all() [fs.rs]
                         │      │
                         │      ├─ [SameAs] fetch() (再帰)
                         │      │      └─ fetch_make_symlink() [fetch.rs:408]
                         │      │
                         │      ├─ [Remote] fetch_remote() [fetch.rs:517]
                         │      │
                         │      └─ fetch_cargo() [fetch.rs:478]
                         │
                         └─ fetch_offline() [fetch.rs:37]
                                └─ (同様の構造、ネットワークアクセスなし)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

コマンドライン引数 ────▶ parse_args() ────▶ CliConfig, recipes
       │
       ▼
  recipe.toml ────────▶ SourceRecipe解析 ────▶ ソースタイプ判定
       │
       │
       ▼ [Git]
  Gitリポジトリ ───────▶ git clone/fetch ────▶ source/
       │                      │
       │                      └──▶ git checkout {rev}
       │                              │
       │                              └──▶ パッチ適用 ────▶ source/
       │
       ▼ [Tar]
  リモートURL ─────────▶ wget ────▶ source.tar
       │                     │
       │                     └──▶ blake3検証
       │                              │
       │                              └──▶ tar extract ────▶ source/
       │
       ▼ [Path]
  ローカルパス ────────▶ copy_dir_all() ────▶ source/
       │
       ▼ [SameAs]
  参照先レシピ ────────▶ fetch() (再帰) ────▶ symlink → 参照先/source
       │
       ▼
  source_info.toml ◀── fetch_apply_source_info()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| repo.rs | `src/bin/repo.rs` | ソース | fetchコマンドのエントリーポイント |
| fetch.rs | `src/cook/fetch.rs` | ソース | ソース取得処理の実装 |
| fs.rs | `src/cook/fs.rs` | ソース | ファイルシステム操作ユーティリティ |
| recipe.rs | `src/recipe.rs` | ソース | レシピ設定の解析 |
| config.rs | `src/config.rs` | ソース | 設定管理（CookConfig） |
| script.rs | `src/cook/script.rs` | ソース | スクリプト実行、SHARED_PRESCRIPT定義 |
| blake3.rs | `src/blake3.rs` | ソース | blake3ハッシュ計算 |
