# 画面設計書 4-repo cookコマンド画面

## 概要

本ドキュメントは、Redox OS Build System（cookbook）の`repo cook`コマンド画面の設計仕様を定義します。この画面はレシピをビルドしてパッケージを作成するCLIインターフェースで、TUIモードとCIモードを切り替え可能です。

### 本画面の処理概要

`repo cook`コマンドは、指定されたレシピのソースコードを取得（fetch）し、ビルドを実行し、pkgar形式のパッケージを生成します。複数のビルドテンプレート（Cargo、Configure、CMake、Meson、Custom）をサポートし、依存関係の自動解決と自動依存関係検出を行います。

**業務上の目的・背景**：Redox OSのパッケージビルドシステムのコア機能として、各種ソフトウェアをRedox OS向けにクロスコンパイルし、インストール可能なパッケージ（.pkgar）を生成します。依存関係の解決、sysroot/toolchainの構築、ビルドスクリプトの実行、パッケージング、署名までの一連の工程を自動化することで、開発者の負担を軽減します。

**画面へのアクセス方法**：ターミナルから`repo cook <レシピ名>...`コマンドを実行します。環境変数`CI`が未設定の場合はTUIモードで起動し、設定されている場合はCLIモードで動作します。

**主要な操作・処理内容**：
1. ソースコードの取得（fetch処理を含む）
2. 依存関係の再帰的解決とsysroot/toolchainの構築
3. ビルドテンプレートに応じたビルドスクリプトの実行
4. stageディレクトリへの成果物配置とオプショナルパッケージの分離
5. pkgarアーカイブの作成とEd25519署名
6. ビルドログのファイル保存

**画面遷移**：
- 遷移元：ターミナル（コマンドライン）
- 遷移先（TUIモード）：TUIメイン画面（ビルド進捗表示）
- 遷移先（CLIモード）：成功/失敗メッセージ表示、repo_builder自動実行

**権限による表示制御**：特になし。ファイルシステムの書き込み権限と、ビルドに必要なツールチェインへのアクセス権が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 28 | cookコマンド | 主機能 | CLIからのレシピビルドとパッケージ作成実行 |
| 9 | Cargoビルド | API連携 | template=cargoでのRustプロジェクトビルド |
| 10 | Configureビルド | API連携 | template=configureでのautotoolsプロジェクトビルド |
| 11 | CMakeビルド | API連携 | template=cmakeでのCMakeプロジェクトビルド |
| 12 | Mesonビルド | API連携 | template=mesonでのMesonプロジェクトビルド |
| 13 | カスタムビルド | API連携 | template=customでのカスタムスクリプトビルド |
| 14 | 依存関係解決 | API連携 | ビルド依存関係と実行時依存関係の再帰的解決 |
| 15 | 自動依存関係検出 | API連携 | ELFバイナリからの動的リンク依存関係検出 |
| 16 | sysroot構築 | API連携 | 依存パッケージのsysrootへの展開 |
| 17 | toolchain構築 | API連携 | ホストツールチェインのtoolchainディレクトリ展開 |
| 18 | ステージディレクトリ管理 | API連携 | ビルド成果物のstageディレクトリ配置 |
| 19 | pkgarアーカイブ作成 | API連携 | stageディレクトリのpkgar形式アーカイブ化 |
| 20 | パッケージメタデータ生成 | API連携 | stage.tomlへのパッケージ情報出力 |
| 21 | パッケージ署名 | API連携 | Ed25519鍵ペアでのパッケージ署名 |
| 22 | オプショナルパッケージ分離 | API連携 | 追加パッケージのファイルパターン分離 |
| 35 | 並列ビルドTUI | 補助機能 | --tuiオプションでのTUIモード切替 |
| 36 | ビルドログ出力 | 補助機能 | build/logsへのビルドログ保存 |
| 38 | ノンストップモード | 補助機能 | COOKBOOK_NONSTOPでのエラースキップ継続 |
| 34 | filesystem設定オーバーライド | 補助機能 | --filesystemでのレシピビルドルール指定 |
| 56 | バイナリストリップ | API連携 | ビルド済みバイナリからのデバッグシンボル削除 |
| 57 | libtoolファイル削除 | API連携 | 不要な.laファイルの削除 |
| 58 | cargoインストールファイル削除 | API連携 | cargo install管理ファイルの削除 |
| 59 | AppStreamメタデータ更新 | API連携 | メタデータXMLへのpkgnameタグ追加 |
| 1 | レシピ解析 | API連携 | recipe.tomlの解析とビルド設定取得 |
| 39 | cookbook.toml読み込み | API連携 | グローバル設定の読み込み |
| 40 | ミラーURL変換 | API連携 | ダウンロードURLのミラーサイト変換 |
| 41 | 環境変数オーバーライド | API連携 | COOKBOOK_*環境変数での設定上書き |

## 画面種別

CLI（Command Line Interface）/ TUI（Terminal User Interface）- モード切替可能

## URL/ルーティング

コマンドラインインターフェース経由でのアクセス：
```
repo cook [flags] <recipe1> <recipe2> ...
```

## 入出力項目

### 入力項目（コマンドライン引数）

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| recipe | String[] | Yes | ビルド対象のレシピ名（複数指定可） |
| --cookbook | Path | No | recipesフォルダのパス（デフォルト: $PWD/recipes） |
| --repo | Path | No | repoフォルダのパス（デフォルト: $PWD/repo） |
| --with-package-deps | Flag | No | パッケージ依存関係を含める |
| --filesystem | Path | No | installerファイルでビルドルールを上書き |
| --repo-binary | Flag | No | filesystemのrepo_binaryを有効化 |

### 環境変数

| 変数名 | 型 | デフォルト | 説明 |
|--------|-----|----------|------|
| CI | Any | 未設定 | 設定するとTUIを無効化 |
| COOKBOOK_LOGS | Bool | !CI | ビルドログをキャプチャするか |
| COOKBOOK_OFFLINE | Bool | false | オフラインモード |
| COOKBOOK_NONSTOP | Bool | false | 失敗時も継続 |
| COOKBOOK_VERBOSE | Bool | true | 詳細メッセージを表示 |
| COOKBOOK_CLEAN_BUILD | Bool | false | ビルド前にbuildディレクトリを削除 |
| COOKBOOK_CLEAN_TARGET | Bool | false | ビルド後にtargetディレクトリを削除 |
| COOKBOOK_MAKE_JOBS | Int | nproc | ビルドジョブ数 |

### 出力項目

| 項目 | 型 | 説明 |
|------|-----|------|
| 成功メッセージ | String | "cook {レシピ名} - successful" |
| 失敗メッセージ | String | "cook {レシピ名} - failed" |
| stageディレクトリ | Path | recipes/{category}/{recipe}/target/{target}/stage |
| pkgarファイル | Path | recipes/{category}/{recipe}/target/{target}/stage.pkgar |
| stage.toml | Path | recipes/{category}/{recipe}/target/{target}/stage.toml |
| ビルドログ | Path | build/logs/{target}/{recipe}.log |

## 表示項目

### CLIモード出力

| 項目 | 表示形式 | 説明 |
|------|---------|------|
| 成功メッセージ | 緑色太字テキスト | ANSIカラーコード46 |
| 失敗メッセージ | 赤色太字テキスト | ANSIカラーコード196 |
| ビルド出力 | 標準出力 | ビルドスクリプトの出力（verbose時） |
| DEBUG出力 | 標準出力 | キャッシュ使用状況等の情報 |

## イベント仕様

### 1-ビルド処理フロー

| 処理ステップ | 条件 | 処理内容 |
|-------------|------|---------|
| フェッチ | 常時 | handle_fetch()でソースコード取得 |
| ターゲットディレクトリ作成 | 常時 | create_target_dir()でtarget/{target}/作成 |
| ビルド依存解決 | 常時 | get_build_deps_recursive()で依存関係取得 |
| キャッシュチェック | stage_dirが存在 | source_modified比較でリビルド判定 |
| sysroot構築 | build.kind != Remote | build_deps_dir()でsysrootを構築 |
| toolchain構築 | !is_host && host_deps存在 | build_deps_dir()でtoolchainを構築 |
| ビルドスクリプト実行 | stage_dirが未存在 | cookbook_redoxer経由でbashスクリプト実行 |
| オプショナルパッケージ分離 | optional_packagesが設定 | globパターンでファイルを振り分け |
| パッケージング | 常時 | package()でpkgarアーカイブ作成 |

### 2-ビルドテンプレート別処理

| テンプレート | スクリプト内容 |
|-------------|---------------|
| Cargo | `DYNAMIC_INIT\nPACKAGE_PATH={path} cookbook_cargo {flags}` |
| Configure | `DYNAMIC_INIT\nCOOKBOOK_CONFIGURE_FLAGS+=(...)\ncookbook_configure` |
| CMake | `DYNAMIC_INIT\nCOOKBOOK_CMAKE_FLAGS+=(...)\ncookbook_cmake` |
| Meson | `DYNAMIC_INIT\nCOOKBOOK_MESON_FLAGS+=(...)\ncookbook_meson` |
| Custom | ユーザー定義スクリプトをそのまま実行 |
| Remote | fetch_remote()で事前ビルド済みパッケージを取得 |
| None | 何もしない（メタパッケージ用） |

### 3-自動依存関係検出

| 処理ステップ | 処理内容 |
|-------------|---------|
| バイナリ走査 | usr/bin, usr/lib, usr/libexec等のELFファイルを列挙 |
| DT_NEEDED抽出 | object crateでELFを解析しDT_NEEDEDを取得 |
| 依存パッケージ特定 | dep_pkgarsからライブラリ提供パッケージを特定 |
| auto_deps.toml保存 | 検出結果をキャッシュとして保存 |

## データベース更新仕様

本画面はファイルシステムベースの操作を行い、データベースは使用しません。

### ファイルシステム操作

| 操作 | 対象パス | 操作種別 | 概要 |
|------|---------|---------|------|
| ソース取得 | recipes/{category}/{recipe}/source | CREATE | fetch処理でソースを配置 |
| ビルドディレクトリ | recipes/{category}/{recipe}/target/{target}/build | CREATE | ビルド作業ディレクトリ |
| sysroot | recipes/{category}/{recipe}/target/{target}/sysroot | CREATE | 依存パッケージを展開 |
| toolchain | recipes/{category}/{recipe}/target/{target}/toolchain | CREATE | ホストツールを展開 |
| stage | recipes/{category}/{recipe}/target/{target}/stage | CREATE | ビルド成果物を配置 |
| pkgar | recipes/{category}/{recipe}/target/{target}/stage.pkgar | CREATE | パッケージアーカイブ |
| stage.toml | recipes/{category}/{recipe}/target/{target}/stage.toml | CREATE | パッケージメタデータ |
| auto_deps.toml | recipes/{category}/{recipe}/target/{target}/auto_deps.toml | CREATE | 自動検出依存関係 |
| ログ | build/logs/{target}/{recipe}.log | CREATE | ビルドログ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG_SUCCESS | 成功 | "cook {レシピ名} - successful" | ビルド成功時 |
| MSG_FAILED | エラー | "cook {レシピ名} - failed" | ビルド失敗時 |
| MSG_CACHED_BUILD | 情報 | "DEBUG: using cached build" | キャッシュ使用時 |
| MSG_CACHED_SYSROOT | 情報 | "DEBUG: using cached sysroot" | sysrootキャッシュ使用時 |
| MSG_UPDATING | 情報 | "DEBUG: updating '{path}'" | ディレクトリ更新時 |
| MSG_NEEDS | 情報 | "DEBUG: {binary} needs {lib}" | 依存関係検出時（verbose） |
| MSG_PROVIDES | 情報 | "DEBUG: {package} provides {lib}" | 依存パッケージ特定時（verbose） |
| MSG_MISSING | 情報 | "INFO: {lib} missing" | 依存関係が見つからない場合 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| フェッチ失敗 | エラーメッセージ表示、nonstopモードでなければ終了 |
| ビルドスクリプト失敗 | エラーメッセージ表示、nonstopモードでなければ終了 |
| パッケージング失敗 | エラーメッセージ表示、終了 |
| 依存パッケージ未ビルド | エラーメッセージ表示、終了 |
| 署名鍵ファイル不在 | エラーメッセージ表示、終了 |
| nonstopモードでの失敗 | stageディレクトリを削除し、次のレシピに進む |

## 備考

- cookコマンドはfetch→build→packageの3段階を内部的に実行
- キャッシュ機構により、ソースやレシピが変更されていなければ再ビルドをスキップ
- 依存パッケージのpkgarファイルが更新されていた場合もリビルドを実行
- clean_targetオプションでビルド後に中間ファイルを削除可能（CI向け）
- TUIモードでは並列ビルドの進捗をリアルタイム表示
- ビルド完了後、自動的にrepo_builderを呼び出してリポジトリを更新

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ビルド処理に関連するデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | recipe.rs | `src/recipe.rs` | BuildKind列挙型でビルドテンプレートを定義 |
| 1-2 | recipe.rs | `src/recipe.rs` | Recipe構造体でレシピ全体の設定を保持 |
| 1-3 | config.rs | `src/config.rs` | CookConfig構造体でビルド設定を管理 |

**読解のコツ**: BuildKindのバリアント（Cargo, Configure, Cmake, Meson, Custom, Remote, None）がビルド処理の分岐に直結。

#### Step 2: エントリーポイントを理解する

cookコマンドの処理起点から実際のビルド処理までの流れを把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | repo.rs | `src/bin/repo.rs` | main_inner関数（182-249行目）でコマンド解析とTUI/CLI分岐 |
| 2-2 | repo.rs | `src/bin/repo.rs` | repo_inner関数（286-355行目）でCookコマンドを処理 |
| 2-3 | repo.rs | `src/bin/repo.rs` | handle_cook関数（568-606行目）でビルド実行 |

**主要処理フロー**:
1. **194行目**: TUIモード判定（config.cook.tui）
2. **195行目**: TUIモードならrun_tui_cook()を呼び出し
3. **296-297行目**: handle_fetch()→handle_cook()の順で実行
4. **237-238行目**: ビルド完了後にpublish_packages()を呼び出し

#### Step 3: ビルド処理を理解する

cook_build.rs内のビルドロジックを把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cook_build.rs | `src/cook/cook_build.rs` | build関数（170-462行目）がメインのビルド処理 |
| 3-2 | cook_build.rs | `src/cook/cook_build.rs` | 192-206行目：依存パッケージのpkgarパス収集 |
| 3-3 | cook_build.rs | `src/cook/cook_build.rs` | 279-308行目：sysroot/toolchainの構築 |
| 3-4 | cook_build.rs | `src/cook/cook_build.rs` | 342-367行目：BuildKindに応じたスクリプト生成 |
| 3-5 | cook_build.rs | `src/cook/cook_build.rs` | 369-422行目：cookbook_redoxer経由でのスクリプト実行 |

**主要処理フロー**:
- **185-188行目**: BuildKind::Noneの場合は早期リターン
- **221-227行目**: キャッシュが有効ならビルドをスキップ
- **257-276行目**: source_modified比較によるリビルド判定
- **418-422行目**: BUILD_PRESCRIPT + SHARED_PRESCRIPT + script + BUILD_POSTSCRIPTを連結して実行

#### Step 4: パッケージング処理を理解する

package.rs内のパッケージング処理を把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | package.rs | `src/cook/package.rs` | package関数でpkgar作成とメタデータ生成 |

**主要処理フロー**:
- pkgar::create()でアーカイブ作成
- stage.tomlにパッケージメタデータを出力
- Ed25519署名の適用

#### Step 5: 自動依存関係検出を理解する

ELFバイナリからの依存関係自動検出ロジックを把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | cook_build.rs | `src/cook/cook_build.rs` | auto_deps_from_dynamic_linking関数（24-154行目） |
| 5-2 | cook_build.rs | `src/cook/cook_build.rs` | build_auto_deps関数（575-611行目） |

**主要処理フロー**:
- **36-77行目**: usr/bin, usr/lib等をDFSで走査
- **80-107行目**: object crateでELFを解析しDT_NEEDEDを抽出
- **115-144行目**: dep_pkgarsからライブラリ提供パッケージを特定

### プログラム呼び出し階層図

```
main() [repo.rs:174]
    │
    └─ main_inner() [repo.rs:182]
           │
           ├─ parse_args() [repo.rs:373]
           │      └─ CookRecipe::get_build_deps_recursive()
           │
           ├─ [TUI] run_tui_cook() [repo.rs:1012]
           │      └─ (TUIメイン画面参照)
           │
           └─ [CLI] repo_inner() [repo.rs:286]
                  │
                  ├─ handle_fetch() [repo.rs:553]
                  │      └─ fetch() [fetch.rs:117]
                  │
                  └─ handle_cook() [repo.rs:568]
                         │
                         ├─ create_target_dir() [fs.rs]
                         │
                         └─ build() [cook_build.rs:170]
                                │
                                ├─ get_build_deps_recursive()
                                │
                                ├─ build_deps_dir() [cook_build.rs:511]
                                │      └─ pkgar::extract()
                                │
                                ├─ run_command_stdin() [fs.rs]
                                │      └─ cookbook_redoxer → bash
                                │
                                ├─ move_dir_all_fn() [fs.rs]
                                │
                                └─ build_auto_deps() [cook_build.rs:575]
                                       └─ auto_deps_from_dynamic_linking()
                         │
                         └─ package() [package.rs]
                                ├─ pkgar::create()
                                └─ serialize_and_write(stage.toml)
           │
           └─ publish_packages() [repo.rs:357]
                  └─ repo_builder [repo_builder.rs]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

コマンドライン引数 ────▶ parse_args() ────▶ CliConfig, recipes
       │
       ▼
  recipe.toml ────────▶ CookRecipe解析 ────▶ BuildKind判定
       │
       ▼
  [依存解決]
  dep_pkgars ─────────▶ build_deps_dir() ────▶ sysroot/
       │                                        toolchain/
       ▼
  [ビルド]
  source/ ────────────▶ cookbook_redoxer ────▶ stage.tmp/
       │                      │
       │                      ├─ BUILD_PRESCRIPT
       │                      ├─ SHARED_PRESCRIPT
       │                      ├─ (テンプレート別スクリプト)
       │                      └─ BUILD_POSTSCRIPT
       │
       ▼
  [パッケージング]
  stage/ ─────────────▶ package() ────▶ stage.pkgar
       │                    │            stage.toml
       │                    │
       ▼                    ▼
  [自動依存検出]
  ELFバイナリ ─────────▶ auto_deps_from_dynamic_linking()
       │                    │
       │                    └─▶ auto_deps.toml
       ▼
  repo/{target}/ ◀──── repo_builder
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| repo.rs | `src/bin/repo.rs` | ソース | cookコマンドのエントリーポイント |
| cook_build.rs | `src/cook/cook_build.rs` | ソース | ビルド処理の実装 |
| package.rs | `src/cook/package.rs` | ソース | パッケージング処理 |
| fetch.rs | `src/cook/fetch.rs` | ソース | ソース取得処理 |
| script.rs | `src/cook/script.rs` | ソース | ビルドスクリプト定義（BUILD_PRESCRIPT等） |
| fs.rs | `src/cook/fs.rs` | ソース | ファイルシステム操作 |
| recipe.rs | `src/recipe.rs` | ソース | レシピ解析 |
| config.rs | `src/config.rs` | ソース | 設定管理 |
| repo_builder.rs | `src/bin/repo_builder.rs` | ソース | リポジトリ公開処理 |
