# 画面設計書 5-repo unfetchコマンド画面

## 概要

本ドキュメントは、Redox OS Build System（cookbook）の`repo unfetch`コマンド画面の設計仕様を定義します。この画面はレシピのソースコードを削除するCLIインターフェースです。

### 本画面の処理概要

`repo unfetch`コマンドは、指定されたレシピのソースディレクトリ（source）を削除するクリーンアップ用コマンドです。ディスク容量の確保やソースの再取得が必要な場合に使用します。

**業務上の目的・背景**：ビルドシステムを長期間使用していると、多数のレシピのソースコードがディスク容量を圧迫します。unfetchコマンドを使用することで、不要になったソースコードを削除し、ディスク容量を確保できます。また、ソースコードに問題が発生した場合に、強制的に再取得するためのリセット手段としても使用されます。

**画面へのアクセス方法**：ターミナルから`repo unfetch <レシピ名>...`コマンドを実行します。`--all`フラグを使用すると全レシピのソースを削除できます。

**主要な操作・処理内容**：
1. 指定されたレシピのsourceディレクトリを削除
2. 指定されたレシピのtargetディレクトリも削除（source削除と同時に実行）
3. 複数レシピの一括削除

**画面遷移**：
- 遷移元：ターミナル（コマンドライン）
- 遷移先：成功時 → 完了メッセージ表示

**権限による表示制御**：特になし。ファイルシステムの削除権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 29 | unfetchコマンド | 主機能 | レシピのソースディレクトリ削除実行 |
| 1 | レシピ解析 | API連携 | 削除対象レシピの特定 |

## 画面種別

CLI（Command Line Interface）- テキストベースコマンド画面

## URL/ルーティング

コマンドラインインターフェース経由でのアクセス：
```
repo unfetch [flags] <recipe1> <recipe2> ...
```

## 入出力項目

### 入力項目（コマンドライン引数）

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| recipe | String[] | No* | 削除対象のレシピ名（複数指定可） |
| --cookbook | Path | No | recipesフォルダのパス（デフォルト: $PWD/recipes） |
| --all | Flag | No | 全レシピを対象（*--allまたはrecipe指定が必須） |
| --category | Path | No | 指定カテゴリ内の全レシピを対象 |

### 出力項目

| 項目 | 型 | 説明 |
|------|-----|------|
| 成功メッセージ | String | "unfetch {レシピ名} - successful" |
| 失敗メッセージ | String | "unfetch {レシピ名} - failed" |

## 表示項目

### コマンド実行時の出力

| 項目 | 表示形式 | 説明 |
|------|---------|------|
| 成功メッセージ | 緑色太字テキスト | ANSIカラーコード46 |
| 失敗メッセージ | 赤色太字テキスト | ANSIカラーコード196 |
| 完了サマリー | 標準出力 | "Command 'unfetch' completed for N recipes." |

## イベント仕様

### 1-削除処理

| 処理ステップ | 条件 | 処理内容 |
|-------------|------|---------|
| ソース削除 | source/が存在する | fs::remove_dir_all()でsourceディレクトリを再帰削除 |
| ターゲット削除 | target/が存在する | fs::remove_dir_all()でtargetディレクトリを再帰削除 |

## データベース更新仕様

本画面はファイルシステムベースの操作を行い、データベースは使用しません。

### ファイルシステム操作

| 操作 | 対象パス | 操作種別 | 概要 |
|------|---------|---------|------|
| ソース削除 | recipes/{category}/{recipe}/source | DELETE | ソースディレクトリを再帰削除 |
| ターゲット削除 | recipes/{category}/{recipe}/target | DELETE | ターゲットディレクトリを再帰削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG_SUCCESS | 成功 | "unfetch {レシピ名} - successful" | 削除成功時 |
| MSG_FAILED | エラー | "unfetch {レシピ名} - failed" | 削除失敗時 |
| MSG_COMPLETED | 情報 | "Command 'unfetch' completed for N recipes." | 複数レシピ完了時 |
| MSG_DELETE_FAILED | エラー | "failed to delete {path}" | ディレクトリ削除失敗時 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| ディレクトリ削除失敗 | エラーメッセージを表示し、nonstopモードでなければ終了 |
| 権限不足 | IOエラーを表示し終了 |
| ディレクトリが存在しない | 何もせず成功として扱う |

## 備考

- unfetchはsourceとtargetの両方を削除する（handle_clean関数でsource=true, target=trueで呼び出し）
- シンボリックリンクの場合もremove_dir_allで削除される
- --allフラグは安全のためcleaningコマンド（clean, unfetch）でのみ使用可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | repo.rs | `src/bin/repo.rs` | repo_inner関数（286-355行目）でUnfetchコマンドを処理 |
| 1-2 | repo.rs | `src/bin/repo.rs` | handle_clean関数（619-634行目）で削除処理を実行 |

**主要処理フロー**:
1. **349行目**: `CliCommand::Unfetch => handle_clean(recipe, config, true, true)?`
2. **625-628行目**: source=trueならsource/ディレクトリを削除
3. **629-632行目**: target=trueならtarget/ディレクトリを削除

### プログラム呼び出し階層図

```
main() [repo.rs:174]
    │
    └─ main_inner() [repo.rs:182]
           │
           └─ repo_inner() [repo.rs:286]
                  │
                  └─ handle_clean(source=true, target=true) [repo.rs:619]
                         │
                         ├─ fs::remove_dir_all(target/)
                         │
                         └─ fs::remove_dir_all(source/)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

コマンドライン引数 ────▶ parse_args() ────▶ recipes
       │
       ▼
  recipe.dir ─────────▶ handle_clean()
       │                      │
       │                      ├──▶ remove_dir_all(target/) ────▶ 削除完了
       │                      │
       │                      └──▶ remove_dir_all(source/) ────▶ 削除完了
       │
       ▼
  完了メッセージ ◀─── print_success()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| repo.rs | `src/bin/repo.rs` | ソース | unfetchコマンドのエントリーポイントとhandle_clean関数 |
