# 画面設計書 7-repo pushコマンド画面

## 概要

本ドキュメントは、Redox OS Build System（cookbook）の`repo push`コマンド画面の設計仕様を定義します。この画面はビルド済みパッケージをsysrootに展開するCLIインターフェースです。

### 本画面の処理概要

`repo push`コマンドは、指定されたレシピのpkgarアーカイブをsysrootディレクトリに展開します。これにより、ビルドしたパッケージを実際のシステム環境にインストールできます。

**業務上の目的・背景**：Redox OSのパッケージを開発環境やターゲットシステムにインストールする際に使用します。ビルドしたパッケージをテストしたり、他のパッケージの依存関係として使用する際に必要な操作です。sysrootへの展開により、パッケージの動作確認やシステムイメージの構築が可能になります。

**画面へのアクセス方法**：ターミナルから`repo push <レシピ名>...`コマンドを実行します。`--with-package-deps`フラグを使用すると依存パッケージも一緒にインストールできます。

**主要な操作・処理内容**：
1. 指定されたレシピのpkgarアーカイブを取得
2. Ed25519公開鍵で署名を検証
3. sysrootディレクトリにファイルを展開
4. 依存パッケージの再帰的インストール（オプション）

**画面遷移**：
- 遷移元：ターミナル（コマンドライン）
- 遷移先：成功時 → 完了メッセージ表示、失敗時 → エラーメッセージ表示

**権限による表示制御**：特になし。sysrootディレクトリへの書き込み権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 31 | pushコマンド | 主機能 | パッケージのsysrootへの展開実行 |
| 14 | 依存関係解決 | API連携 | --with-package-deps指定時の依存関係解決 |
| 1 | レシピ解析 | API連携 | 展開対象パッケージの特定 |

## 画面種別

CLI（Command Line Interface）- テキストベースコマンド画面

## URL/ルーティング

コマンドラインインターフェース経由でのアクセス：
```
repo push [flags] <recipe1> <recipe2> ...
```

## 入出力項目

### 入力項目（コマンドライン引数）

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| recipe | String[] | Yes | インストール対象のレシピ名（複数指定可） |
| --cookbook | Path | No | recipesフォルダのパス（デフォルト: $PWD/recipes） |
| --repo | Path | No | repoフォルダのパス（デフォルト: $PWD/repo） |
| --sysroot | Path | No | インストール先（デフォルト: Redoxなら"/"、それ以外は$PWD/sysroot） |
| --with-package-deps | Flag | No | パッケージ依存関係も含めてインストール |

### 出力項目

| 項目 | 型 | 説明 |
|------|-----|------|
| 成功メッセージ | String | "push {レシピ名} - successful" |
| 失敗メッセージ | String | "push {レシピ名} - failed" |
| サマリー | String | "Pushed {サイズ} of {N} packages" |

## 表示項目

### コマンド実行時の出力

| 項目 | 表示形式 | 説明 |
|------|---------|------|
| 成功メッセージ | 緑色太字テキスト | ANSIカラーコード46 |
| 失敗メッセージ | 赤色太字テキスト | ANSIカラーコード196 |
| パッケージツリー | テキスト | --with-package-deps時に依存関係ツリーを表示 |
| サマリー | 標準出力 | 展開したパッケージ数と合計サイズ |

## イベント仕様

### 1-パッケージ展開処理

| 処理ステップ | 条件 | 処理内容 |
|-------------|------|---------|
| アーカイブ取得 | 常時 | repo/{target}/{name}.pkgarのパスを取得 |
| 署名検証 | 常時 | build/id_ed25519.pub.tomlで署名を検証 |
| ファイル展開 | 署名検証成功 | pkgar::extract()でsysrootに展開 |
| 依存関係処理 | --with-package-deps | walk_tree_entry()で依存パッケージも展開 |

### 2-依存関係ツリー処理（--with-package-deps時）

| 処理ステップ | 処理内容 |
|-------------|---------|
| ツリー走査 | walk_tree_entry()で依存関係を再帰的に処理 |
| 重複排除 | visitedセットで処理済みパッケージをスキップ |
| サイズ集計 | total_sizeにパッケージサイズを加算 |

## データベース更新仕様

本画面はファイルシステムベースの操作を行い、データベースは使用しません。

### ファイルシステム操作

| 操作 | 対象パス | 操作種別 | 概要 |
|------|---------|---------|------|
| ファイル展開 | {sysroot}/* | CREATE | pkgarアーカイブの内容を展開 |

### 展開先ディレクトリ構造

| パス | 説明 |
|------|------|
| {sysroot}/bin | 実行ファイル |
| {sysroot}/lib | ライブラリ |
| {sysroot}/usr/bin | ユーザー実行ファイル |
| {sysroot}/usr/lib | ユーザーライブラリ |
| {sysroot}/usr/include | ヘッダファイル |
| {sysroot}/usr/share | 共有データ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG_SUCCESS | 成功 | "push {レシピ名} - successful" | 展開成功時 |
| MSG_FAILED | エラー | "push {レシピ名} - failed" | 展開失敗時 |
| MSG_NOT_BUILT | エラー | "Package {name} has not been built" | pkgarファイルが存在しない場合 |
| MSG_INSTALL_FAILED | エラー | "failed to install '{archive}' in '{sysroot}'" | pkgar展開失敗時 |
| MSG_SUMMARY | 情報 | "Pushed {size} of {N} packages" | 完了時（verbose） |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| pkgarファイル不在 | "Package has not been built"エラー、nonstopモードなら継続 |
| 署名検証失敗 | pkgar::extractがエラーを返す、メッセージ表示して終了 |
| 展開失敗 | エラーメッセージ表示、nonstopモードなら継続 |
| 権限不足 | IOエラーを表示し終了 |

## 備考

- sysrootのデフォルト値はRedox OS上では"/"、それ以外では"$PWD/sysroot"
- 公開鍵ファイルは"build/id_ed25519.pub.toml"を使用
- --with-package-depsを指定しない場合、単一パッケージのみ展開
- PUSH_SYSROOT_DIRはOnceLockで静的に保持（スレッド間で共有）
- verbose時のみサマリー（パッケージ数とサイズ）を表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | repo.rs | `src/bin/repo.rs` | main_inner関数（208-209行目）でPushコマンドを処理 |
| 1-2 | repo.rs | `src/bin/repo.rs` | handle_push関数（637-733行目）で展開処理を実行 |

**主要処理フロー**:
1. **208-209行目**: `CliCommand::Push`の場合、handle_push()を呼び出し
2. **644行目**: PUSH_SYSROOT_DIR.set()でsysrootパスを保存
3. **645-681行目**: handle_push_inner()クロージャでpkgar展開処理を定義
4. **683-716行目**: --with-package-depsに応じた処理分岐

#### Step 2: パッケージ展開処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | repo.rs | `src/bin/repo.rs` | handle_push_inner（645-681行目）で実際の展開処理 |
| 2-2 | tree.rs | `src/cook/tree.rs` | walk_tree_entry関数（38-107行目）で依存関係ツリーを走査 |

**主要処理フロー**:
- **650行目**: pkey_path = "build/id_ed25519.pub.toml"で公開鍵パスを設定
- **653-658行目**: pkgar::extract()でsysrootに展開
- **660-663行目**: パッケージ未ビルドの場合エラー
- **668-679行目**: 成功/失敗に応じたメッセージ出力

### プログラム呼び出し階層図

```
main() [repo.rs:174]
    │
    └─ main_inner() [repo.rs:182]
           │
           └─ handle_push() [repo.rs:637]
                  │
                  ├─ [--with-package-deps]
                  │      └─ walk_tree_entry() [tree.rs:38]
                  │             └─ handle_push_inner()
                  │                    └─ pkgar::extract()
                  │
                  └─ [単一パッケージ]
                         └─ handle_push_inner()
                                └─ pkgar::extract()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

コマンドライン引数 ────▶ parse_args() ────▶ recipes, sysroot_dir
       │
       ▼
  repo/{target}/{name}.pkgar
       │
       └──────────────────▶ pkgar::extract()
                                  │
                                  ├─ 署名検証（id_ed25519.pub.toml）
                                  │
                                  └──▶ sysroot/* にファイル展開
       │
       ▼
  サマリー表示 ◀─── "Pushed {size} of {N} packages"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| repo.rs | `src/bin/repo.rs` | ソース | pushコマンドのエントリーポイントとhandle_push関数 |
| tree.rs | `src/cook/tree.rs` | ソース | 依存関係ツリー走査（walk_tree_entry） |
| pkgar (外部) | - | ライブラリ | パッケージアーカイブの展開と署名検証 |
