# 画面設計書 8-repo treeコマンド画面

## 概要

本ドキュメントは、Redox OS Build System（cookbook）の`repo tree`コマンド画面の設計仕様を定義します。この画面はレシピの依存関係ツリーを表示するCLIインターフェースです。

### 本画面の処理概要

`repo tree`コマンドは、指定されたレシピのパッケージ依存関係をツリー形式で表示し、推定イメージサイズを計算します。各パッケージのビルド状態やサイズも併せて表示されます。

**業務上の目的・背景**：Redox OSのディストリビューションを構築する際、どのパッケージがどの依存関係を持つかを把握することは重要です。treeコマンドにより、パッケージの依存関係を視覚的に確認でき、イメージサイズの見積もりも可能になります。これはディスク容量の計画や、不要な依存関係の特定に役立ちます。

**画面へのアクセス方法**：ターミナルから`repo tree <レシピ名>...`コマンドを実行します。複数のルートパッケージを指定可能です。

**主要な操作・処理内容**：
1. 指定されたレシピの依存関係を再帰的に解決
2. ツリー形式で依存関係を表示
3. 各パッケージのビルド状態とサイズを表示
4. 合計サイズと総パッケージ数を計算して表示

**画面遷移**：
- 遷移元：ターミナル（コマンドライン）
- 遷移先：なし（情報表示のみ）

**権限による表示制御**：特になし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | treeコマンド | 主機能 | パッケージ依存関係ツリーの表示 |
| 48 | 依存関係ツリー表示 | 主機能 | 依存関係のツリー形式表示とイメージサイズ推定 |
| 49 | ファイルサイズフォーマット | 補助機能 | バイト数の人間可読形式変換 |
| 14 | 依存関係解決 | API連携 | パッケージ依存関係の再帰的解決 |

## 画面種別

CLI（Command Line Interface）- テキストベースコマンド画面

## URL/ルーティング

コマンドラインインターフェース経由でのアクセス：
```
repo tree [flags] <recipe1> <recipe2> ...
```

## 入出力項目

### 入力項目（コマンドライン引数）

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| recipe | String[] | Yes | 表示対象のレシピ名（複数指定可） |
| --cookbook | Path | No | recipesフォルダのパス（デフォルト: $PWD/recipes） |
| --with-package-deps | Flag | No | パッケージ依存関係を含める |

### 出力項目

| 項目 | 型 | 説明 |
|------|-----|------|
| 依存関係ツリー | String | ツリー形式のパッケージ依存関係 |
| サマリー | String | "Estimated image size: {サイズ} of {N} packages" |

## 表示項目

### ツリー表示フォーマット

| 要素 | 表示形式 | 説明 |
|------|---------|------|
| ツリー接続線 | ├── / └── | 兄弟/最終要素を示す罫線 |
| パッケージ名 | テキスト | パッケージの識別名 |
| サイズ | [X.XX MiB] | ビルド済みパッケージのサイズ |
| 未ビルド | (not built) | パッケージが未ビルドの場合 |
| 重複 | （サイズなし） | 既に表示済みのパッケージ |
| 依存情報欠落 | (dependency info missing) | 依存情報が見つからない場合 |

### 出力例

```
├── package-a [1.23 MiB]
│   ├── dependency-1 [0.50 MiB]
│   └── dependency-2 [0.30 MiB]
└── package-b [2.00 MiB]
    └── dependency-1

Estimated image size: 4.03 MiB of 4 packages
```

## イベント仕様

### 1-ツリー表示処理

| 処理ステップ | 処理内容 |
|-------------|---------|
| ルートパッケージ取得 | is_deps=falseのレシピをルートとして抽出 |
| ツリー走査 | display_tree_entry()で再帰的に表示 |
| サイズ計算 | pkgarファイルのサイズを加算 |
| 重複排除 | visitedセットで既表示パッケージをスキップ |

### 2-サイズフォーマット

| サイズ | 表示形式 |
|--------|---------|
| 0 B | "0 B" |
| < 1 KiB | "X B" |
| < 1 MiB | "X.XX KiB" |
| < 1 GiB | "X.XX MiB" |
| >= 1 GiB | "X.XX GiB" |

## データベース更新仕様

本画面は読み取り専用で、データベースやファイルシステムの更新は行いません。

### 参照するファイル

| ファイル | 用途 |
|---------|------|
| repo/{target}/{name}.pkgar | パッケージサイズの取得 |
| recipes/{category}/{recipe}/target/{target}/stage.toml | 依存関係情報の取得 |
| recipe.toml | レシピの依存関係定義 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG_NOT_BUILT | 情報 | "(not built)" | pkgarファイルが存在しない場合 |
| MSG_MISSING | 情報 | "(dependency info missing)" | 依存情報が見つからない場合 |
| MSG_SUMMARY | 情報 | "Estimated image size: {size} of {N} packages" | ツリー表示完了時 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| レシピ解析失敗 | エラーメッセージを表示（依存関係ツリーに含まれない） |
| stage.toml読み込み失敗 | recipe.tomlの依存関係を使用 |
| pkgarファイル不在 | "(not built)"と表示 |

## 備考

- treeコマンドは"informational"コマンドとして分類され、verboseフラグは自動的に無効化される
- 重複するパッケージは初回のみサイズ表示、2回目以降はサイズなしで表示
- auto_deps（自動検出依存関係）も含めた依存関係を表示
- stage.tomlが存在する場合はより正確な依存関係を使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | repo.rs | `src/bin/repo.rs` | main_inner関数（205-206行目）でTreeコマンドを処理 |
| 1-2 | repo.rs | `src/bin/repo.rs` | handle_tree関数（735-766行目）で表示処理を実行 |

**主要処理フロー**:
1. **205-206行目**: `CliCommand::Tree`の場合、handle_tree()を呼び出し
2. **742-750行目**: ルートパッケージをループしてdisplay_tree_entry()を呼び出し
3. **752-763行目**: サマリー（合計サイズとパッケージ数）を表示

#### Step 2: ツリー表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | tree.rs | `src/cook/tree.rs` | display_tree_entry関数（19-36行目） |
| 2-2 | tree.rs | `src/cook/tree.rs` | walk_tree_entry関数（38-107行目）で再帰処理 |
| 2-3 | tree.rs | `src/cook/tree.rs` | display_pkg_fn関数（109-124行目）で表示フォーマット |
| 2-4 | tree.rs | `src/cook/tree.rs` | format_size関数（166-174行目）でサイズフォーマット |

**主要処理フロー**:
- **47-53行目**: recipe_mapからパッケージを取得、なければMissingエントリ
- **59-63行目**: visitedチェックで重複判定
- **72-74行目**: Built時にtotal_sizeにサイズを加算
- **77-86行目**: stage.tomlまたはrecipe.tomlから依存関係を取得
- **94-106行目**: 依存パッケージを再帰的に処理

### プログラム呼び出し階層図

```
main() [repo.rs:174]
    │
    └─ main_inner() [repo.rs:182]
           │
           └─ handle_tree() [repo.rs:735]
                  │
                  └─ display_tree_entry() [tree.rs:19]
                         │
                         └─ walk_tree_entry() [tree.rs:38]
                                │
                                ├─ display_pkg_fn() [tree.rs:109]
                                │      └─ format_size() [tree.rs:166]
                                │
                                └─ walk_tree_entry() (再帰)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

コマンドライン引数 ────▶ parse_args() ────▶ recipes
       │
       ▼
  recipe_map ─────────▶ handle_tree()
       │                      │
       ▼                      ▼
  stage.toml ──────────▶ walk_tree_entry()
  (or recipe.toml)            │
       │                      ├──▶ display_pkg_fn() ────▶ ツリー行出力
       │                      │
       ▼                      ▼
  pkgarファイル ───────▶ fs::metadata().len() ────▶ サイズ取得
       │
       ▼
  サマリー出力 ◀─── "Estimated image size: {size} of {N} packages"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| repo.rs | `src/bin/repo.rs` | ソース | treeコマンドのエントリーポイントとhandle_tree関数 |
| tree.rs | `src/cook/tree.rs` | ソース | ツリー表示処理（display_tree_entry、walk_tree_entry、format_size） |
