# 画面設計書 9-repo findコマンド画面

## 概要

本ドキュメントは、Redox OS Build System（cookbook）の`repo find`コマンド画面の設計仕様を定義します。この画面はレシピのパスを表示するCLIインターフェースです。

### 本画面の処理概要

`repo find`コマンドは、指定されたレシピのディレクトリパスを標準出力に表示します。シンプルな情報取得用コマンドです。

**業務上の目的・背景**：多数のレシピが存在する中で、特定のレシピがどこにあるかを素早く確認するために使用します。スクリプトやパイプラインで他のコマンドと組み合わせて使用することで、レシピディレクトリへの自動ナビゲーションが可能になります。

**画面へのアクセス方法**：ターミナルから`repo find <レシピ名>...`コマンドを実行します。複数のレシピを指定可能です。

**主要な操作・処理内容**：
1. 指定されたレシピ名からディレクトリパスを解決
2. パスを標準出力に表示

**画面遷移**：
- 遷移元：ターミナル（コマンドライン）
- 遷移先：なし（情報表示のみ）

**権限による表示制御**：特になし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 33 | findコマンド | 主機能 | レシピのパス表示 |
| 1 | レシピ解析 | API連携 | レシピディレクトリパスの取得 |

## 画面種別

CLI（Command Line Interface）- テキストベースコマンド画面

## URL/ルーティング

コマンドラインインターフェース経由でのアクセス：
```
repo find [flags] <recipe1> <recipe2> ...
```

## 入出力項目

### 入力項目（コマンドライン引数）

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| recipe | String[] | Yes | 検索対象のレシピ名（複数指定可） |
| --cookbook | Path | No | recipesフォルダのパス（デフォルト: $PWD/recipes） |

### 出力項目

| 項目 | 型 | 説明 |
|------|-----|------|
| パス | String | レシピディレクトリの絶対パス |

## 表示項目

### コマンド実行時の出力

| 項目 | 表示形式 | 説明 |
|------|---------|------|
| パス | テキスト（1行） | レシピディレクトリの絶対パス |

### 出力例

```
$ repo find hello
/path/to/recipes/demos/hello

$ repo find hello world
/path/to/recipes/demos/hello
/path/to/recipes/demos/world
```

## イベント仕様

### 1-パス表示処理

| 処理ステップ | 処理内容 |
|-------------|---------|
| レシピ解決 | CookRecipe::from_name()でレシピ情報を取得 |
| パス表示 | println!()でrecipe.dirを出力 |

## データベース更新仕様

本画面は読み取り専用で、データベースやファイルシステムの更新は行いません。

### 参照するファイル

| ファイル | 用途 |
|---------|------|
| recipes/{category}/{recipe}/recipe.toml | レシピの存在確認 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG_PATH | 情報 | "{レシピディレクトリパス}" | レシピ発見時 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| レシピが見つからない | CookRecipe::from_nameがエラーを返し、エラーメッセージを表示 |

## 備考

- findコマンドは"informational"コマンドとして分類され、verboseフラグは自動的に無効化される
- 出力はパスのみで、追加のメッセージは表示されない
- シェルスクリプトでの使用を想定したシンプルな出力形式

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | repo.rs | `src/bin/repo.rs` | repo_inner関数（286-355行目）でFindコマンドを処理 |

**主要処理フロー**:
1. **353行目**: `CliCommand::Find => println!("{}", recipe.dir.display())`

### プログラム呼び出し階層図

```
main() [repo.rs:174]
    │
    └─ main_inner() [repo.rs:182]
           │
           └─ repo_inner() [repo.rs:286]
                  │
                  └─ println!("{}", recipe.dir.display()) [repo.rs:353]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

コマンドライン引数 ────▶ parse_args() ────▶ recipes
       │
       ▼
  recipe.dir ─────────▶ println!() ────▶ 標準出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| repo.rs | `src/bin/repo.rs` | ソース | findコマンドの処理（353行目の1行のみ） |
| recipe.rs | `src/recipe.rs` | ソース | CookRecipe構造体とdirフィールド |
