---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：1-TUIメイン画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **権限による表示制御**：コード上で権限チェックの実装が確認できず
  2. **環境変数COOKBOOK_LOGSのデフォルト値**：!CIという記述の正確性要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bin/repo.rs` 42-75行目（REPO_HELP_STR定数）
- E-02: `src/bin/repo.rs` 77-88行目（CliConfig構造体）
- E-03: `src/bin/repo.rs` 90-114行目（CliCommand列挙型）
- E-04: `src/bin/repo.rs` 182-249行目（main_inner関数）
- E-05: `src/bin/repo.rs` 772-780行目（RecipeStatus列挙型）
- E-06: `src/bin/repo.rs` 782-794行目（StatusUpdate列挙型）
- E-07: `src/bin/repo.rs` 812-836行目（TuiApp構造体）
- E-08: `src/bin/repo.rs` 921-1009行目（update_status関数）
- E-09: `src/bin/repo.rs` 1012-1501行目（run_tui_cook関数）
- E-10: `src/bin/repo.rs` 1517-1597行目（handle_main_event関数）
- E-11: `src/bin/repo.rs` 1234-1243行目（Layout定義）
- E-12: `src/bin/repo.rs` 1247-1271行目（Fetch Queueパネル描画）
- E-13: `src/bin/repo.rs` 1274-1340行目（Cook Queueパネル描画）
- E-14: `src/bin/repo.rs` 1356-1443行目（Logパネル描画）
- E-15: `src/bin/repo.rs` 1599-1608行目（kill_everything関数）
- E-16: `src/bin/repo.rs` 1635-1707行目（draw_prompt関数）
- E-17: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-18: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）
- E-19: `docs/code-to-docs/画面一覧/画面遷移図.md`（画面遷移図）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ratatuiライブラリを使用したTUI | E-09（use ratatui::Terminal等のインポート） | ○ |
| C-02 | 3分割レイアウト | E-11, E-12, E-13, E-14 | ○ |
| C-03 | Fetch Queue、Cook Queue、Logの3パネル構成 | E-12, E-13, E-14 | ○ |
| C-04 | キー操作[1]でFetch Log表示 | E-10（1520-1522行目） | ○ |
| C-05 | キー操作[2]でCook Log表示 | E-10（1523-1525行目） | ○ |
| C-06 | キー操作[c]でビルド停止 | E-10（1526-1529行目）、E-15 | ○ |
| C-07 | PageUp/Downでスクロール | E-10（1538-1545行目） | ○ |
| C-08 | Endキーでログ追従 | E-10（1546-1548行目） | ○ |
| C-09 | 環境変数CIでTUI無効化 | E-01（66-67行目） | ○ |
| C-10 | RecipeStatusでPending/Fetching/Fetched/Cooking/Done/Failed状態管理 | E-05 | ○ |
| C-11 | StatusUpdateでスレッド間メッセージ通信 | E-06 | ○ |
| C-12 | TuiAppで画面状態を管理 | E-07 | ○ |
| C-13 | フェッチ完了時に左パネル非表示 | E-09（1234-1237行目、app.fetch_complete判定） | ○ |
| C-14 | 失敗時にプロンプトダイアログ表示 | E-08（933-934行目）、E-16 | ○ |
| C-15 | ログをファイル保存 | E-08（958-962行目、FlushLog処理） | ○ |
| C-16 | PTY経由でログ取得 | E-09（1735-1744行目、setup_logger） | ○ |
| C-17 | ANSIカラー対応 | E-14（1390-1398行目、into_text） | ○ |
| C-18 | ティックレート100ms | E-09（1021行目、TICK_RATE定数） | ○ |
| C-19 | Fetch QueueでPendingとFetchingを表示 | E-12（1250行目のfilter条件） | ○ |
| C-20 | Cook QueueでFetched/Cooking/Done/Failedを表示 | E-13（1277-1282行目のfilter条件） | ○ |
| C-21 | スピナーアニメーション | E-09（1225-1232行目） | ○ |
| C-22 | FetcherとCookerは別スレッド | E-09（1027行目、1136行目のthread::spawn） | ○ |
| C-23 | mpsc::channelでスレッド間通信 | E-09（1016-1017行目） | ○ |
| C-24 | termionバックエンド使用 | E-09（1220行目、TermionBackend） | ○ |
| C-25 | COOKBOOK_NONSTOPでスキップ継続 | E-01（70行目）、E-09（1060-1077行目） | ○ |
| C-26 | 関連機能No.27,28,35,36,1,14 | E-18 | ○ |
| C-27 | 権限による表示制御なし | **根拠なし** | △ |
| C-28 | COOKBOOK_LOGSのデフォルト値が!CI | E-01（67行目記載あり）だが実装確認要 | △ |

## 4) 不足情報（Unknown / Missing）
- 権限による表示制御に関する実装が見つからない
  - 候補：認証モジュール / RBAC設定ファイル / ユーザー管理機能
  - 推測：本システムはCLI/TUIツールであり、OSレベルの権限以外の制御は実装されていない可能性が高い

- COOKBOOK_LOGSのデフォルト値の実装確認
  - 候補：config.rs / environment変数処理部分
  - 推測：E-01のヘルプ文字列の記載を根拠としているが、実装コードでの確認が望ましい

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体として高い信頼度（0.93）
- 1: 中リスク - C-27（権限制御）は機能として存在しない可能性があり、セキュリティ観点でのレビュー推奨
- 0: 低リスク - C-28は動作に大きな影響を与えない補足情報

## 6) レビュアーチェックリスト（最小）
- [ ] 3分割レイアウトの実際の表示を確認（`repo cook`コマンドをTUIモードで実行）
- [ ] キーボード操作（1, 2, c, PageUp/Down, End）が設計書通りに動作するか確認
- [ ] 失敗時プロンプトダイアログの表示とRetry/Skip/Exit動作を確認
- [ ] ログファイル（build/logs/）への保存が正しく行われるか確認
- [ ] 環境変数CI設定時にTUIが無効化されることを確認
