---
generated_at: 2026-01-22 11:20:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-repo_builderコマンド画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり。レビュー優先度は低い。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bin/repo_builder.rs` 49-53行目（main関数）
- E-02: `src/bin/repo_builder.rs` 36-46行目（CliConfig::parse_args関数）
- E-03: `src/bin/repo_builder.rs` 56-276行目（publish_packages関数）
- E-04: `src/bin/repo_builder.rs` 63-68行目（ホストパッケージ除外）
- E-05: `src/bin/repo_builder.rs` 75-77行目（クロスターゲットスキップ）
- E-06: `src/bin/repo_builder.rs` 84行目（Package::new_recursive_nonstop呼び出し）
- E-07: `src/bin/repo_builder.rs` 96-132行目（パッケージコピーループ）
- E-08: `src/bin/repo_builder.rs` 16-26行目（is_newer関数）
- E-09: `src/bin/repo_builder.rs` 120-126行目（鮮度チェックとコピー）
- E-10: `src/bin/repo_builder.rs` 134-174行目（AppStream生成処理）
- E-11: `src/bin/repo_builder.rs` 43行目（COOKBOOK_APPSTREAM環境変数）
- E-12: `src/bin/repo_builder.rs` 151-166行目（appstreamcli compose実行）
- E-13: `src/bin/repo_builder.rs` 168-172行目（pkgar::create呼び出し）
- E-14: `src/bin/repo_builder.rs` 176-215行目（outdated_packages処理）
- E-15: `src/bin/repo_builder.rs` 195-197行目（fetch_get_source_info呼び出し）
- E-16: `src/bin/repo_builder.rs` 219-241行目（既存repo.toml読み込み）
- E-17: `src/bin/repo_builder.rs` 243-266行目（tomlスキャン）
- E-18: `src/bin/repo_builder.rs` 268-273行目（repo.toml書き込み）
- E-19: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-20: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | repo_builderでパッケージをリポジトリに公開 | E-01、E-03 | ○ |
| C-02 | REPO_DIRとレシピリストを引数で受け取る | E-02（40行目） | ○ |
| C-03 | COOKBOOK_APPSTREAM="true"でAppStream有効化 | E-11 | ○ |
| C-04 | ホストパッケージを除外（is_host()） | E-04 | ○ |
| C-05 | COOKBOOK_CROSS_TARGET設定時はスキップ | E-05 | ○ |
| C-06 | Package::new_recursive_nonstopで依存関係解決 | E-06 | ○ |
| C-07 | pkgarとstage.tomlをリポジトリにコピー | E-07（122-125行目） | ○ |
| C-08 | is_newer()で更新が必要な場合のみコピー | E-08、E-09 | ○ |
| C-09 | usr/share/metainfo存在時にAppStreamソース記録 | E-07（128-130行目） | ○ |
| C-10 | appstreamcli composeでメタデータ生成 | E-12 | ○ |
| C-11 | pkgar::create()でAppStreamをpkgar化 | E-13 | ○ |
| C-12 | エラーパッケージをoutdated_packagesに記録 | E-14 | ○ |
| C-13 | fetch_get_source_info()でソース識別子取得 | E-15 | ○ |
| C-14 | ソース識別失敗時は"missing_source"で記録 | E-14（207-211行目） | ○ |
| C-15 | 既存repo.tomlをマージ | E-16 | ○ |
| C-16 | *.tomlからblake3/versionを取得 | E-17（259-263行目） | ○ |
| C-17 | Repository構造体をTOMLシリアライズ | E-18 | ○ |
| C-18 | "Zero packages are passing the build"エラー | E-03（88行目） | ○ |
| C-19 | 緑色メッセージ（ANSI 155）で進捗表示 | E-07（121行目）、E-10（136行目） | ○ |
| C-20 | 赤色メッセージ（ANSI 91）で警告表示 | E-14（181-183行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張に対して十分な根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体として完全な信頼度（1.00）
- AppStream生成は外部コマンド（appstreamcli）に依存しており、コマンドの存在が前提
- id_ed25519.toml（秘密鍵）へのアクセスが必要（セキュリティ上の注意点）

## 6) レビュアーチェックリスト（最小）
- [ ] repo_builder実行後にrepo.tomlが正しく生成されることを確認
- [ ] pkgarファイルがリポジトリディレクトリにコピーされることを確認
- [ ] is_newer()により変更のないファイルがスキップされることを確認
- [ ] COOKBOOK_APPSTREAM="true"でAppStreamメタデータが生成されることを確認
- [ ] ビルド失敗パッケージがoutdated_packagesに記録されることを確認
- [ ] ホストパッケージが公開対象から除外されることを確認
