---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：11-cookbook_redoxerコマンド画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bin/cookbook_redoxer.rs` - cookbook_redoxerコマンドのメインソースコード（19行）
- E-02: `src/cook/cook_build.rs` - ビルド処理とcookbook_redoxer呼び出し箇所（708行）
- E-03: `Cargo.toml` - プロジェクト設定とredoxer依存関係定義（61行）
- E-04: `src/cook/fetch.rs` - フェッチ処理でのcookbook_redoxer使用
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | cookbook_redoxerはredoxerライブラリのラッパーである | E-01 (L17: `redoxer::main(&args)`) | ○ |
| C-02 | コマンドライン引数を収集して処理する | E-01 (L4: `env::args().collect()`) | ○ |
| C-03 | 引数が2つ以上ある場合に--セパレータを挿入 | E-01 (L6-7: `if args.len() >= 2 { args.insert(2, "--") }`) | ○ |
| C-04 | write-execサブコマンドをサポート | E-01 (L8: `if args[1] == "write-exec"`) | ○ |
| C-05 | COOKBOOK_STAGE環境変数を参照する | E-01 (L9: `std::env::var("COOKBOOK_STAGE")`) | ○ |
| C-06 | --rootと--folderオプションを引数に挿入 | E-01 (L10-12: `--folder`, `--root`の挿入) | ○ |
| C-07 | repo cookからの内部呼び出しで使用される | E-02 (L385-390: `Command::new(&cookbook_redoxer)`) | ○ |
| C-08 | Redox以外のプラットフォームで使用される | E-02 (L379-391: `is_redox()`による条件分岐) | ○ |
| C-09 | Cargo.tomlでcookbook_redoxerバイナリが定義されている | E-03 (L10-12: `[[bin]] name = "cookbook_redoxer"`) | ○ |
| C-10 | redoxerが外部依存として定義されている | E-03 (L46: `redoxer = { git = "..." }`) | ○ |
| C-11 | 画面一覧でNo.11として登録されている | E-05 (L12: `"11","CLI","cookbook_redoxerコマンド画面"`) | ○ |
| C-12 | 機能52(cookbook_redoxer)と関連付けられている | E-06 (L66: 画面No.11と機能No.52の関連) | ○ |
| C-13 | 機能51(ターゲット判定)と関連付けられている | E-06 (L67: 画面No.11と機能No.51の関連) | ○ |
| C-14 | 機能54(CMakeクロスファイル生成)と関連付けられている | E-06 (L68: 画面No.11と機能No.54の関連) | ○ |
| C-15 | 機能55(Mesonクロスファイル生成)と関連付けられている | E-06 (L69: 画面No.11と機能No.55の関連) | ○ |
| C-16 | 機能53(動的/静的リンク切替)と関連付けられている | E-06 (L70: 画面No.11と機能No.53の関連) | ○ |
| C-17 | fetch処理でもcookbook_redoxerが使用される | E-04 (L491-494: fetch.rsでのcookbook_redoxer使用) | ○ |
| C-18 | COOKBOOK_REDOXER環境変数がcook_build.rsで設定される | E-02 (L390: `command.env("COOKBOOK_REDOXER", &cookbook_redoxer)`) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に対して根拠が確認された）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 外部依存（redoxerライブラリ）の内部動作は本設計書の対象外。redoxerの詳細機能については外部ドキュメント参照が必要

## 6) レビュアーチェックリスト（最小）
- [ ] E-01のソースコードが設計書の記述と一致することを確認
- [ ] cookbook_redoxerの呼び出し箇所（E-02）が正しく記述されていることを確認
- [ ] 関連機能（機能No.51-55）の記述が画面機能マッピングと一致することを確認
