---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-ヘルプ画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bin/repo.rs` - repoコマンドのメインソースコード（1785行）
- E-02: `Cargo.toml` - プロジェクト設定とrepoバイナリ定義（61行）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング定義
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移フロー定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | REPO_HELP_STRがヘルプテキストを定義している | E-01 (L42-75: `const REPO_HELP_STR: &str = r#"...`) | ○ |
| C-02 | --helpフラグでヘルプを表示する | E-01 (L185: `args.contains(&"--help".to_string())`) | ○ |
| C-03 | -hフラグでヘルプを表示する | E-01 (L185: `args.contains(&"-h".to_string())`) | ○ |
| C-04 | 引数なしでヘルプを表示する | E-01 (L185: `args.is_empty()`) | ○ |
| C-05 | ヘルプ表示後に終了コード1で終了する | E-01 (L187: `process::exit(1)`) | ○ |
| C-06 | fetchコマンドがヘルプに記載されている | E-01 (L46: `fetch     download recipe sources`) | ○ |
| C-07 | cookコマンドがヘルプに記載されている | E-01 (L47: `cook      build recipe packages`) | ○ |
| C-08 | unfetchコマンドがヘルプに記載されている | E-01 (L48: `unfetch   delete recipe sources`) | ○ |
| C-09 | cleanコマンドがヘルプに記載されている | E-01 (L49: `clean     delete recipe artifacts`) | ○ |
| C-10 | pushコマンドがヘルプに記載されている | E-01 (L50: `push      extract package into sysroot`) | ○ |
| C-11 | findコマンドがヘルプに記載されている | E-01 (L51: `find      find path of recipe packages`) | ○ |
| C-12 | treeコマンドがヘルプに記載されている | E-01 (L52: `tree      show tree of recipe packages`) | ○ |
| C-13 | --cookbookフラグがヘルプに記載されている | E-01 (L55: `--cookbook=<cookbook_dir>`) | ○ |
| C-14 | CI環境変数がヘルプに記載されている | E-01 (L66: `CI=...set to any value to disable TUI`) | ○ |
| C-15 | 画面一覧でNo.12として登録されている | E-03 (L13: `"12","CLI","ヘルプ画面"`) | ○ |
| C-16 | 機能27(fetchコマンド)と関連付けられている | E-04 (L71: 画面No.12と機能No.27の関連) | ○ |
| C-17 | 機能28(cookコマンド)と関連付けられている | E-04 (L72: 画面No.12と機能No.28の関連) | ○ |
| C-18 | 画面遷移図にヘルプ画面が含まれている | E-05 (L11: `HELP_SCREEN[ヘルプ画面]`) | ○ |
| C-19 | Cargo.tomlでrepoバイナリが定義されている | E-02 (L14-16: `[[bin]] name = "repo"`) | ○ |
| C-20 | 不明なコマンド時にヘルプが表示される | E-01 (L128: `Err(anyhow!("Unknown command '{}'\n{}\n", s, REPO_HELP_STR))`) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に対して根拠が確認された）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ヘルプ画面は静的なテキスト表示のみであり、動的処理は最小限

## 6) レビュアーチェックリスト（最小）
- [ ] REPO_HELP_STR定数の内容が設計書の表示項目セクションと一致することを確認
- [ ] ヘルプ表示条件（--help, -h, 引数なし）がE-01の185行目と一致することを確認
- [ ] 関連機能（機能No.27-33）の記述が画面機能マッピングと一致することを確認
- [ ] 終了コードが1であることを確認（E-01の187行目）
