---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-失敗時プロンプトダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり。レビュー優先度は低い。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bin/repo.rs` 1746-1752行目（PromptOption列挙型）
- E-02: `src/bin/repo.rs` 1754-1758行目（FailurePrompt構造体）
- E-03: `src/bin/repo.rs` 1760-1767行目（FailurePrompt::new関数）
- E-04: `src/bin/repo.rs` 1769-1775行目（FailurePrompt::next関数）
- E-05: `src/bin/repo.rs` 1777-1783行目（FailurePrompt::prev関数）
- E-06: `src/bin/repo.rs` 1635-1707行目（draw_prompt関数）
- E-07: `src/bin/repo.rs` 1610-1633行目（handle_prompt_input関数）
- E-08: `src/bin/repo.rs` 932-935行目（FailFetch時のプロンプト表示）
- E-09: `src/bin/repo.rs` 971-974行目（FailCook時のプロンプト表示）
- E-10: `src/bin/repo.rs` 1079-1102行目（Cooker Thread内のprompting待機）
- E-11: `src/bin/repo.rs` 1187-1210行目（Fetcher Thread内のprompting待機）
- E-12: `src/bin/repo.rs` 1444-1449行目（draw_prompt呼び出し）
- E-13: `src/bin/repo.rs` 1457-1470行目（handle_prompt_input呼び出しとprompting更新）
- E-14: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-15: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FailurePrompt構造体でダイアログ状態を管理 | E-02 | ○ |
| C-02 | draw_prompt関数で描画 | E-06 | ○ |
| C-03 | PromptOptionでRetry=2, Skip=3, Exit=4 | E-01 | ○ |
| C-04 | デフォルト選択肢はExit | E-03（1765行目） | ○ |
| C-05 | Left/BackTabでprev() | E-07（1621行目） | ○ |
| C-06 | Right/Tabでnext() | E-07（1622行目） | ○ |
| C-07 | EnterでpromptをtakeしてSome返却 | E-07（1623-1626行目） | ○ |
| C-08 | q/Ctrl+C/EscでExit確定 | E-07（1617-1619行目） | ○ |
| C-09 | next()でRetry→Skip→Exit→Retry循環 | E-04 | ○ |
| C-10 | prev()でRetry→Exit→Skip→Retry循環 | E-05 | ○ |
| C-11 | FailFetch時にプロンプト表示 | E-08 | ○ |
| C-12 | FailCook時にプロンプト表示 | E-09 | ○ |
| C-13 | ノンストップモード時Retryが非表示 | E-06（1673-1676行目） | ○ |
| C-14 | ノンストップモード時タイトルに"(skipped)"追加 | E-06（1638-1639行目） | ○ |
| C-15 | エラーメッセージ200文字超で切り詰め | E-06（1641-1648行目） | ○ |
| C-16 | ダイアログ幅は画面幅の半分 | E-06（1700行目） | ○ |
| C-17 | ダイアログ高さは10行固定 | E-06（1701行目） | ○ |
| C-18 | Clear widgetで背景をクリア | E-06（1705行目） | ○ |
| C-19 | prompting値2でCooker ThreadがRetry | E-10（1087-1090行目） | ○ |
| C-20 | prompting値3でSkip＆handle_nonstop_fail | E-10（1091-1095行目） | ○ |
| C-21 | prompting値4でスレッド終了 | E-10（1096-1099行目） | ○ |
| C-22 | 関連機能No.35,38 | E-15 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張に対して十分な根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体として完全な信頼度（1.00）
- 実装がシンプルで、すべてのロジックがrepo.rs内で完結している

## 6) レビュアーチェックリスト（最小）
- [ ] ビルド失敗時にダイアログが正しく表示されることを確認
- [ ] Left/Rightキーで選択肢が循環することを確認
- [ ] Retry選択時に同じレシピが再実行されることを確認
- [ ] Skip選択時に次のレシピに進むことを確認
- [ ] Exit選択時にTUIが終了することを確認
- [ ] COOKBOOK_NONSTOP=true時にRetryボタンが非表示であることを確認
