---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 30
  claims_with_evidence: 29
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：3-repo fetchコマンド画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：29 / 30、根拠なし：1
- 優先レビュー（高）
  1. **COOKBOOK_OFFLINE環境変数がfetchでは無視される**：実装の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bin/repo.rs` 42-75行目（REPO_HELP_STR定数）
- E-02: `src/bin/repo.rs` 182-249行目（main_inner関数）
- E-03: `src/bin/repo.rs` 286-355行目（repo_inner関数）
- E-04: `src/bin/repo.rs` 553-566行目（handle_fetch関数）
- E-05: `src/cook/fetch.rs` 117-406行目（fetch関数）
- E-06: `src/cook/fetch.rs` 37-115行目（fetch_offline関数）
- E-07: `src/cook/fetch.rs` 161-317行目（Gitソース取得処理）
- E-08: `src/cook/fetch.rs` 318-380行目（Tarソース取得処理）
- E-09: `src/cook/fetch.rs` 141-159行目（Pathソース取得処理）
- E-10: `src/cook/fetch.rs` 134-140行目（SameAsソース取得処理）
- E-11: `src/cook/fetch.rs` 408-429行目（fetch_make_symlink関数）
- E-12: `src/cook/fetch.rs` 454-476行目（fetch_extract_tar関数）
- E-13: `src/cook/fetch.rs` 478-501行目（fetch_cargo関数）
- E-14: `src/cook/fetch.rs` 517-580行目（fetch_remote関数）
- E-15: `src/cook/fetch.rs` 606-646行目（fetch_apply_patches関数）
- E-16: `src/cook/fetch.rs` 648-670行目（fetch_apply_source_info関数）
- E-17: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-18: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | repo fetchコマンドでソースコードをダウンロード | E-01, E-02, E-03 | ○ |
| C-02 | Gitソース：git clone --recursive | E-07（178-192行目） | ○ |
| C-03 | Gitソース：shallow_cloneでfilter=tree:0 | E-07（187-190行目） | ○ |
| C-04 | Gitソース：git fetch origin | E-07（213-216行目） | ○ |
| C-05 | Gitソース：revでgit checkout | E-07（259-264行目） | ○ |
| C-06 | Gitソース：パッチ前にgit reset --hard | E-07（285-290行目） | ○ |
| C-07 | Gitソース：submodule sync/update | E-07（292-310行目） | ○ |
| C-08 | Tarソース：wgetでダウンロード | E-08（329行目、download_wget呼び出し） | ○ |
| C-09 | Tarソース：blake3検証 | E-08（331-358行目） | ○ |
| C-10 | Tarソース：tar --strip-components=1で展開 | E-12（473行目） | ○ |
| C-11 | Pathソース：copy_dir_all | E-09（150-157行目） | ○ |
| C-12 | SameAsソース：再帰的にfetch | E-10（136-137行目） | ○ |
| C-13 | SameAsソース：シンボリックリンク作成 | E-11 | ○ |
| C-14 | パッチ適用：patch --strip=1 | E-15（631-634行目） | ○ |
| C-15 | スクリプト実行：bash -ex | E-15（637-644行目） | ○ |
| C-16 | Cargoプロジェクト：cargo fetch | E-13 | ○ |
| C-17 | リモートパッケージ：pkgar/tomlダウンロード | E-14（545-550行目） | ○ |
| C-18 | 成功メッセージ：緑色（ANSIカラー46） | E-02（263-273行目、print_success関数参照） | ○ |
| C-19 | 失敗メッセージ：赤色（ANSIカラー196） | E-02（251-261行目、print_failed関数参照） | ○ |
| C-20 | source_info.tomlにソース識別子保存 | E-16 | ○ |
| C-21 | blake3不一致時のエラーメッセージ | E-08（334-337行目） | ○ |
| C-22 | blake3未設定時の警告メッセージ | E-08（351-356行目） | ○ |
| C-23 | SameAsの無限ループ検出（深度50） | E-10（437-446行目、fetch_resolve_canon参照） | ○ |
| C-24 | BuildKind::None時は空のソース識別子で早期リターン | E-05（121-125行目） | ○ |
| C-25 | BuildKind::Remote時はfetch_remote呼び出し | E-05（126-129行目） | ○ |
| C-26 | COOKBOOK_OFFLINEがfetchでは無視される | **部分的根拠** | △ |
| C-27 | nonstopモードで失敗時も継続 | E-03（221-232行目） | ○ |
| C-28 | --with-package-depsで依存関係も取得 | E-02（491-494行目、parse_args内） | ○ |
| C-29 | 関連機能No.27,2,3,4,5,6,7,8,37,1 | E-18 | ○ |
| C-30 | source.tmpを一時ディレクトリとして使用 | E-07（174-175行目）、E-08（371-372行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- C-26について：COOKBOOK_OFFLINEが「fetchでは無視される」という記述の根拠
  - 候補：REPO_HELP_STR（E-01）の68-69行目には「ignored when command "fetch" is used」と記載あり
  - 実装確認：handle_fetch関数（E-04）の559-563行目で`config.cook.offline && allow_offline`となっており、fetchコマンド時はallow_offline=falseが渡される可能性を確認する必要あり
  - 推測：ヘルプ文字列の記載と実装の整合性を確認することで信頼度を向上可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体として高い信頼度（0.97）
- 1: 中リスク - C-26（COOKBOOK_OFFLINE無視）は動作確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] Gitソースのclone/fetch動作を確認（新規ディレクトリ/既存ディレクトリ）
- [ ] Tarソースのblake3検証動作を確認（正常/不一致）
- [ ] SameAsソースのシンボリックリンク作成を確認
- [ ] パッチ適用が正しく動作することを確認
- [ ] COOKBOOK_OFFLINE=true時にfetchコマンドがネットワークアクセスを試みることを確認
- [ ] --with-package-deps指定時に依存パッケージも取得されることを確認
