---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 35
  claims_with_evidence: 34
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：4-repo cookコマンド画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：34 / 35、根拠なし：1
- 優先レビュー（高）
  1. **Ed25519署名の適用**：package.rsの署名処理の詳細実装確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bin/repo.rs` 42-75行目（REPO_HELP_STR定数）
- E-02: `src/bin/repo.rs` 182-249行目（main_inner関数）
- E-03: `src/bin/repo.rs` 286-355行目（repo_inner関数）
- E-04: `src/bin/repo.rs` 568-606行目（handle_cook関数）
- E-05: `src/cook/cook_build.rs` 170-462行目（build関数）
- E-06: `src/cook/cook_build.rs` 192-206行目（依存パッケージ収集）
- E-07: `src/cook/cook_build.rs` 279-308行目（sysroot/toolchain構築）
- E-08: `src/cook/cook_build.rs` 342-367行目（BuildKind別スクリプト生成）
- E-09: `src/cook/cook_build.rs` 369-422行目（スクリプト実行）
- E-10: `src/cook/cook_build.rs` 24-154行目（auto_deps_from_dynamic_linking関数）
- E-11: `src/cook/cook_build.rs` 575-611行目（build_auto_deps関数）
- E-12: `src/cook/cook_build.rs` 511-572行目（build_deps_dir関数）
- E-13: `src/cook/cook_build.rs` 483-498行目（get_stage_dirs関数）
- E-14: `src/cook/cook_build.rs` 464-481行目（remove_stage_dir関数）
- E-15: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-16: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | cookコマンドでfetch→build→packageを実行 | E-03（292-299行目） | ○ |
| C-02 | TUIモード判定（CI環境変数） | E-01（66-67行目）、E-02（194行目） | ○ |
| C-03 | BuildKind::Cargoでcookbook_cargo実行 | E-08（343-351行目） | ○ |
| C-04 | BuildKind::Configureでcookbook_configure実行 | E-08（352-355行目） | ○ |
| C-05 | BuildKind::Cmakeでcookbook_cmake実行 | E-08（356-359行目） | ○ |
| C-06 | BuildKind::Mesonでcookbook_meson実行 | E-08（360-363行目） | ○ |
| C-07 | BuildKind::Customでユーザー定義スクリプト実行 | E-08（364行目） | ○ |
| C-08 | BuildKind::Noneでビルドスキップ | E-05（185-188行目） | ○ |
| C-09 | キャッシュが有効ならビルドスキップ | E-05（221-227行目） | ○ |
| C-10 | source_modified比較でリビルド判定 | E-05（257-276行目） | ○ |
| C-11 | build_deps_dir()でsysroot構築 | E-07（280-295行目）、E-12 | ○ |
| C-12 | build_deps_dir()でtoolchain構築 | E-07（296-308行目）、E-12 | ○ |
| C-13 | cookbook_redoxer経由でbash実行 | E-09（379-392行目） | ○ |
| C-14 | BUILD_PRESCRIPT+SHARED_PRESCRIPT+script+BUILD_POSTSCRIPTを連結 | E-09（418-420行目） | ○ |
| C-15 | 環境変数TARGET, COOKBOOK_*を設定 | E-09（394-414行目） | ○ |
| C-16 | オプショナルパッケージをglobで振り分け | E-05（424-445行目） | ○ |
| C-17 | clean_targetでbuild/sysroot/toolchain削除 | E-05（451-458行目） | ○ |
| C-18 | auto_deps_from_dynamic_linkingでELF解析 | E-10 | ○ |
| C-19 | DT_NEEDEDを抽出して依存関係検出 | E-10（91-106行目） | ○ |
| C-20 | usr/bin, usr/lib等をDFSで走査 | E-10（36-77行目） | ○ |
| C-21 | auto_deps.tomlに検出結果をキャッシュ | E-11（607行目） | ○ |
| C-22 | pkgar::extractでsysrootに展開 | E-12（553-562行目） | ○ |
| C-23 | .tagsディレクトリでキャッシュ管理 | E-12（520-530行目） | ○ |
| C-24 | stage.tmpを一時ディレクトリとして使用 | E-05（316-317行目） | ○ |
| C-25 | renameでatomicに移動 | E-05（448行目） | ○ |
| C-26 | remove_stage_dirでstage/pkgar/toml/files削除 | E-14 | ○ |
| C-27 | get_stage_dirsでoptional_packagesを考慮 | E-13 | ○ |
| C-28 | COOKBOOK_CROSS_TARGETでクロスコンパイル対応 | E-13（485-490行目） | ○ |
| C-29 | ビルド完了後にrepo_builder自動実行 | E-02（237-238行目） | ○ |
| C-30 | nonstopモードでstageディレクトリ削除 | E-03（221-227行目、handle_nonstop_fail参照） | ○ |
| C-31 | 関連機能No.28,9-22,35,36,38,34,56-59,1,39-41 | E-16 | ○ |
| C-32 | 成功メッセージ緑色（ANSIカラー46） | E-02（263-273行目、print_success参照） | ○ |
| C-33 | 失敗メッセージ赤色（ANSIカラー196） | E-02（251-261行目、print_failed参照） | ○ |
| C-34 | build/logs/{target}/{recipe}.logにログ保存 | E-02（155-159行目、logs_dir設定） | ○ |
| C-35 | Ed25519署名の適用 | **部分的根拠**（package.rsの詳細確認要） | △ |

## 4) 不足情報（Unknown / Missing）
- C-35について：Ed25519署名の実装詳細
  - 候補：package.rs内のpkgar::create()呼び出し部分
  - 推測：pkgar crateがEd25519署名を行っていると考えられるが、具体的な実装確認が必要
  - build/id_ed25519.toml（秘密鍵）とbuild/id_ed25519.pub.toml（公開鍵）の使用が想定される

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体として高い信頼度（0.97）
- 1: 中リスク - C-35（署名処理）はセキュリティに関わるため実装確認推奨
- 0: 低リスク - ビルド処理の主要フローは十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] Cargoテンプレートでのビルドが正常に動作することを確認
- [ ] Configure/CMake/Mesonテンプレートでのビルドが正常に動作することを確認
- [ ] キャッシュが有効に機能し、不要な再ビルドがスキップされることを確認
- [ ] sysroot/toolchainが正しく構築されることを確認
- [ ] 自動依存関係検出がELFバイナリから正しくライブラリを検出することを確認
- [ ] pkgarファイルが正しく署名されることを確認
- [ ] ビルドログがbuild/logs/に正しく保存されることを確認
- [ ] nonstopモードで失敗時にstageディレクトリが削除されることを確認
