---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-repo cleanコマンド画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり。レビュー優先度は低い。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bin/repo.rs` 42-75行目（REPO_HELP_STR定数）
- E-02: `src/bin/repo.rs` 286-355行目（repo_inner関数）
- E-03: `src/bin/repo.rs` 619-634行目（handle_clean関数）
- E-04: `src/bin/repo.rs` 449-450行目（--allフラグとcleaning判定）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | cleanコマンドでtargetディレクトリを削除 | E-02（350行目）、E-03（625-628行目） | ○ |
| C-02 | cleanコマンドでsourceディレクトリは保持 | E-02（350行目、source=false） | ○ |
| C-03 | handle_cleanにsource=false, target=trueで呼び出し | E-02（350行目） | ○ |
| C-04 | fs::remove_dir_allで再帰削除 | E-03（627行目） | ○ |
| C-05 | ディレクトリが存在しない場合は何もしない | E-03（626行目のif exists判定） | ○ |
| C-06 | --allフラグでcleaningコマンドのみ使用可能 | E-04 | ○ |
| C-07 | 成功メッセージ緑色（ANSIカラー46） | E-02（263-273行目、print_success参照） | ○ |
| C-08 | 失敗メッセージ赤色（ANSIカラー196） | E-02（251-261行目、print_failed参照） | ○ |
| C-09 | 複数レシピ完了時にサマリー表示 | E-02（241-247行目） | ○ |
| C-10 | 削除失敗時にエラーメッセージ | E-03（627-628行目のcontext） | ○ |
| C-11 | 関連機能No.30,1 | E-06 | ○ |
| C-12 | ヘルプ文字列にcleanの説明あり | E-01（49行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張に対して十分な根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体として完全な信頼度（1.00）
- 実装がシンプルで、handle_clean関数内で完結している

## 6) レビュアーチェックリスト（最小）
- [ ] clean実行後にtarget/ディレクトリが削除されることを確認
- [ ] clean実行後にsource/ディレクトリが保持されることを確認
- [ ] --allフラグで全レシピのビルド成果物が削除されることを確認
- [ ] clean後の再ビルドが正常に動作することを確認
