---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-repo pushコマンド画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり。レビュー優先度は低い。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bin/repo.rs` 42-75行目（REPO_HELP_STR定数）
- E-02: `src/bin/repo.rs` 182-249行目（main_inner関数）
- E-03: `src/bin/repo.rs` 637-733行目（handle_push関数）
- E-04: `src/bin/repo.rs` 636行目（PUSH_SYSROOT_DIR静的変数）
- E-05: `src/cook/tree.rs` 38-107行目（walk_tree_entry関数）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | pushコマンドでpkgarをsysrootに展開 | E-02（208-209行目）、E-03 | ○ |
| C-02 | build/id_ed25519.pub.tomlで署名検証 | E-03（650行目） | ○ |
| C-03 | pkgar::extract()で展開 | E-03（653-658行目） | ○ |
| C-04 | --with-package-depsで依存関係も展開 | E-03（683-694行目） | ○ |
| C-05 | walk_tree_entry()で依存関係ツリー走査 | E-05 | ○ |
| C-06 | visitedセットで重複排除 | E-05（58行目、67-71行目） | ○ |
| C-07 | total_sizeにサイズ加算 | E-05（72-74行目）、E-03（708行目） | ○ |
| C-08 | sysrootデフォルトはRedoxで"/"、他は$PWD/sysroot | E-01（57-58行目） | ○ |
| C-09 | PUSH_SYSROOT_DIRをOnceLockで保持 | E-04 | ○ |
| C-10 | verbose時のみサマリー表示 | E-03（718-730行目） | ○ |
| C-11 | "Package has not been built"エラー | E-03（660-663行目） | ○ |
| C-12 | "failed to install"エラー | E-03（654-658行目） | ○ |
| C-13 | nonstopモードでエラー継続 | E-03（675-678行目） | ○ |
| C-14 | 成功メッセージ緑色（ANSIカラー46） | E-02（263-273行目、print_success参照） | ○ |
| C-15 | 失敗メッセージ赤色（ANSIカラー196） | E-02（251-261行目、print_failed参照） | ○ |
| C-16 | "Pushed {size} of {N} packages"サマリー | E-03（721-729行目） | ○ |
| C-17 | 関連機能No.31,14,1 | E-07 | ○ |
| C-18 | ヘルプ文字列にpushの説明あり | E-01（50行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張に対して十分な根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体として完全な信頼度（1.00）
- 署名検証はpkgar crateに依存しており、セキュリティは外部ライブラリの信頼性に依存

## 6) レビュアーチェックリスト（最小）
- [ ] push実行後にパッケージファイルがsysrootに展開されることを確認
- [ ] --with-package-deps指定時に依存パッケージも展開されることを確認
- [ ] 署名検証が正しく動作することを確認（無効な署名で失敗すること）
- [ ] 未ビルドパッケージに対して適切なエラーが表示されることを確認
- [ ] サマリーの合計サイズが正しいことを確認
