---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-repo treeコマンド画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり。レビュー優先度は低い。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bin/repo.rs` 42-75行目（REPO_HELP_STR定数）
- E-02: `src/bin/repo.rs` 182-249行目（main_inner関数）
- E-03: `src/bin/repo.rs` 735-766行目（handle_tree関数）
- E-04: `src/cook/tree.rs` 19-36行目（display_tree_entry関数）
- E-05: `src/cook/tree.rs` 38-107行目（walk_tree_entry関数）
- E-06: `src/cook/tree.rs` 109-124行目（display_pkg_fn関数）
- E-07: `src/cook/tree.rs` 166-174行目（format_size関数）
- E-08: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | treeコマンドで依存関係ツリーを表示 | E-02（205-206行目）、E-03 | ○ |
| C-02 | display_tree_entry()で再帰的に表示 | E-04、E-05 | ○ |
| C-03 | ├── / └──でツリー接続線を表示 | E-06（121行目） | ○ |
| C-04 | [X.XX MiB]形式でサイズ表示 | E-06（116行目）、E-07 | ○ |
| C-05 | "(not built)"で未ビルドを表示 | E-06（117行目） | ○ |
| C-06 | 重複パッケージはサイズなし表示 | E-06（118行目） | ○ |
| C-07 | "(dependency info missing)"で欠落表示 | E-06（119行目） | ○ |
| C-08 | visitedセットで重複排除 | E-05（58行目、67-71行目） | ○ |
| C-09 | total_sizeにサイズ加算 | E-05（72-74行目） | ○ |
| C-10 | stage.tomlまたはrecipe.tomlから依存関係取得 | E-05（77-86行目） | ○ |
| C-11 | format_sizeでB/KiB/MiB/GiB/TiB変換 | E-07 | ○ |
| C-12 | "Estimated image size"サマリー表示 | E-03（753-763行目） | ○ |
| C-13 | informationalコマンドでverbose無効化 | E-02（545-548行目） | ○ |
| C-14 | is_deps=falseをルートとして抽出 | E-03（740行目） | ○ |
| C-15 | 関連機能No.32,48,49,14 | E-09 | ○ |
| C-16 | ヘルプ文字列にtreeの説明あり | E-01（52行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張に対して十分な根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体として完全な信頼度（1.00）
- 読み取り専用コマンドのためデータ破損のリスクなし

## 6) レビュアーチェックリスト（最小）
- [ ] ツリー表示が正しいフォーマットで出力されることを確認
- [ ] 各パッケージのサイズが正しく表示されることを確認
- [ ] 重複パッケージが2回目以降サイズなしで表示されることを確認
- [ ] 未ビルドパッケージに"(not built)"が表示されることを確認
- [ ] サマリーの合計サイズが正しいことを確認
