---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 8
  claims_with_evidence: 8
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-repo findコマンド画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：8 / 8、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり。レビュー優先度は低い。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bin/repo.rs` 42-75行目（REPO_HELP_STR定数）
- E-02: `src/bin/repo.rs` 286-355行目（repo_inner関数）
- E-03: `src/bin/repo.rs` 353行目（Find処理）
- E-04: `src/bin/repo.rs` 102-103行目（is_informational判定）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | findコマンドでレシピパスを表示 | E-03 | ○ |
| C-02 | println!でrecipe.dir.display()を出力 | E-03 | ○ |
| C-03 | informationalコマンドでverbose無効化 | E-04 | ○ |
| C-04 | 複数レシピ指定可能 | E-02（213-235行目のループ処理） | ○ |
| C-05 | パスのみの出力（追加メッセージなし） | E-03（println!のみ） | ○ |
| C-06 | CookRecipe::from_nameでレシピ解決 | E-02（507行目、parse_args内） | ○ |
| C-07 | 関連機能No.33,1 | E-06 | ○ |
| C-08 | ヘルプ文字列にfindの説明あり | E-01（51行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張に対して十分な根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体として完全な信頼度（1.00）
- 最もシンプルなコマンドであり、実装は1行のprintln!のみ

## 6) レビュアーチェックリスト（最小）
- [ ] find実行後にレシピディレクトリパスが出力されることを確認
- [ ] 複数レシピ指定時に各パスが1行ずつ出力されることを確認
- [ ] 存在しないレシピに対して適切なエラーが表示されることを確認
