---
generated_at: 2026-01-23 00:35:00
metrics:
  claims_total: 70
  claims_with_evidence: 65
  claims_without_evidence: 5
confidence_derived: 0.93
---

# 根拠レポート：結合テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：65 / 70、根拠なし：5
- 優先レビュー（高）
  1. **IT-042 AppStreamメタデータ生成**：appstreamcliコマンドの実行環境依存
  2. **IT-064 TUIモードでのcook実行**：TUI機能の詳細動作確認が必要
  3. **IT-065 TUIでのビルド失敗プロンプト**：ユーザーインタラクション部分の検証が必要
  4. **IT-066 TUIでのログ表示切替**：キー入力処理の詳細確認が必要
  5. **IT-061 Blake3ハッシュ計算**：blake3モジュールの詳細実装確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/recipe.rs` - Recipe構造体とパース処理、テストケース（git_cargo_recipe、tar_custom_recipe、meta_recipe）
- E-02: `src/config.rs` - CookbookConfig、translate_mirror関数、テストケース（test_exact_match、test_prefix_match等）
- E-03: `src/cook/fetch.rs` - fetch、fetch_offline、fetch_remote、fetch_apply_patches関数
- E-04: `src/cook/cook_build.rs` - build、build_deps_dir、auto_deps_from_dynamic_linking関数、file_system_loop_no_infinite_loopテスト
- E-05: `src/cook/package.rs` - package、package_toml、package_stage_paths関数
- E-06: `src/bin/repo.rs` - CLIコマンド処理、handle_fetch、handle_cook、handle_clean、handle_push、handle_tree関数
- E-07: `src/bin/repo_builder.rs` - publish_packages、repo.toml生成処理
- E-08: `src/cook/tree.rs` - display_tree_entry、walk_tree_entry、walk_file_tree関数
- E-09: `src/cook/fs.rs` - ファイルシステム操作関数群（copy_dir_all、modified_dir、download_wget、get_git_*関数）
- E-10: `src/cook/script.rs` - SHARED_PRESCRIPT、BUILD_PRESCRIPT、BUILD_POSTSCRIPT定数
- E-11: `src/lib.rs` - モジュール構成、WALK_DEPTH、REMOTE_PKG_SOURCE定数
- E-12: `src/blake3.rs` - Blake3ハッシュ計算機能
- E-13: `src/cook/ident.rs` - ビルド識別子管理（init_ident、get_ident）
- E-14: `Cargo.toml` - 依存関係定義（pkgar、redox-pkg、redox_installer等）
- E-15: `README.md` - プロジェクト概要

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IT-001 レシピファイル解析 | E-01 | ○ |
| C-02 | IT-002 Tarソース形式解析 | E-01 | ○ |
| C-03 | IT-003 メタパッケージ解析 | E-01 | ○ |
| C-04 | IT-004 ミラーURL完全一致変換 | E-02 | ○ |
| C-05 | IT-005 ミラーURLプレフィックス変換 | E-02 | ○ |
| C-06 | IT-006 最長プレフィックス一致優先 | E-02 | ○ |
| C-07 | IT-007 ミラー設定なしURL変換 | E-02 | ○ |
| C-08 | IT-008 Cookオフライン設定解析 | E-02 | ○ |
| C-09 | IT-009 Gitリポジトリクローン | E-03 | ○ |
| C-10 | IT-010 Tarアーカイブ展開 | E-03 | ○ |
| C-11 | IT-011 Blake3ハッシュ検証 | E-03, E-12 | ○ |
| C-12 | IT-012 同一ソース参照シンボリックリンク | E-03 | ○ |
| C-13 | IT-013 リモートパッケージダウンロード | E-03 | ○ |
| C-14 | IT-014 オフラインモードGitソース取得失敗 | E-03 | ○ |
| C-15 | IT-015 パッチファイル適用 | E-03 | ○ |
| C-16 | IT-016 Cargoテンプレートビルド | E-04, E-10 | ○ |
| C-17 | IT-017 Configureテンプレートビルド | E-04, E-10 | ○ |
| C-18 | IT-018 CMakeテンプレートビルド | E-04, E-10 | ○ |
| C-19 | IT-019 Mesonテンプレートビルド | E-04, E-10 | ○ |
| C-20 | IT-020 カスタムスクリプトビルド | E-04 | ○ |
| C-21 | IT-021 ビルド依存関係解決 | E-01 | ○ |
| C-22 | IT-022 開発依存関係解決 | E-01 | ○ |
| C-23 | IT-023 Sysrootディレクトリ構築 | E-04 | ○ |
| C-24 | IT-024 Toolchainディレクトリ構築 | E-04 | ○ |
| C-25 | IT-025 動的リンク依存自動検出 | E-04 | ○ |
| C-26 | IT-026 ファイルシステムループ検出 | E-04 | ○ |
| C-27 | IT-027 Pkgarアーカイブ生成 | E-05 | ○ |
| C-28 | IT-028 パッケージメタデータTOML生成 | E-05 | ○ |
| C-29 | IT-029 pkgar署名キー生成 | E-05 | ○ |
| C-30 | IT-030 オプショナルパッケージ分離 | E-05 | ○ |
| C-31 | IT-031 repoコマンドfetch実行 | E-06 | ○ |
| C-32 | IT-032 repoコマンドcook実行 | E-06 | ○ |
| C-33 | IT-033 repoコマンドclean実行 | E-06 | ○ |
| C-34 | IT-034 repoコマンドunfetch実行 | E-06 | ○ |
| C-35 | IT-035 repoコマンドpush実行 | E-06 | ○ |
| C-36 | IT-036 repoコマンドtree表示 | E-06, E-08 | ○ |
| C-37 | IT-037 repoコマンドfind実行 | E-06 | ○ |
| C-38 | IT-038 filesystemオプション設定上書き | E-06 | ○ |
| C-39 | IT-039 repo-binaryオプション | E-06 | ○ |
| C-40 | IT-040 パッケージリポジトリ公開 | E-07 | ○ |
| C-41 | IT-041 repo.toml生成更新 | E-07 | ○ |
| C-42 | IT-042 AppStreamメタデータ生成 | E-07 | △ |
| C-43 | IT-043 古いパッケージ記録 | E-07 | ○ |
| C-44 | IT-044 依存関係ツリー表示 | E-08 | ○ |
| C-45 | IT-045 依存関係ツリー走査 | E-08 | ○ |
| C-46 | IT-046 重複依存除外 | E-08 | ○ |
| C-47 | IT-047 ディレクトリ再帰コピー | E-09 | ○ |
| C-48 | IT-048 条件付きファイル移動 | E-09 | ○ |
| C-49 | IT-049 ディレクトリ更新時刻取得 | E-09 | ○ |
| C-50 | IT-050 .git除外更新時刻取得 | E-09 | ○ |
| C-51 | IT-051 wgetファイルダウンロード | E-09 | ○ |
| C-52 | IT-052 Git HEADリビジョン取得 | E-09 | ○ |
| C-53 | IT-053 Gitリモートトラッキング情報取得 | E-09 | ○ |
| C-54 | IT-054 Git FETCH_HEADリビジョン取得 | E-09 | ○ |
| C-55 | IT-055 動的ビルド初期化スクリプト | E-10 | ○ |
| C-56 | IT-056 cookbook_cargo関数実行 | E-10 | ○ |
| C-57 | IT-057 cookbook_configure関数実行 | E-10 | ○ |
| C-58 | IT-058 cookbook_cmake関数実行 | E-10 | ○ |
| C-59 | IT-059 cookbook_meson関数実行 | E-10 | ○ |
| C-60 | IT-060 ビルド後処理スクリプト | E-10 | ○ |
| C-61 | IT-061 Blake3ハッシュ計算 | E-12 | △ |
| C-62 | IT-062 ビルド識別子初期化 | E-13 | ○ |
| C-63 | IT-063 ビルド識別子取得 | E-13 | ○ |
| C-64 | IT-064 TUIモードcook実行 | E-06 | △ |
| C-65 | IT-065 TUIビルド失敗プロンプト | E-06 | △ |
| C-66 | IT-066 TUIログ表示切替 | E-06 | △ |
| C-67 | IT-067 ホストパッケージ依存処理 | E-01 | ○ |
| C-68 | IT-068 ファイルシステム設定適用 | E-01 | ○ |
| C-69 | IT-069 パッケージ依存再帰取得 | E-01 | ○ |
| C-70 | IT-070 依存パッケージフラグ設定 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- **IT-042 AppStreamメタデータ生成**：appstreamcliコマンドの実装詳細がプロジェクト外部にあり、環境依存性が高い
  - 候補：appstreamcli公式ドキュメント / システム環境設定 / CI設定
- **IT-061 Blake3ハッシュ計算**：src/blake3.rsの詳細実装を直接確認できていない
  - 候補：blake3クレートドキュメント / src/blake3.rs詳細確認
- **IT-064/065/066 TUI機能**：TUIのインタラクティブな動作はコードから推測。実際の動作確認が必要
  - 候補：手動テスト / スクリーンショット / ユーザーガイド

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - IT-036, IT-037, IT-044, IT-066：情報表示系機能で影響が限定的
- **1: 中リスク** - IT-003, IT-007, IT-008, IT-012, IT-014, IT-018-020, IT-022, IT-024, IT-030, IT-033-034, IT-039, IT-043, IT-045-050, IT-052-054, IT-058-060, IT-062-063, IT-067, IT-070：エラー時の影響が一部機能に限定
- **2: 高リスク** - IT-001, IT-002, IT-004-006, IT-009-011, IT-013, IT-015-017, IT-021, IT-023, IT-025-029, IT-031-032, IT-035, IT-038, IT-040-042, IT-051, IT-055-057, IT-061, IT-068-069：ビルドシステムの中核機能に関わる

## 6) レビュアーチェックリスト（最小）
- [ ] IT-001-003: recipe.tomlの各形式（Git/Tar/メタパッケージ）が正しく解析されることを確認
- [ ] IT-004-008: cookbook.tomlのミラー設定とcook設定が正しく読み込まれることを確認
- [ ] IT-009-015: fetch機能（Git clone、Tar展開、パッチ適用、リモートダウンロード）が正常動作することを確認
- [ ] IT-016-026: build機能（各テンプレート、依存解決、sysroot構築、auto_deps）が正常動作することを確認
- [ ] IT-027-030: package機能（pkgar生成、TOML生成、キー生成）が正常動作することを確認
- [ ] IT-031-043: CLIコマンド（repo、repo_builder）が正しく動作することを確認
- [ ] IT-044-054: ユーティリティ機能（tree、fs操作、Git操作）が正常動作することを確認
- [ ] IT-055-063: スクリプトとビルド識別子機能が正常動作することを確認
- [ ] IT-064-066: TUI機能が正常動作することを確認（手動テスト推奨）
- [ ] IT-067-070: Recipe関連の追加機能が正常動作することを確認
