# 通知設計書 1-libnotify

## 概要

本ドキュメントは、Redox OS向けに移植されるGNOMEデスクトップ通知ライブラリ「libnotify」の設計仕様を記述する。libnotifyはデスクトップ環境においてユーザーに視覚的な通知を表示するためのAPIを提供するライブラリである。

### 本通知の処理概要

libnotifyは、GNOMEデスクトップ環境におけるデスクトップ通知を実現するためのクライアントライブラリである。freedesktop.orgのDesktop Notifications Specificationに準拠し、アプリケーションがシステムの通知デーモンと通信するための統一的なインターフェースを提供する。

**業務上の目的・背景**：デスクトップアプリケーションがユーザーに非同期的なイベント（メール受信、ダウンロード完了、システムアラートなど）を通知する必要がある場合に、統一されたAPIを通じて通知を表示することで、ユーザーエクスペリエンスの一貫性を確保する。複数のアプリケーションが独自の通知メカニズムを実装する必要がなくなり、開発効率が向上する。

**通知の送信タイミング**：アプリケーションがnotify_notification_show()関数を呼び出した時点で通知が送信される。具体的には、新着メール、ファイル転送完了、バッテリー低下警告、カレンダーリマインダーなど、ユーザーの注意を引く必要があるイベント発生時に使用される。

**通知の受信者**：デスクトップセッションにログインしているユーザー。通知はD-Busを経由してnotification-daemon（またはorg.freedesktop.Notificationsサービスを実装する互換デーモン）に送信され、ユーザーの画面上にポップアップ表示される。

**通知内容の概要**：通知はサマリー（タイトル）、ボディ（詳細テキスト）、アイコン、緊急度（low/normal/critical）、オプションのアクションボタンで構成される。アプリケーションはgdk-pixbufを使用してカスタムアイコンを設定することも可能。

**期待されるアクション**：ユーザーは通知を確認し、必要に応じてアクションボタンをクリックして関連アプリケーションを開く、または通知を閉じる。critical緊急度の通知は手動で閉じるまで表示が継続される。

## 通知種別

デスクトップ通知（D-Bus経由）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（D-Bus経由） |
| 優先度 | 設定可能（low/normal/critical） |
| リトライ | D-Busレベルでの自動リトライ |

### 送信先決定ロジック

org.freedesktop.Notificationsサービスを実装する通知デーモンに対してD-Busメッセージを送信。通知デーモンがユーザーセッション内で稼働していることが前提となる。

## 通知テンプレート

### デスクトップ通知の場合

| 項目 | 内容 |
|-----|------|
| サマリー | アプリケーション指定のタイトル文字列 |
| ボディ | アプリケーション指定の詳細テキスト（HTML風のマークアップ対応） |
| アイコン | アプリケーションアイコンまたはカスタムgdk-pixbufイメージ |
| 緊急度 | NOTIFY_URGENCY_LOW / NOTIFY_URGENCY_NORMAL / NOTIFY_URGENCY_CRITICAL |

### 本文テンプレート

```
サマリー: {summary}
ボディ: {body}
アイコン: {icon}
アクション: {action_label} → {action_callback}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | - | - | デスクトップ通知にファイル添付機能はない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| summary | 通知タイトル | アプリケーション指定 | Yes |
| body | 通知本文 | アプリケーション指定 | No |
| icon | アイコン名またはパス | アプリケーション指定 | No |
| timeout | 表示時間（ミリ秒） | アプリケーション指定（デフォルト: デーモン依存） | No |
| urgency | 緊急度 | アプリケーション指定（デフォルト: NORMAL） | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | notify_notification_show() | 通知オブジェクトが有効であること | アプリケーションからの明示的な通知送信要求 |
| API呼び出し | notify_notification_update() + show() | 既存通知の更新 | 進行状況表示などで同一通知を更新する場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| D-Busセッション未接続 | セッションバスに接続できない場合は送信失敗 |
| 通知デーモン未稼働 | org.freedesktop.Notificationsサービスが利用不可の場合 |
| ライブラリ未初期化 | notify_init()が呼ばれていない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[アプリケーションがnotify_notification_new呼び出し] --> B[通知オブジェクト作成]
    B --> C[notify_notification_show呼び出し]
    C --> D{D-Busセッション確認}
    D -->|接続OK| E[org.freedesktop.Notifications.Notifyメソッド呼び出し]
    D -->|接続NG| F[エラー返却]
    E --> G{通知デーモン応答}
    G -->|成功| H[通知ID取得・表示]
    G -->|失敗| I[GError設定]
    H --> J[終了]
    I --> J
    F --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| N/A | - | libnotifyはデータベースを使用しない |

### テーブル別参照項目詳細

libnotifyはライブラリであり、永続ストレージを持たない。通知履歴の保持は通知デーモン側の責務。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | - | - |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 初期化エラー | notify_init()失敗 | アプリケーション名を確認、再試行 |
| D-Bus接続エラー | セッションバス未接続 | 環境変数DBUS_SESSION_BUS_ADDRESSを確認 |
| 通知送信失敗 | デーモン応答なし | タイムアウト後にGError経由でエラー通知 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | D-Busレベルで自動（ライブラリ側での明示的リトライなし） |
| リトライ間隔 | D-Bus実装依存 |
| リトライ対象エラー | 一時的な接続エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 通知デーモン依存（libnotify側での制限なし） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

特に制限なし。Do Not Disturb機能は通知デーモン側で実装される。

## セキュリティ考慮事項

- D-Busセッションバスはユーザーセッション内でのみアクセス可能
- 通知内容はローカルセッション内でのみ表示され、ネットワーク転送されない
- HTMLマークアップはサニタイズされ、XSS的な攻撃は不可能
- 悪意あるアプリケーションによる過剰通知はデーモン側でレート制限可能

## 備考

- 現在WIP（Work In Progress）状態で、未コンパイル・未テスト
- gdk-pixbuf、gtk3への依存あり
- Redox OSへの移植にはD-Bus相当の通信機構の実装が必要

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

libnotifyはGNOME公式のライブラリであり、Redoxプロジェクトではビルドレシピのみが存在する。実際のソースコードはダウンロード元から取得される。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | recipe.toml | `recipes/wip/libs/other/libnotify/recipe.toml` | ビルド設定、依存関係、ソース取得元を確認 |

**読解のコツ**: recipe.tomlはTOML形式で記述されており、[source]セクションでダウンロード元、[build]セクションでビルド方法と依存関係を定義している。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | recipe.toml | `recipes/wip/libs/other/libnotify/recipe.toml` | templateがmesonであることを確認（行10） |

**主要処理フロー**:
1. **行2**: ソースアーカイブをGNOMEサーバーからダウンロード
2. **行6-9**: gdk-pixbuf、gtk3への依存関係を定義
3. **行10**: mesonビルドシステムを使用
4. **行11-14**: GTKドキュメント生成無効化、イントロスペクション無効化のフラグ設定

#### Step 3: 依存関係を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | 外部ソース | `https://download.gnome.org/sources/libnotify/0.8/libnotify-0.8.4.tar.xz` | 実際のlibnotifyソースコード（バージョン0.8.4） |

### プログラム呼び出し階層図

```
[アプリケーション]
    │
    ├─ notify_init("app-name")
    │      └─ D-Busセッションバス接続
    │
    ├─ notify_notification_new("summary", "body", "icon")
    │      └─ NotifyNotificationオブジェクト生成
    │
    └─ notify_notification_show(notification, &error)
           └─ org.freedesktop.Notifications.Notify D-Busメソッド呼び出し
                  └─ 通知デーモン処理
```

### データフロー図

```
[入力]                    [処理]                           [出力]

アプリケーション      ───▶ libnotify API                  ───▶ D-Busメッセージ
（通知パラメータ）          │                                    │
                           ├─ パラメータ検証                     │
                           ├─ D-Busメッセージ構築               ▼
                           └─ セッションバス送信         通知デーモン
                                                              │
                                                              ▼
                                                        画面表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| recipe.toml | `recipes/wip/libs/other/libnotify/recipe.toml` | 設定 | Redox用ビルドレシピ定義 |
| libnotify-0.8.4.tar.xz | （外部ダウンロード） | ソース | 本体ソースコード |
| gdk-pixbuf | `recipes/wip/libs/` 配下 | 依存 | 画像処理ライブラリ（依存） |
| gtk3 | `recipes/wip/libs/` 配下 | 依存 | GTK3ツールキット（依存） |
