# 通知設計書 10-sms-terminal

## 概要

本ドキュメントは、Redox OS向けに移植されるSMSターミナルクライアント「sms-terminal」における通知・表示機能の設計仕様を記述する。sms-terminalはRust言語で開発されたCLIベースのSMSクライアントであり、SMS送受信のターミナルインターフェースを提供する。

### 本通知の処理概要

sms-terminalは、sms-serverと連携してSMS送受信を行うためのターミナルクライアントアプリケーションである。コマンドラインインターフェースを通じてSMSの送信、受信メッセージの確認、会話履歴の表示などを行い、処理結果をターミナル上に通知/表示する。

**業務上の目的・背景**：SMS通信をターミナル環境で管理したいユーザー（サーバー管理者、開発者、自動化スクリプトとの連携など）向けのクライアントツールである。GUI環境がない場合やSSH経由でリモート管理する場合に、SMSの送受信をコマンドラインで行えるようにする。sms-serverと組み合わせることで、完全なCLIベースのSMSソリューションを提供する。

**通知の送信タイミング**：コマンド実行結果の即時表示、新着SMS受信時のターミナル通知、送信結果のステータス表示、エラー発生時の警告表示などのタイミングで通知される。インタラクティブモードでは継続的にイベントが表示される。

**通知の受信者**：sms-terminalを使用しているユーザー。ターミナル上での視覚的な表示と、オプションでのターミナルベル音による通知が行われる。

**通知内容の概要**：SMS送信結果（成功/失敗、送信先、タイムスタンプ）、受信SMS（送信元、本文、受信時刻）、エラーメッセージ、接続ステータスなどが表示される。カラー表示に対応し、重要度に応じた色分けも可能。

**期待されるアクション**：ユーザーは表示された情報を確認し、必要に応じて返信SMSを送信したり、エラー時は原因を調査して再試行したりする。

## 通知種別

ターミナル表示（stdout/stderr/TUI）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（コマンド結果表示） |
| 優先度 | 標準 |
| リトライ | サーバー通信にはリトライあり |

### 送信先決定ロジック

すべての出力はターミナル（stdout/stderr）に表示。TUIモードでは専用の表示エリアに表示。

## 通知テンプレート

### SMS送信結果表示

| 項目 | 内容 |
|-----|------|
| 成功時 | 緑色で「Message sent to {number}」 |
| 失敗時 | 赤色で「Failed to send: {error}」 |

### SMS受信表示

| 項目 | 内容 |
|-----|------|
| ヘッダー | 送信元番号、受信時刻 |
| 本文 | メッセージテキスト |
| 新着マーク | 未読メッセージの強調表示 |

### 本文テンプレート

```
送信成功:
  [OK] Message sent to {phone_number}
       ID: {message_id}
       Time: {timestamp}

受信メッセージ:
  [NEW] From: {sender_number} ({time})
        {message_body}

エラー:
  [ERROR] {error_message}
          Code: {error_code}

会話一覧:
  {phone_number} | {last_message_preview} | {timestamp}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | - | - | ターミナルクライアントのため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| phone_number | 電話番号 | サーバー応答/入力 | Yes |
| message_id | メッセージID | サーバー応答 | Yes |
| message_body | メッセージ本文 | サーバー応答/入力 | Yes |
| sender_number | 送信元番号 | サーバー応答 | Yes（受信時） |
| timestamp | タイムスタンプ | サーバー応答 | Yes |
| error_message | エラーメッセージ | エラー処理 | エラー時 |
| error_code | エラーコード | エラー処理 | エラー時 |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コマンド実行 | sms-terminal send | 有効な引数 | SMS送信と結果表示 |
| コマンド実行 | sms-terminal list | - | 受信メッセージ一覧表示 |
| コマンド実行 | sms-terminal read | メッセージ指定 | 特定メッセージの詳細表示 |
| インタラクティブ | sms-terminal | - | TUIモードでのリアルタイム表示 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| --quietオプション | 最小限の出力のみ |
| パイプ出力 | カラー/装飾を無効化 |
| サーバー未接続 | 接続エラーメッセージのみ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[コマンド入力] --> B[引数パース]
    B --> C{サブコマンド}
    C -->|send| D[サーバーにSMS送信リクエスト]
    C -->|list| E[サーバーからメッセージ一覧取得]
    C -->|read| F[サーバーから特定メッセージ取得]
    C -->|interactive| G[TUIモード起動]
    D --> H{送信結果}
    H -->|成功| I[成功メッセージ表示]
    H -->|失敗| J[エラーメッセージ表示]
    E --> K[メッセージ一覧をフォーマット]
    F --> L[メッセージ詳細を表示]
    G --> M[イベントループ]
    M --> N{イベント種別}
    N -->|入力| O[コマンド処理]
    N -->|受信| P[新着表示]
    O --> M
    P --> M
    I --> Q[終了]
    J --> Q
    K --> Q
    L --> Q
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| N/A | - | クライアントはサーバー経由でデータにアクセス |

### テーブル別参照項目詳細

sms-terminalはサーバーのAPIを通じてデータにアクセスするため、直接のデータベース操作は行わない。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | - | - |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| サーバー接続エラー | ネットワーク問題/サーバー停止 | 接続エラーメッセージ表示、リトライ提案 |
| 認証エラー | APIキー不正/期限切れ | 設定確認を促すメッセージ表示 |
| 引数エラー | 不正なコマンド引数 | ヘルプメッセージ表示 |
| タイムアウト | サーバー応答遅延 | タイムアウトエラー表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 設定可能（デフォルト3回） |
| リトライ間隔 | 設定可能（デフォルト1秒） |
| リトライ対象エラー | 一時的なネットワークエラー、タイムアウト |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| クライアント側 | 制限なし（サーバー側で制御） |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- APIキー/認証情報は設定ファイルまたは環境変数で管理
- 設定ファイルのパーミッションは600を推奨
- ターミナル履歴に機密情報が残る可能性に注意
- HTTPS経由でのサーバー通信を推奨

## 備考

- 現在WIP（Work In Progress）状態で、未コンパイル・未テスト
- Rust言語で実装、Cargoビルドテンプレートを使用
- sms-serverとの連携を前提とした設計
- Redox OSへの移植にはネットワーキングとターミナル機能のサポートが前提

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

sms-terminalはRust製のオープンソースプロジェクトであり、Redoxプロジェクトではビルドレシピのみが存在する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | recipe.toml | `recipes/wip/tel/sms-terminal/recipe.toml` | ビルド設定、ソース取得元を確認 |

**読解のコツ**: template="cargo"を使用しており、標準的なCargoビルドが行われる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | recipe.toml | `recipes/wip/tel/sms-terminal/recipe.toml` | ビルドスクリプト内容を確認 |

**主要処理フロー**:
1. **行3**: GitHubからソースをクローン（https://github.com/morgverd/sms-terminal）
2. **行5**: template="cargo"で標準Cargoビルドを使用

#### Step 3: 関連プロジェクトを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | sms-server/recipe.toml | `recipes/wip/tel/sms-server/recipe.toml` | 関連するサーバーコンポーネント |

**読解のコツ**: sms-terminalはsms-serverと連携して動作するため、両方のプロジェクトを理解する必要がある。

### プログラム呼び出し階層図

```
[sms-terminal CLI]
    │
    ├─ 設定読み込み
    │      └─ config.toml / 環境変数
    │
    ├─ コマンドパーサー
    │      ├─ send（SMS送信）
    │      ├─ list（一覧表示）
    │      ├─ read（詳細表示）
    │      └─ interactive（TUIモード）
    │
    ├─ サーバー通信
    │      ├─ HTTP/HTTPS接続
    │      ├─ API呼び出し
    │      └─ レスポンス処理
    │
    └─ 表示処理
           ├─ フォーマッタ
           ├─ カラー出力
           └─ TUI描画
```

### データフロー図

```
[入力]                    [処理]                           [出力]

ユーザー入力          ───▶ sms-terminal                   ───▶ ターミナル表示
（コマンドライン）          │                                   （stdout）
                           ├─ コマンド解析
設定ファイル          ───▶├─ サーバー通信
（config.toml）            └─ レスポンス処理

                           ↓ API呼び出し

                      sms-server                         ───▶ 結果表示
                           │                                   ・成功/失敗
                           └─ SMS処理                          ・メッセージ一覧
                                                              ・エラー情報
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| recipe.toml | `recipes/wip/tel/sms-terminal/recipe.toml` | 設定 | Redox用ビルドレシピ定義 |
| sms-terminal ソース | （外部Git） | ソース | 本体ソースコード |
| sms-server | `recipes/wip/tel/sms-server/` | 関連 | サーバーコンポーネント |
| config.toml | `~/.config/sms-terminal/` | 設定 | ユーザー設定ファイル（推定） |
