# 通知設計書 2-kf5-notifications

## 概要

本ドキュメントは、Redox OS向けに移植されるKDE Frameworks 5用通知フレームワーク「KNotifications」の設計仕様を記述する。KNotificationsはKDEデスクトップ環境においてアプリケーションがユーザーに通知を表示するための統一的なAPIを提供するフレームワークである。

### 本通知の処理概要

KNotificationsは、KDE Frameworks 5（KF5）の一部として提供されるデスクトップ通知フレームワークである。KDEアプリケーションがシステムの通知サービスと通信し、視覚的・聴覚的な通知をユーザーに提示するための高レベルAPIを提供する。

**業務上の目的・背景**：KDEベースのデスクトップアプリケーションが、統一されたユーザー体験を提供するために必要なフレームワークである。メール受信、ファイル転送完了、インスタントメッセージ、システムアラートなど、様々なイベントを一貫した方法でユーザーに通知することで、デスクトップ環境全体のUXを向上させる。freedesktop.org通知仕様をサポートしつつ、KDE固有の拡張機能も提供する。

**通知の送信タイミング**：アプリケーションがKNotificationオブジェクトを作成し、sendEvent()メソッドを呼び出した時点で通知が送信される。通知イベントは.notifyrcファイルで事前定義され、アプリケーション固有の通知設定（サウンド、ポップアップ表示、タスクバーエントリなど）をユーザーがカスタマイズ可能。

**通知の受信者**：KDEデスクトップセッションにログインしているユーザー。通知はKDE Plasma通知デーモン（plasmashell/knotify5）に送信され、ユーザーの画面上にポップアップ表示される。サウンド再生やタスクバーへの通知表示も可能。

**通知内容の概要**：通知はタイトル、テキスト、アイコン、関連アクション（URLを開く、アプリケーションを起動など）、緊急度で構成される。リッチテキスト（HTML）対応で、画像の埋め込みも可能。持続的通知（persistent）とフラグ付き通知もサポート。

**期待されるアクション**：ユーザーは通知を確認し、定義されたアクション（デフォルトアクション、追加アクション）を実行するか、通知を閉じる。通知設定はシステム設定から変更可能で、特定のアプリケーションやイベントタイプごとに通知方法をカスタマイズできる。

## 通知種別

デスクトップ通知（KDE Plasma通知システム経由）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（Qt/KDE IPC経由） |
| 優先度 | 設定可能（Notification/Warning/Information/Critical） |
| リトライ | フレームワークレベルでの自動処理 |

### 送信先決定ロジック

KDE Plasma通知サービス（knotify5）に対してD-Busまたは内部IPC経由でメッセージを送信。通知デーモンがユーザーセッション内で稼働していることが前提。非KDE環境ではfreedesktop.org Notificationsサービスへフォールバック。

## 通知テンプレート

### デスクトップ通知の場合

| 項目 | 内容 |
|-----|------|
| タイトル | アプリケーション指定のタイトル文字列 |
| テキスト | アプリケーション指定の詳細テキスト（リッチテキスト対応） |
| アイコン | アプリケーションアイコンまたはカスタムQIconイメージ |
| 緊急度 | NotificationLevel（Notification/Warning/Information/Critical） |

### 本文テンプレート

```
タイトル: {title}
テキスト: {text}
アイコン: {iconName}
イベントID: {eventId}
コンポーネント名: {componentName}
アクション: [{action_id}: {action_label}]
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| *.notifyrc | テキスト | 必須 | 通知イベント定義ファイル |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| eventId | 通知イベント識別子 | .notifyrc定義 | Yes |
| title | 通知タイトル | アプリケーション指定 | No |
| text | 通知本文 | アプリケーション指定 | No |
| iconName | アイコン名 | アプリケーション指定 | No |
| componentName | 通知元コンポーネント | アプリケーション指定 | Yes |
| flags | 通知フラグ（Persistent等） | アプリケーション指定 | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | KNotification::event() | イベントIDが.notifyrcに定義されていること | 静的ファクトリメソッドによる通知生成・送信 |
| API呼び出し | notification->sendEvent() | KNotificationオブジェクトが有効であること | インスタンスメソッドによる通知送信 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 通知無効設定 | ユーザーがシステム設定で該当通知を無効化している場合 |
| セッション未接続 | デスクトップセッションに接続できない場合 |
| .notifyrc未定義 | イベントIDが.notifyrcファイルに定義されていない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[アプリケーションがKNotification生成] --> B[イベントID・コンポーネント設定]
    B --> C[sendEvent呼び出し]
    C --> D{.notifyrc確認}
    D -->|定義あり| E[通知設定読み込み]
    D -->|定義なし| F[デフォルト設定使用]
    E --> G{ユーザー設定確認}
    F --> G
    G -->|通知有効| H[knotify5/Plasma通知サービスへ送信]
    G -->|通知無効| I[送信スキップ]
    H --> J{送信結果}
    J -->|成功| K[通知表示・サウンド再生]
    J -->|失敗| L[エラーシグナル発行]
    K --> M[終了]
    L --> M
    I --> M
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| N/A | - | KNotificationsはデータベースを使用しない |

### テーブル別参照項目詳細

KNotificationsはフレームワークであり、永続ストレージを持たない。通知履歴の保持はPlasmaデスクトップ側の責務。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | - | - |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| イベント未定義 | .notifyrcにイベントIDが存在しない | 警告ログ出力、デフォルト動作 |
| サービス未稼働 | knotify5/Plasma通知サービス未起動 | freedesktop.org通知へフォールバック |
| 権限エラー | D-Busアクセス権限不足 | エラーシグナル発行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | フレームワーク内部で自動処理 |
| リトライ間隔 | Qt/KDE実装依存 |
| リトライ対象エラー | 一時的な接続エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Plasma通知サービス依存 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

Do Not Disturb機能はPlasmaデスクトップで提供。フォーカスアシスト機能により、全画面アプリケーション使用中は通知を抑制可能。

## セキュリティ考慮事項

- D-Busセッションバスはユーザーセッション内でのみアクセス可能
- リッチテキストはQTextDocumentでレンダリングされ、スクリプト実行は不可
- .notifyrcファイルはアプリケーションインストール時に配置され、ユーザー設定は別途保存
- サンドボックス環境での通知はFlatpakポータル経由で処理

## 備考

- 現在WIP（Work In Progress）状態で、ビルドスクリプトが不完全
- KDE Frameworks 5.112.0を使用
- CMakeビルドシステムを使用するが、cookbook_configureの呼び出しが不完全
- Redox OSへの移植にはQt5およびKF5コア依存ライブラリの事前移植が必要

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

KNotificationsはKDE公式のフレームワークであり、Redoxプロジェクトではビルドレシピのみが存在する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | recipe.toml | `recipes/wip/libs/kf5/kf5-notifications/recipe.toml` | ビルド設定、ソース取得元を確認 |

**読解のコツ**: recipe.tomlの[build]セクションでtemplate="custom"となっており、独自のビルドスクリプトが記述されている。CMake関連のフラグ設定を確認する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | recipe.toml | `recipes/wip/libs/kf5/kf5-notifications/recipe.toml` | ビルドスクリプト内容を確認 |

**主要処理フロー**:
1. **行3**: KDEサーバーからソースアーカイブをダウンロード（knotifications-5.112.0.tar.xz）
2. **行5**: template="custom"でカスタムビルドスクリプトを使用
3. **行7-18**: CMake設定フラグの定義
4. **行8**: COOKBOOK_CONFIGURE="cmake"でCMakeビルドを指定
5. **行9-17**: クロスコンパイル用のCMakeフラグ設定
6. **行19**: cookbook_configure呼び出し（ただしビルドコマンド不足）

#### Step 3: ビルド設定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | 外部ソース | `https://download.kde.org/stable/frameworks/5.112/knotifications-5.112.0.tar.xz` | 実際のKNotificationsソースコード |

**読解のコツ**: ビルドスクリプトにはcookbook_make/cookbook_installの呼び出しがなく、ビルド完了までの手順が不完全。

### プログラム呼び出し階層図

```
[KDEアプリケーション]
    │
    ├─ KNotification::event("eventId", "title", QPixmap(), widget)
    │      └─ 静的ファクトリメソッド
    │
    ├─ notification->setTitle("title")
    │
    ├─ notification->setText("text")
    │
    ├─ notification->setActions({"action1", "action2"})
    │
    └─ notification->sendEvent()
           └─ knotify5 / org.freedesktop.Notifications D-Busメソッド呼び出し
                  └─ Plasma通知デーモン処理
```

### データフロー図

```
[入力]                    [処理]                           [出力]

アプリケーション      ───▶ KNotification API               ───▶ D-Busメッセージ
（通知パラメータ）          │                                    │
      +                    ├─ .notifyrc設定読み込み             │
.notifyrc              ───▶├─ ユーザー設定確認                  ▼
（イベント定義）            └─ 通知サービスへ送信        knotify5/Plasma
                                                              │
                                                              ▼
                                                   画面表示 / サウンド再生
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| recipe.toml | `recipes/wip/libs/kf5/kf5-notifications/recipe.toml` | 設定 | Redox用ビルドレシピ定義 |
| knotifications-5.112.0.tar.xz | （外部ダウンロード） | ソース | 本体ソースコード |
| *.notifyrc | アプリケーション配布 | 設定 | 通知イベント定義ファイル |
