# 通知設計書 3-kf5-notifyconfig

## 概要

本ドキュメントは、Redox OS向けに移植されるKDE Frameworks 5用通知設定ライブラリ「KNotifyConfig」の設計仕様を記述する。KNotifyConfigはKDEアプリケーションの通知設定をユーザーがカスタマイズするためのUIコンポーネントとAPIを提供するライブラリである。

### 本通知の処理概要

KNotifyConfigは、KDE Frameworks 5（KF5）の一部として提供される通知設定管理ライブラリである。ユーザーがアプリケーション固有の通知イベントに対して、通知方法（ポップアップ表示、サウンド再生、タスクバー表示など）を設定するためのダイアログウィジェットとAPIを提供する。

**業務上の目的・背景**：KDEアプリケーションにおいて、ユーザーが通知の表示方法をきめ細かくカスタマイズできるようにするためのフレームワークである。異なるアプリケーションでも統一されたUIで通知設定を行えるため、ユーザーの学習コストを削減し、一貫したエクスペリエンスを提供する。.notifyrcファイルで定義された通知イベントに対して、どのような方法で通知するかを設定する。

**通知の送信タイミング**：本ライブラリは通知を送信するのではなく、通知設定UIを提供する。ユーザーがアプリケーションの設定ダイアログから「通知の設定」を選択した際に、KNotifyConfigDialogが表示される。設定変更はユーザーが「適用」または「OK」をクリックした時点で保存される。

**通知の受信者**：アプリケーションの通知設定を変更したいユーザー。管理者権限は不要で、各ユーザーが自分の通知設定を独立して管理できる。

**通知内容の概要**：設定可能な通知方法には、ポップアップ通知の表示/非表示、サウンドファイルの選択、テキスト読み上げの有効化、タスクバーエントリの表示、アプリケーションウィンドウのマーキングなどがある。各イベントに対して複数の通知方法を組み合わせることが可能。

**期待されるアクション**：ユーザーは各通知イベントに対して希望する通知方法を選択・設定する。設定内容は~/.config/下に保存され、以降の通知送信時に適用される。

## 通知種別

設定管理UI（通知方法の設定ダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | N/A（設定管理用ライブラリ） |
| 優先度 | N/A |
| リトライ | N/A |

### 送信先決定ロジック

本ライブラリは通知を送信しない。通知設定をユーザー設定ファイルに保存し、KNotifications等が通知送信時にその設定を参照する。

## 通知テンプレート

### 設定ダイアログの場合

| 項目 | 内容 |
|-----|------|
| ダイアログタイトル | アプリケーション名 + "の通知設定" |
| イベント一覧 | .notifyrcから読み込まれたイベント名とコメント |
| 設定項目 | ポップアップ表示、サウンド、読み上げ、タスクバー |

### 本文テンプレート

```
イベント名: {eventName}
説明: {eventComment}
設定:
  - ポップアップを表示: {showPopup}
  - サウンドを再生: {playSound}
  - サウンドファイル: {soundFile}
  - 読み上げ: {speakText}
  - タスクバーに表示: {showTaskbar}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| *.notifyrc | テキスト | 必須 | 通知イベント定義（読み込み用） |
| ~/.config/*.notifyrc | テキスト | 設定保存時 | ユーザー設定保存先 |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| componentName | アプリケーション識別子 | .notifyrcファイル名 | Yes |
| eventId | イベント識別子 | .notifyrc [Event/xxx] セクション | Yes |
| eventName | イベント表示名 | .notifyrc Name= | Yes |
| eventComment | イベント説明 | .notifyrc Comment= | No |
| Action | 通知アクション設定 | .notifyrc Action= | No |
| Sound | サウンドファイルパス | .notifyrc Sound= | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| UI操作 | 設定ダイアログオープン | アプリケーションから呼び出し | KNotifyConfigDialog::configure()呼び出し |
| UI操作 | 設定変更 | ユーザーが設定を変更 | チェックボックス操作、サウンド選択など |
| UI操作 | 設定保存 | OK/適用ボタンクリック | 設定ファイルへの書き込み |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| .notifyrc不在 | アプリケーションの.notifyrcファイルが存在しない場合 |
| 書き込み権限なし | ユーザー設定ディレクトリへの書き込み権限がない場合 |

## 処理フロー

### 設定フロー

```mermaid
flowchart TD
    A[アプリケーションが設定ダイアログ要求] --> B[KNotifyConfigDialog生成]
    B --> C[.notifyrcファイル読み込み]
    C --> D[ユーザー設定読み込み]
    D --> E[設定UIを表示]
    E --> F{ユーザー操作}
    F -->|設定変更| G[UI更新]
    G --> F
    F -->|OK/適用| H[設定をファイルに保存]
    F -->|キャンセル| I[変更を破棄]
    H --> J{保存結果}
    J -->|成功| K[ダイアログを閉じる]
    J -->|失敗| L[エラーメッセージ表示]
    I --> K
    L --> F
    K --> M[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| N/A | - | KNotifyConfigはデータベースを使用しない |

### テーブル別参照項目詳細

設定はファイルベースで管理される。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | - | - |

### ファイル操作

| ファイルパス | 操作 | 概要 |
|------------|------|------|
| /usr/share/knotifications5/*.notifyrc | READ | システムデフォルト設定の読み込み |
| ~/.config/*.notifyrc | READ/WRITE | ユーザー固有設定の読み書き |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ファイル読み込みエラー | .notifyrcが存在しない | 警告表示、空の設定リストを表示 |
| ファイル書き込みエラー | 権限不足、ディスク容量不足 | エラーダイアログ表示 |
| 不正な設定値 | .notifyrcのパースエラー | 該当イベントをスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A（UIコンポーネント） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| N/A | 設定管理UIのため該当なし |

### 配信時間帯

該当なし。

## セキュリティ考慮事項

- ユーザー設定は各ユーザーのホームディレクトリに保存され、他のユーザーからはアクセス不可
- サウンドファイルのパス指定時、ファイルの存在確認を実施
- 任意コード実行につながる設定項目はない

## 備考

- 現在WIP（Work In Progress）状態で、ビルドスクリプトが不完全
- KDE Frameworks 5.112.0を使用
- CMakeビルドシステムを使用するが、cookbook_configureの呼び出しが不完全
- KNotifications（kf5-notifications）との組み合わせで使用される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

KNotifyConfigはKDE公式のライブラリであり、Redoxプロジェクトではビルドレシピのみが存在する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | recipe.toml | `recipes/wip/libs/kf5/kf5-notifyconfig/recipe.toml` | ビルド設定、ソース取得元を確認 |

**読解のコツ**: kf5-notificationsと同様の構造を持つため、そちらと比較しながら読むと理解しやすい。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | recipe.toml | `recipes/wip/libs/kf5/kf5-notifyconfig/recipe.toml` | ビルドスクリプト内容を確認 |

**主要処理フロー**:
1. **行3**: KDEサーバーからソースアーカイブをダウンロード（knotifyconfig-5.112.0.tar.xz）
2. **行5**: template="custom"でカスタムビルドスクリプトを使用
3. **行7-18**: CMake設定フラグの定義（kf5-notificationsと同一構造）
4. **行19**: cookbook_configure呼び出し

#### Step 3: 関連ライブラリとの関係を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | kf5-notifications/recipe.toml | `recipes/wip/libs/kf5/kf5-notifications/recipe.toml` | 関連する通知ライブラリの設定 |

**読解のコツ**: KNotifyConfigはKNotificationsと密接に連携するため、両方のレシピを確認することが重要。

### プログラム呼び出し階層図

```
[KDEアプリケーション]
    │
    ├─ 設定メニュー → "通知の設定..."
    │
    └─ KNotifyConfigWidget::configure(componentName, widget)
           │
           ├─ .notifyrcファイル読み込み
           │      └─ KConfig::openConfig()
           │
           ├─ ユーザー設定読み込み
           │      └─ ~/.config/ 下のファイル
           │
           ├─ UI表示・ユーザー操作待機
           │
           └─ 設定保存
                  └─ KConfig::sync()
```

### データフロー図

```
[入力]                    [処理]                           [出力]

.notifyrc             ───▶ KNotifyConfigWidget            ───▶ 設定UI表示
（イベント定義）             │
                           ├─ イベント一覧構築
ユーザー設定          ───▶├─ 現在設定の読み込み
（~/.config/）              └─ UI構築・表示

                           ↓ ユーザー操作

ユーザー入力          ───▶ 設定変更処理                   ───▶ ~/.config/*.notifyrc
（設定変更）                                                   （更新された設定）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| recipe.toml | `recipes/wip/libs/kf5/kf5-notifyconfig/recipe.toml` | 設定 | Redox用ビルドレシピ定義 |
| knotifyconfig-5.112.0.tar.xz | （外部ダウンロード） | ソース | 本体ソースコード |
| kf5-notifications/recipe.toml | `recipes/wip/libs/kf5/kf5-notifications/recipe.toml` | 設定 | 関連通知ライブラリ |
| *.notifyrc | アプリケーション配布 | 設定 | 通知イベント定義ファイル |
