# 通知設計書 4-startup-notification

## 概要

本ドキュメントは、Redox OS向けに移植されるX11アプリケーション起動通知ライブラリ「startup-notification」の設計仕様を記述する。startup-notificationはfreedesktop.org仕様に準拠したアプリケーション起動状態の通知メカニズムを提供するライブラリである。

### 本通知の処理概要

startup-notificationは、X11デスクトップ環境においてアプリケーションの起動状態をデスクトップシェルに通知するためのライブラリである。freedesktop.org Startup Notification Protocol仕様に準拠し、アプリケーション起動中のカーソル変更（ビジーカーソル表示）や、タスクバーへの起動中アプリケーション表示などを実現する。

**業務上の目的・背景**：ユーザーがアプリケーションを起動した際、起動が完了するまでの間に視覚的なフィードバックを提供することで、ユーザーエクスペリエンスを向上させる。起動中であることを示すビジーカーソルやタスクバーのアニメーション表示により、ユーザーは重複クリックを避けることができ、システムが応答していることを認識できる。

**通知の送信タイミング**：アプリケーションランチャー（デスクトップシェル、ファイルマネージャーなど）がアプリケーションを起動する際に「起動開始」通知を送信し、起動されたアプリケーションがウィンドウを表示した際に「起動完了」通知を送信する。通知はX11メッセージまたはD-Busを経由して送信される。

**通知の受信者**：デスクトップシェル（ウィンドウマネージャー、タスクバー、ドック）。起動通知を受信したデスクトップシェルは、カーソルをビジー状態に変更したり、タスクバーに起動中のアプリケーションエントリを表示したりする。

**通知内容の概要**：通知には起動シーケンスID、アプリケーション名、アイコン名、起動元ワークスペース、起動時刻などのメタデータが含まれる。起動完了通知では、起動されたウィンドウのIDも伝達される。

**期待されるアクション**：デスクトップシェルは起動開始通知を受信するとビジーカーソルを表示し、タイムアウトまたは起動完了通知を受信するとカーソルを通常状態に戻す。起動完了時にはウィンドウへのフォーカス移動も行われる。

## 通知種別

X11メッセージ / D-Bus（デスクトップ起動通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（X11 ClientMessage）または非同期（D-Bus） |
| 優先度 | 標準 |
| リトライ | なし（タイムアウトで自動終了） |

### 送信先決定ロジック

X11ルートウィンドウに対してClientMessageイベントを送信。すべてのデスクトップシェルコンポーネントがルートウィンドウのイベントを監視することで通知を受信する。

## 通知テンプレート

### 起動開始メッセージ

| 項目 | 内容 |
|-----|------|
| メッセージタイプ | _NET_STARTUP_INFO_BEGIN / _NET_STARTUP_INFO |
| シーケンスID | 一意の起動識別子 |
| アプリケーション情報 | 名前、アイコン、起動元など |

### 本文テンプレート

```
new: ID={startup_id} NAME={app_name} ICON={icon_name} BIN={binary_path}
     SCREEN={screen_number} WORKSPACE={workspace_number} TIMESTAMP={timestamp}

remove: ID={startup_id}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | - | - | X11メッセージベースのため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| ID | 起動シーケンス識別子 | ランチャー生成（UUID形式） | Yes |
| NAME | アプリケーション表示名 | .desktopファイル Name= | Yes |
| ICON | アイコン名 | .desktopファイル Icon= | No |
| BIN | 実行バイナリパス | .desktopファイル Exec= | No |
| SCREEN | 起動先スクリーン番号 | Xディスプレイから取得 | No |
| WORKSPACE | 起動先ワークスペース | 現在のワークスペースから取得 | No |
| TIMESTAMP | 起動タイムスタンプ | ユーザーイベント時刻 | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | sn_launcher_context_initiate() | アプリケーション起動前 | 起動開始通知の送信 |
| API呼び出し | sn_launchee_context_complete() | ウィンドウ表示後 | 起動完了通知の送信 |
| タイムアウト | 起動タイムアウト | 一定時間経過後 | 起動通知の自動終了 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| X11未接続 | Xディスプレイに接続できない場合 |
| ヘッドレス環境 | ディスプレイがない環境での起動 |
| STARTUP_NOTIFICATION_DISABLED | 環境変数で無効化されている場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ユーザーがアプリケーション起動] --> B[ランチャーがsn_launcher_context生成]
    B --> C[sn_launcher_context_initiate呼び出し]
    C --> D[起動開始メッセージをルートウィンドウに送信]
    D --> E[fork/execでアプリケーション起動]
    E --> F{アプリケーション側}
    F --> G[sn_launchee_context生成]
    G --> H[ウィンドウ作成・表示]
    H --> I[sn_launchee_context_complete呼び出し]
    I --> J[起動完了メッセージ送信]
    J --> K{デスクトップシェル側}
    D --> K
    K --> L[起動開始: ビジーカーソル表示]
    J --> M[起動完了: カーソル通常化・フォーカス移動]
    L --> N{タイムアウト?}
    N -->|Yes| O[カーソル通常化]
    N -->|No| M
    M --> P[終了]
    O --> P
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| N/A | - | startup-notificationはデータベースを使用しない |

### テーブル別参照項目詳細

すべてのデータはメモリ上およびX11プロパティとして管理される。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | - | - |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| X11接続エラー | ディスプレイ未接続 | 通知をスキップ、アプリケーション起動は続行 |
| メッセージ送信失敗 | X11サーバーエラー | 警告ログ、処理続行 |
| タイムアウト | アプリケーション応答なし | 起動通知を自動終了 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A（タイムアウトで終了） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- X11プロトコルはセッション内でのみ有効
- 起動通知にはアプリケーションメタデータのみが含まれ、機密情報は含まれない
- 不正な起動通知による影響はカーソル表示の不整合程度に限定される

## 備考

- 現在WIP（Work In Progress）状態
- libice、libx11、xcb-utilへの依存あり
- autotoolsビルドシステムを使用
- Redox OSへの移植にはX11/XCB対応またはWayland対応が必要

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

startup-notificationはfreedesktop.org公式のライブラリであり、Redoxプロジェクトではビルドレシピのみが存在する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | recipe.toml | `recipes/wip/x11/startup-notification/recipe.toml` | ビルド設定、依存関係、ソース取得元を確認 |

**読解のコツ**: [source]セクションにscriptがあり、ソースダウンロード後にautotools_recursive_regenerateが実行される点に注目。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | recipe.toml | `recipes/wip/x11/startup-notification/recipe.toml` | ビルドスクリプト内容を確認 |

**主要処理フロー**:
1. **行2**: freedesktop.orgからソースアーカイブをダウンロード（startup-notification-0.12.tar.gz）
2. **行3**: blake3チェックサムで整合性検証
3. **行5-7**: ソーススクリプトでDYNAMIC_INITとautotools_recursive_regenerateを実行
4. **行10-14**: 依存関係としてlibice、libx11、xcb-utilを指定
5. **行15**: template="custom"でカスタムビルドスクリプトを使用
6. **行17-19**: DYNAMIC_INITとcookbook_configureを実行、lf_cv_sane_realloc=yesを設定

#### Step 3: 依存関係を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | 外部ソース | `http://www.freedesktop.org/software/startup-notification/releases/startup-notification-0.12.tar.gz` | 実際のソースコード（バージョン0.12） |

### プログラム呼び出し階層図

```
[ランチャー側]
    │
    ├─ sn_display_new(display, push_trap, pop_trap)
    │      └─ Xディスプレイ接続の初期化
    │
    ├─ sn_launcher_context_new(display, screen)
    │      └─ 起動コンテキスト生成
    │
    ├─ sn_launcher_context_set_name/icon/description(...)
    │      └─ アプリケーション情報設定
    │
    └─ sn_launcher_context_initiate(context, "launcher", "binary", timestamp)
           └─ _NET_STARTUP_INFO_BEGINメッセージ送信

[起動されるアプリケーション側]
    │
    ├─ sn_launchee_context_new_from_environment(display, screen)
    │      └─ DESKTOP_STARTUP_ID環境変数から復元
    │
    └─ sn_launchee_context_complete(context)
           └─ remove: ID=...メッセージ送信
```

### データフロー図

```
[入力]                    [処理]                           [出力]

ユーザークリック      ───▶ ランチャー                     ───▶ X11 ClientMessage
（起動要求）                │                                   (_NET_STARTUP_INFO_BEGIN)
                           ├─ 起動ID生成                        │
                           ├─ 環境変数設定                      ▼
                           └─ fork/exec              デスクトップシェル
                                                              │
                                                              ├─ ビジーカーソル表示
アプリケーション      ───▶ 起動完了処理                        ├─ タスクバー更新
（ウィンドウ表示）          │                                   │
                           └─ remove送信             ───▶ カーソル通常化
                                                              └─ フォーカス移動
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| recipe.toml | `recipes/wip/x11/startup-notification/recipe.toml` | 設定 | Redox用ビルドレシピ定義 |
| startup-notification-0.12.tar.gz | （外部ダウンロード） | ソース | 本体ソースコード |
| libice | `recipes/` 配下 | 依存 | X11 ICEプロトコルライブラリ |
| libx11 | `recipes/` 配下 | 依存 | X11クライアントライブラリ |
| xcb-util | `recipes/` 配下 | 依存 | XCBユーティリティライブラリ |
