# 通知設計書 5-thunderbird

## 概要

本ドキュメントは、Redox OS向けに移植されるMozillaのメールクライアント「Thunderbird」における通知機能の設計仕様を記述する。Thunderbirdはメール送受信、カレンダー、タスク管理などの機能を提供し、新着メール通知やリマインダー通知などの機能を備える。

### 本通知の処理概要

Thunderbirdは、Mozilla Foundationが開発するオープンソースのメールクライアントアプリケーションである。POP3、IMAP、SMTPプロトコルをサポートし、新着メール受信時にユーザーへの通知を行う。また、カレンダー機能によるイベントリマインダー通知も提供する。

**業務上の目的・背景**：メールコミュニケーションはビジネスにおいて重要な役割を果たす。新着メールを見逃さないよう、デスクトップ通知によってユーザーに即座に知らせることで、迅速なコミュニケーションを実現する。また、カレンダーのリマインダー通知により、重要な予定を忘れることなく対応できるようにする。複数のメールアカウントを一元管理し、統一されたインターフェースで通知を受け取れる。

**通知の送信タイミング**：新着メール受信時（メールサーバーからのフェッチ完了後）、カレンダーイベントのリマインダー時刻到達時、メッセージフィルタによるアクション実行時などに通知が送信される。通知はシステムの通知機能（libnotify等）を使用してデスクトップに表示される。

**通知の受信者**：Thunderbirdを使用しているユーザー。通知はローカルデスクトップセッション内で表示され、メールの送信者情報やカレンダーイベントの詳細が含まれる。

**通知内容の概要**：新着メール通知には送信者名、件名、メール本文のプレビュー（設定による）が含まれる。カレンダー通知にはイベント名、開始時刻、場所などが含まれる。通知には関連する操作（メールを開く、イベントを表示するなど）へのショートカットが提供される。

**期待されるアクション**：ユーザーは通知をクリックして対応するメールやイベントを開き、内容を確認して返信やアクション実行を行う。通知を閉じる、または一定時間後に自動消去させることも可能。

## 通知種別

デスクトップ通知（libnotify/freedesktop.org Notifications経由）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（libnotify経由） |
| 優先度 | 設定可能（通常/重要） |
| リトライ | なし |

### 送信先決定ロジック

システムの通知デーモン（org.freedesktop.Notifications）に対してD-Bus経由でメッセージを送信。Thunderbirdの設定でアカウントごと、フォルダごとに通知の有効/無効を設定可能。

## 通知テンプレート

### 新着メール通知

| 項目 | 内容 |
|-----|------|
| 送信元アイコン | Thunderbirdアイコンまたは送信者アバター |
| タイトル | 送信者名（またはメールアドレス） |
| 本文 | 件名 + 本文プレビュー |
| アクション | メールを開く、削除、アーカイブ |

### 本文テンプレート

```
新着メール:
From: {sender_name} <{sender_email}>
Subject: {subject}
Preview: {body_preview}
Account: {account_name}
Folder: {folder_name}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | - | - | 通知には添付ファイル情報のみ表示 |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| sender_name | 送信者表示名 | メールヘッダー From: | Yes |
| sender_email | 送信者メールアドレス | メールヘッダー From: | Yes |
| subject | 件名 | メールヘッダー Subject: | Yes |
| body_preview | 本文プレビュー | メール本文（設定による文字数） | No |
| account_name | アカウント名 | Thunderbird設定 | No |
| folder_name | フォルダ名 | IMAP/POPフォルダ | No |
| received_time | 受信時刻 | メールヘッダー Date: | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| メール受信 | 新着メールフェッチ完了 | 通知設定が有効、未読メール | 新着メールの通知 |
| スケジュール | カレンダーリマインダー時刻 | リマインダー設定あり | イベントリマインダー通知 |
| フィルタ | メッセージフィルタ実行 | フィルタアクションに通知が設定 | カスタムフィルタによる通知 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 通知無効設定 | アカウントまたはグローバルで通知が無効 |
| フォーカス中 | Thunderbirdウィンドウがアクティブな場合（設定による） |
| Do Not Disturb | システムのDND設定が有効な場合 |
| 迷惑メール | 迷惑メールフォルダへの配信は通知しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[メールサーバーから新着メール受信] --> B[メールフィルタ適用]
    B --> C{迷惑メール?}
    C -->|Yes| D[通知スキップ]
    C -->|No| E{通知設定確認}
    E -->|無効| D
    E -->|有効| F{ウィンドウフォーカス確認}
    F -->|フォーカス中| G{フォーカス時通知設定}
    G -->|通知しない| D
    G -->|通知する| H[通知内容構築]
    F -->|非フォーカス| H
    H --> I[libnotify/D-Bus経由で通知送信]
    I --> J{送信結果}
    J -->|成功| K[通知表示]
    J -->|失敗| L[エラーログ出力]
    K --> M[終了]
    L --> M
    D --> M
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| mork/SQLite | メールインデックス | Thunderbird内部データベース |

### テーブル別参照項目詳細

#### メールインデックス

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| sender | 送信者情報取得 | メッセージID |
| subject | 件名取得 | メッセージID |
| date | 受信日時取得 | メッセージID |
| flags | 既読/未読状態 | メッセージID |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| 通知履歴 | INSERT | 送信した通知の記録（実装依存） |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 通知デーモン未稼働 | D-Busサービス未起動 | サイレントに失敗、エラーログ出力 |
| メール解析エラー | 不正なメール形式 | デフォルトテキストで通知 |
| 文字コードエラー | エンコーディング問題 | フォールバックエンコーディング使用 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 設定可能（大量メール受信時のバッチ通知） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

Thunderbirdの設定で特定時間帯の通知無効化が可能。

## セキュリティ考慮事項

- 通知にはメールの一部内容が表示されるため、画面覗き見に注意が必要
- プレビュー表示の無効化設定が可能
- 機密性の高いアカウントは通知を無効化することを推奨
- HTMLメールの本文プレビューはサニタイズされる

## 備考

- 現在WIP（Work In Progress）状態で、クロスコンパイル変数が不足
- Mozilla独自のビルドシステム（mach）を使用
- バージョン140.7.0esrを使用
- Redox OSへの移植には多数の依存関係解決が必要

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ThunderbirdはMozilla公式のアプリケーションであり、Redoxプロジェクトではビルドレシピとmozconfig設定ファイルが存在する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | recipe.toml | `recipes/wip/net/email/thunderbird/recipe.toml` | ビルド設定、ソース取得元を確認 |
| 1-2 | mozconfig | `recipes/wip/net/email/thunderbird/mozconfig` | ビルドオプション設定を確認 |

**読解のコツ**: Mozillaプロジェクトは独自のビルドシステム（mach）を使用する。mozconfigファイルでビルドオプションを設定する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | recipe.toml | `recipes/wip/net/email/thunderbird/recipe.toml` | ビルドスクリプト内容を確認 |

**主要処理フロー**:
1. **行5**: Mozillaアーカイブサーバーからソースをダウンロード（thunderbird-140.7.0esr.source.tar.xz）
2. **行7**: template="custom"でカスタムビルドスクリプトを使用
3. **行9**: ステージングディレクトリの作成
4. **行10**: MOZCONFIG環境変数を設定
5. **行11**: ./mach buildを実行

#### Step 3: mozconfig設定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | mozconfig | `recipes/wip/net/email/thunderbird/mozconfig` | ビルドオプションを確認 |

**主要処理フロー**:
1. **行1**: --enable-project=comm/mail でメールプロジェクトを有効化
2. **行2**: --prefix でインストール先を設定
3. **行3**: --enable-release でリリースビルドを有効化
4. **行4**: --target でクロスコンパイルターゲットを設定
5. **行5**: --enable-bootstrap でブートストラップを有効化
6. **行6-8**: 不要な機能（jack, crashreporter, updater）を無効化

### プログラム呼び出し階層図

```
[Thunderbird メールクライアント]
    │
    ├─ メールサーバー接続
    │      ├─ IMAP/POP3フェッチ
    │      └─ 新着メール検出
    │
    ├─ メール処理
    │      ├─ メッセージパース
    │      ├─ フィルタ適用
    │      └─ インデックス更新
    │
    └─ 通知処理
           ├─ 通知設定確認
           ├─ 通知内容構築
           └─ libnotify/D-Bus呼び出し
                  └─ デスクトップ通知表示
```

### データフロー図

```
[入力]                    [処理]                           [出力]

メールサーバー        ───▶ Thunderbird                    ───▶ デスクトップ通知
（新着メール）              │                                   │
                           ├─ プロトコル処理                   │
                           │   (IMAP/POP3)                     ▼
                           ├─ メールパース                 ユーザー画面
                           ├─ フィルタ適用                     │
                           └─ 通知生成                         │
                                                              ▼
                                                        通知ポップアップ
                                                        ・送信者名
                                                        ・件名
                                                        ・本文プレビュー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| recipe.toml | `recipes/wip/net/email/thunderbird/recipe.toml` | 設定 | Redox用ビルドレシピ定義 |
| mozconfig | `recipes/wip/net/email/thunderbird/mozconfig` | 設定 | Mozillaビルドオプション設定 |
| thunderbird-140.7.0esr.source.tar.xz | （外部ダウンロード） | ソース | 本体ソースコード |
