# 通知設計書 6-meli

## 概要

本ドキュメントは、Redox OS向けに移植されるターミナルベースのメールクライアント「meli」における通知機能の設計仕様を記述する。meliはRust言語で開発された軽量なターミナルメールクライアントであり、新着メール通知などの機能を提供する。

### 本通知の処理概要

meliは、Rust言語で開発されたターミナルベースのメールクライアントである。IMAP、JMAP、NNTP、Notmuch、Maildir、mboxなどの多様なバックエンドをサポートし、ターミナル環境でのメール管理を可能にする。軽量かつ高速な動作が特徴で、キーボード操作に最適化されている。

**業務上の目的・背景**：GUIを使用せずにメールを管理したいユーザー（サーバー管理者、CUI好みのパワーユーザーなど）向けのメールクライアントである。SSHセッション経由でリモートサーバー上のメールを効率的に管理できる。新着メールの受信をユーザーに通知することで、ターミナル作業中でも重要なメールを見逃さないようにする。

**通知の送信タイミング**：メールバックエンド（IMAP等）からの新着メール検出時に通知が送信される。meliはバックグラウンドでメールをポーリングまたはIDLEコマンドで監視し、新着メール到着時に通知を生成する。通知方法はターミナルベル、デスクトップ通知（notify-send等）、またはカスタムコマンド実行が設定可能。

**通知の受信者**：meliを使用しているユーザー。ターミナル内での通知（ベル音、ステータスバー更新）と、デスクトップ通知の両方をサポートする。

**通知内容の概要**：新着メール通知には送信者、件名、受信アカウント・フォルダ情報が含まれる。ターミナル内通知ではステータスバーに簡潔な情報が表示され、デスクトップ通知ではより詳細な情報が表示される。

**期待されるアクション**：ユーザーはmeliのインターフェースでメール一覧に移動し、新着メールを確認・返信する。デスクトップ通知からの直接的なメール表示機能は限定的（ターミナルアプリケーションの制約）。

## 通知種別

ターミナル通知（ベル/ステータスバー）/ デスクトップ通知（notify-send等）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（バックグラウンドスレッド） |
| 優先度 | 標準 |
| リトライ | なし |

### 送信先決定ロジック

設定ファイル（~/.config/meli/config.toml）で指定された通知方法に従って送信。複数の通知方法を併用可能（ターミナルベル＋デスクトップ通知など）。

## 通知テンプレート

### ターミナル通知

| 項目 | 内容 |
|-----|------|
| ベル | \x07（BEL文字） |
| ステータスバー | "New mail in {account}/{folder}: {count} messages" |

### デスクトップ通知

| 項目 | 内容 |
|-----|------|
| タイトル | "meli - New Mail" |
| 本文 | "{sender}: {subject}" |
| アイコン | mail-unread（テーマアイコン） |

### 本文テンプレート

```
ターミナル: [meli] New mail in {account_name}/{folder_name}
デスクトップ:
  Title: meli - New Mail
  Body: From: {sender}
        Subject: {subject}
        Account: {account_name}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | - | - | 通知には添付ファイル情報のみ表示 |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| sender | 送信者 | メールヘッダー From: | Yes |
| subject | 件名 | メールヘッダー Subject: | Yes |
| account_name | アカウント名 | config.toml設定 | Yes |
| folder_name | フォルダ名 | バックエンド | Yes |
| count | 新着メール数 | 差分検出 | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ポーリング | 定期メールチェック | 新着メール検出 | 設定間隔でのメール確認 |
| IDLE | IMAPサーバープッシュ | サーバーからのEXISTS応答 | リアルタイム新着検出 |
| 手動更新 | ユーザー操作（R/r） | 新着メール存在 | 手動リフレッシュ時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 通知無効設定 | config.tomlでnotifications = falseの場合 |
| フォーカス中 | meliがフォアグラウンドで該当フォルダを表示中（設定による） |
| 初回同期 | 初回起動時の大量メール同期では通知しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[バックエンドスレッドがメール変更を検出] --> B[新着メールリスト取得]
    B --> C{新着メールあり?}
    C -->|No| D[待機状態に戻る]
    C -->|Yes| E[通知設定確認]
    E --> F{通知有効?}
    F -->|No| G[UIのみ更新]
    F -->|Yes| H{通知方法}
    H -->|ターミナルベル| I[BEL文字出力]
    H -->|デスクトップ| J[notify-send等実行]
    H -->|カスタムコマンド| K[設定コマンド実行]
    I --> L[ステータスバー更新]
    J --> L
    K --> L
    G --> L
    L --> D
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| SQLite | メールキャッシュ/インデックス | meliオプション機能 |

### テーブル別参照項目詳細

#### メールキャッシュ（SQLite使用時）

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| envelope | メールヘッダー情報 | ハッシュキー |
| flags | 既読/未読状態 | メッセージID |
| date | 受信日時 | メッセージID |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| メールキャッシュ | INSERT/UPDATE | 新着メール情報の保存 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| notify-send失敗 | コマンド未インストール | エラーログ出力、ターミナル通知にフォールバック |
| カスタムコマンド失敗 | コマンド実行エラー | エラーログ出力 |
| バックエンド接続エラー | ネットワーク問題 | リトライ後にエラー表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | バックエンド接続: 設定による |
| リトライ間隔 | 設定によるバックオフ |
| リトライ対象エラー | ネットワーク一時エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 設定可能（notification_rate_limit） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

設定による制限が可能。

## セキュリティ考慮事項

- 通知にはメールの送信者と件名が含まれるため、画面共有時に注意
- デスクトップ通知の無効化が設定で可能
- カスタム通知コマンドは信頼できるものを使用
- IMAP認証情報はキーリングまたは設定ファイルで管理

## 備考

- 現在WIP（Work In Progress）状態で、ahashクレートエラーが発生
- Rust言語で実装、Cargoでビルド
- sqlite3への依存あり
- Redox OSへの移植にはRust標準ライブラリのRedox対応が前提

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

meliはRust製のオープンソースプロジェクトであり、Redoxプロジェクトではビルドレシピのみが存在する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | recipe.toml | `recipes/wip/net/other/meli/recipe.toml` | ビルド設定、依存関係、ソース取得元を確認 |

**読解のコツ**: Rust/Cargoプロジェクトのため、cookbook_cargo_packagesマクロが使用される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | recipe.toml | `recipes/wip/net/other/meli/recipe.toml` | ビルドスクリプト内容を確認 |

**主要処理フロー**:
1. **行3**: GitHubからソースをクローン（https://git.meli-email.org/meli/meli）
2. **行5**: template="custom"でカスタムビルドスクリプトを使用
3. **行6-8**: sqlite3への依存関係を定義
4. **行10**: cookbook_cargo_packages meliでCargoビルドを実行

#### Step 3: 依存関係を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | 外部ソース | `https://git.meli-email.org/meli/meli` | meliソースコード |

### プログラム呼び出し階層図

```
[meli メインプロセス]
    │
    ├─ 設定ファイル読み込み
    │      └─ ~/.config/meli/config.toml
    │
    ├─ バックエンドスレッド起動
    │      ├─ IMAP接続
    │      ├─ Maildir監視
    │      └─ 他バックエンド
    │
    ├─ UIスレッド
    │      ├─ ターミナル描画
    │      ├─ キー入力処理
    │      └─ ステータスバー更新
    │
    └─ 通知スレッド
           ├─ 新着メール検出
           ├─ 通知方法選択
           └─ notify-send / ベル / カスタムコマンド
```

### データフロー図

```
[入力]                    [処理]                           [出力]

メールサーバー        ───▶ meliバックエンド               ───▶ ターミナルUI
（IMAP等）                 │                                   │
                           ├─ メールフェッチ                   ├─ ステータスバー
設定ファイル          ───▶├─ 差分検出                         ├─ メール一覧
（config.toml）            └─ 通知トリガー                     │
                                │                              │
                                ▼                              ▼
                           通知処理                        デスクトップ通知
                           ・notify-send                   ・タイトル
                           ・ターミナルベル                ・本文
                           ・カスタムコマンド
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| recipe.toml | `recipes/wip/net/other/meli/recipe.toml` | 設定 | Redox用ビルドレシピ定義 |
| meli ソース | （外部Git） | ソース | 本体ソースコード |
| sqlite3 | `recipes/libs/sqlite3/` | 依存 | SQLiteデータベースライブラリ |
| config.toml | `~/.config/meli/` | 設定 | ユーザー設定ファイル |
