# 通知設計書 7-neverest

## 概要

本ドキュメントは、Redox OS向けに移植されるPimalayaプロジェクトのメール同期ツール「neverest」における通知・同期機能の設計仕様を記述する。neverestはRust言語で開発されたCLIベースのメール同期ツールであり、複数のメールアカウント間でのメール同期を実現する。

### 本通知の処理概要

neverestは、Pimalayaプロジェクトの一部として開発されたコマンドラインベースのメール同期ツールである。IMAP、Notmuch、Maildir間でのメール同期を行い、offlineimap/mbsyncの代替として設計されている。同期完了やエラー発生時にユーザーへの通知を行う機能を持つ。

**業務上の目的・背景**：複数のメールアカウントを持つユーザーが、ローカル環境とリモートサーバー間でメールを同期する必要がある。neverestは高速かつ信頼性の高いメール同期を提供し、バックアップやオフラインアクセスを可能にする。同期状況をユーザーに通知することで、データの整合性と同期の成功/失敗を把握できるようにする。

**通知の送信タイミング**：同期処理の開始時、完了時、エラー発生時に通知が送信される。継続的な同期モード（watchモード）では、新着メール検出時にも通知を行う。コマンドライン出力およびシステム通知（notify-rust等）を通じて通知される。

**通知の受信者**：neverestを使用しているシステム管理者または一般ユーザー。CLIツールのため、主にコマンドライン出力での通知となるが、デスクトップ環境ではシステム通知との統合も可能。

**通知内容の概要**：同期通知には同期元/先のアカウント情報、同期されたメッセージ数、エラー内容（発生時）、処理時間などが含まれる。新着メール通知では送信者と件名が表示される。

**期待されるアクション**：ユーザーは同期結果を確認し、エラー発生時は設定やネットワーク状況を確認して再試行する。新着メール通知を受けた場合は、メールクライアントで内容を確認する。

## 通知種別

コマンドライン出力 / デスクトップ通知（notify-rust経由）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（CLI出力）/ 非同期（デスクトップ通知） |
| 優先度 | 標準（エラー時は高） |
| リトライ | 同期処理にはリトライあり |

### 送信先決定ロジック

CLIの出力はstdout/stderrに直接出力。デスクトップ通知はnotify-rustクレート経由でシステムの通知デーモンに送信。設定ファイルで通知方法を選択可能。

## 通知テンプレート

### 同期完了通知

| 項目 | 内容 |
|-----|------|
| タイトル | "neverest - Sync Complete" |
| 本文 | "{account}: {synced_count} messages synced in {duration}" |
| アイコン | mail-send（テーマアイコン） |

### 同期エラー通知

| 項目 | 内容 |
|-----|------|
| タイトル | "neverest - Sync Error" |
| 本文 | "{account}: {error_message}" |
| アイコン | dialog-error（テーマアイコン） |

### 本文テンプレート

```
CLI出力:
  [INFO] Starting sync for account: {account_name}
  [INFO] Syncing {folder_name}...
  [INFO] Sync complete: {synced_count} messages, {duration}s
  [ERROR] Sync failed: {error_message}

デスクトップ通知:
  Title: neverest - {status}
  Body: {account_name}: {message}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | - | - | 同期ツールのため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| account_name | アカウント名 | 設定ファイル | Yes |
| folder_name | 同期フォルダ名 | IMAP/バックエンド | Yes |
| synced_count | 同期メッセージ数 | 同期処理結果 | Yes |
| duration | 処理時間 | 計測値 | No |
| error_message | エラー内容 | エラーハンドラ | エラー時 |
| status | 同期状態 | 処理結果 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コマンド実行 | neverest sync | 同期開始/完了/エラー | 手動同期実行時 |
| 定期実行 | cron/systemd timer | スケジュール設定あり | 自動同期時 |
| ウォッチモード | neverest watch | 変更検出時 | 継続監視モード |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 静音モード | --quietオプション指定時 |
| 通知無効 | 設定で通知を無効化している場合 |
| 変更なし | 同期対象のメッセージがない場合（設定による） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[同期コマンド実行] --> B[設定ファイル読み込み]
    B --> C[バックエンド接続]
    C --> D{接続成功?}
    D -->|No| E[エラー通知]
    D -->|Yes| F[同期処理開始]
    F --> G[フォルダごとに同期]
    G --> H{同期成功?}
    H -->|No| I[エラーログ出力]
    H -->|Yes| J[同期カウント更新]
    I --> K{続行?}
    K -->|Yes| G
    K -->|No| E
    J --> L{次のフォルダあり?}
    L -->|Yes| G
    L -->|No| M[同期完了通知]
    E --> N[終了]
    M --> N
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| SQLite/ローカル状態DB | 同期状態管理 | オプション機能 |

### テーブル別参照項目詳細

#### 同期状態データベース（使用時）

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| message_id | メッセージ識別 | フォルダ・アカウント |
| uid | IMAP UID | アカウント・フォルダ |
| flags | メールフラグ | メッセージID |
| last_sync | 最終同期日時 | アカウント |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| 同期状態 | INSERT/UPDATE/DELETE | 同期結果の反映 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 接続エラー | ネットワーク/認証問題 | リトライ後にエラー通知 |
| 同期衝突 | 競合する変更 | 設定に従い解決（local/remote優先） |
| ディスク容量不足 | ローカルストレージ問題 | エラー通知、同期中断 |
| タイムアウト | サーバー応答なし | リトライ後にエラー通知 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 設定可能（デフォルト3回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なネットワークエラー、タイムアウト |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（同期ツール） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

設定またはスケジューラ（cron/systemd）で制御。

## セキュリティ考慮事項

- IMAP認証情報は設定ファイルまたはシステムキーリングで管理
- OAuth2サポートによるセキュアな認証
- TLS必須オプションでの接続暗号化
- 設定ファイルのパーミッション管理（600推奨）

## 備考

- 現在WIP（Work In Progress）状態で、未コンパイル・未テスト
- Rust言語で実装、Cargoビルドテンプレートを使用
- Pimalayaプロジェクトの一部（himalaya、costrとの連携）
- Redox OSへの移植にはRust標準ライブラリのRedox対応が前提

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

neverestはPimalayaプロジェクトの一部であり、Redoxプロジェクトではビルドレシピのみが存在する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | recipe.toml | `recipes/wip/net/email/neverest/recipe.toml` | ビルド設定、ソース取得元を確認 |

**読解のコツ**: template="cargo"を使用しており、標準的なCargoビルドが行われる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | recipe.toml | `recipes/wip/net/email/neverest/recipe.toml` | ビルドスクリプト内容を確認 |

**主要処理フロー**:
1. **行3**: GitHubからソースをクローン（https://github.com/pimalaya/neverest）
2. **行5**: template="cargo"で標準Cargoビルドを使用

#### Step 3: プロジェクト構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | 外部ソース | `https://github.com/pimalaya/neverest` | neverestソースコード |

**読解のコツ**: PimalayaプロジェクトはRustエコシステムを活用し、himalaya（メールクライアント）、costr（設定管理）と連携する設計。

### プログラム呼び出し階層図

```
[neverest CLI]
    │
    ├─ 設定ファイル読み込み
    │      └─ ~/.config/neverest/config.toml
    │
    ├─ コマンド解析
    │      ├─ sync（同期実行）
    │      ├─ watch（継続監視）
    │      └─ その他
    │
    ├─ バックエンド初期化
    │      ├─ IMAP接続
    │      ├─ Maildir読み込み
    │      └─ Notmuch接続
    │
    └─ 同期処理
           ├─ 差分検出
           ├─ メッセージ転送
           ├─ 状態更新
           └─ 結果通知
```

### データフロー図

```
[入力]                    [処理]                           [出力]

リモートサーバー      ───▶ neverest                       ───▶ ローカルストレージ
（IMAP）                   │                                   （Maildir等）
                           ├─ 接続・認証
ローカルストレージ    ───▶├─ 差分検出
（Maildir等）              ├─ 双方向同期
                           └─ 状態記録

                           │
                           ▼
                      通知出力
                      ・CLI stdout/stderr
                      ・デスクトップ通知
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| recipe.toml | `recipes/wip/net/email/neverest/recipe.toml` | 設定 | Redox用ビルドレシピ定義 |
| neverest ソース | （外部Git） | ソース | 本体ソースコード |
| config.toml | `~/.config/neverest/` | 設定 | ユーザー設定ファイル |
