# 通知設計書 8-email-sleuth

## 概要

本ドキュメントは、Redox OS向けに移植されるメールアドレス分析ツール「email-sleuth」における分析結果通知機能の設計仕様を記述する。email-sleuthはRust言語で開発されたCLIベースのメールアドレス検証・分析ツールである。

### 本通知の処理概要

email-sleuthは、メールアドレスの有効性検証、ドメイン分析、MXレコード検索などの機能を提供するコマンドラインツールである。与えられたメールアドレスに対して各種検証を行い、その結果をユーザーに通知する。

**業務上の目的・背景**：マーケティング、顧客管理、セキュリティ調査などの業務において、メールアドレスの有効性を事前に検証する必要がある。無効なメールアドレスへの送信はバウンスを引き起こし、送信者のレピュテーションに悪影響を与える。email-sleuthはメールアドレスの構文検証、ドメイン存在確認、MXレコード検証などを行い、アドレスの信頼性を判定する。

**通知の送信タイミング**：分析処理の完了時に結果が通知される。単一アドレス分析では即座に結果が出力され、バッチ処理（ファイルからの複数アドレス分析）では進行状況と最終結果がまとめて通知される。

**通知の受信者**：email-sleuthを使用しているシステム管理者、マーケティング担当者、セキュリティアナリストなど。CLIツールのため、コマンドライン出力での通知が主となる。

**通知内容の概要**：分析結果通知には、メールアドレスの有効性判定、ドメイン情報（MXレコード、DNSレコード）、検証結果の詳細（構文チェック、ドメイン到達性など）が含まれる。JSON/CSV形式での出力も可能。

**期待されるアクション**：ユーザーは分析結果を確認し、無効なアドレスをリストから除外したり、詳細調査が必要なアドレスを特定したりする。バッチ処理の結果はファイル出力してさらなる処理に利用可能。

## 通知種別

コマンドライン出力（stdout/stderr）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（CLI出力） |
| 優先度 | 標準 |
| リトライ | DNS検索にはリトライあり |

### 送信先決定ロジック

分析結果はstdoutに出力。エラーメッセージはstderrに出力。出力形式（テキスト/JSON/CSV）はコマンドラインオプションで指定。

## 通知テンプレート

### 分析結果通知

| 項目 | 内容 |
|-----|------|
| フォーマット | テキスト / JSON / CSV |
| 内容 | メールアドレス、有効性、詳細情報 |

### 本文テンプレート

```
テキスト形式:
  Email: {email}
  Valid: {is_valid}
  Domain: {domain}
  MX Records: {mx_records}
  Syntax Check: {syntax_valid}
  Domain Exists: {domain_exists}
  Deliverable: {deliverable}

JSON形式:
{
  "email": "{email}",
  "valid": {is_valid},
  "domain": "{domain}",
  "mx_records": [{mx_records}],
  "checks": {
    "syntax": {syntax_valid},
    "domain_exists": {domain_exists},
    "deliverable": {deliverable}
  }
}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | - | - | 分析ツールのため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| email | 分析対象メールアドレス | 入力 | Yes |
| is_valid | 総合有効性判定 | 分析結果 | Yes |
| domain | ドメイン部分 | メールアドレス抽出 | Yes |
| mx_records | MXレコード一覧 | DNS検索 | No |
| syntax_valid | 構文チェック結果 | 正規表現検証 | Yes |
| domain_exists | ドメイン存在確認 | DNS検索 | Yes |
| deliverable | 配送可能性 | SMTP検証（オプション） | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コマンド実行 | email-sleuth {email} | 単一アドレス分析 | 単一メールアドレスの分析 |
| バッチ実行 | email-sleuth -f {file} | ファイル入力 | 複数アドレスの一括分析 |
| パイプ入力 | echo {email} \| email-sleuth | stdin入力 | パイプラインでの使用 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 静音モード | --quietオプション指定時（エラーのみ出力） |
| 出力リダイレクト | ファイル出力時はプログレス表示を抑制 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[メールアドレス入力] --> B[構文検証]
    B --> C{構文有効?}
    C -->|No| D[無効結果出力]
    C -->|Yes| E[ドメイン抽出]
    E --> F[DNS検索]
    F --> G{ドメイン存在?}
    G -->|No| H[ドメイン無効結果出力]
    G -->|Yes| I[MXレコード検索]
    I --> J{MXあり?}
    J -->|No| K[MX無し警告付き結果出力]
    J -->|Yes| L{SMTP検証有効?}
    L -->|Yes| M[SMTP接続テスト]
    L -->|No| N[有効結果出力]
    M --> O{SMTP応答OK?}
    O -->|Yes| N
    O -->|No| P[配送不可警告付き結果出力]
    D --> Q[終了]
    H --> Q
    K --> Q
    N --> Q
    P --> Q
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| N/A | - | email-sleuthはデータベースを使用しない |

### テーブル別参照項目詳細

外部DNSサーバーへの問い合わせのみ。ローカルデータベースは使用しない。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | - | - |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| DNS解決失敗 | ネットワーク問題/タイムアウト | リトライ後にエラー出力 |
| SMTP接続失敗 | サーバー拒否/タイムアウト | 警告付きで結果出力 |
| 入力形式エラー | 不正な入力ファイル形式 | エラーメッセージ出力、スキップ |
| OpenSSL エラー | TLS関連問題 | エラー出力（現在の主要問題） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | DNS検索: 3回 |
| リトライ間隔 | 1秒、2秒、4秒（指数バックオフ） |
| リトライ対象エラー | 一時的なネットワークエラー、タイムアウト |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| DNS検索 | リゾルバ設定に依存 |
| SMTP検証 | 接続間隔設定可能（サーバー負荷軽減） |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- SMTP検証機能は対象サーバーに接続するため、プライバシーポリシーに注意
- DNS検索はパブリックDNSまたはローカルリゾルバを使用
- TLS接続にはOpenSSLを使用（現在openssl-sysクレートエラーあり）
- 大量のメールアドレス検証は対象ドメインに負荷をかける可能性

## 備考

- 現在WIP（Work In Progress）状態で、openssl-sysクレートエラーが発生
- Rust言語で実装、Cargoビルドテンプレートを使用
- OpenSSL依存のため、Redox OS向けOpenSSLの移植が前提
- 代替としてrustls使用への変更も検討可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

email-sleuthはRust製のオープンソースプロジェクトであり、Redoxプロジェクトではビルドレシピのみが存在する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | recipe.toml | `recipes/wip/analysis/email-sleuth/recipe.toml` | ビルド設定、ソース取得元を確認 |

**読解のコツ**: template="cargo"を使用しており、標準的なCargoビルドが行われる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | recipe.toml | `recipes/wip/analysis/email-sleuth/recipe.toml` | ビルドスクリプト内容を確認 |

**主要処理フロー**:
1. **行3**: GitHubからソースをクローン（https://github.com/tokenizer-decode/email-sleuth）
2. **行5**: template="cargo"で標準Cargoビルドを使用

#### Step 3: 問題点を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | recipe.toml | `recipes/wip/analysis/email-sleuth/recipe.toml` | コメントでopenssl-sysエラーが記載 |

**読解のコツ**: openssl-sysクレートはネイティブOpenSSLライブラリに依存するため、Redox向けOpenSSLの移植状況を確認する必要がある。

### プログラム呼び出し階層図

```
[email-sleuth CLI]
    │
    ├─ コマンドライン引数解析
    │      ├─ 単一アドレス
    │      ├─ ファイル入力
    │      └─ stdin入力
    │
    ├─ メールアドレス解析
    │      ├─ 構文検証
    │      └─ ドメイン抽出
    │
    ├─ DNS検索
    │      ├─ ドメイン存在確認
    │      └─ MXレコード取得
    │
    ├─ SMTP検証（オプション）
    │      ├─ TLS接続
    │      └─ RCPT TO検証
    │
    └─ 結果出力
           ├─ テキスト形式
           ├─ JSON形式
           └─ CSV形式
```

### データフロー図

```
[入力]                    [処理]                           [出力]

メールアドレス        ───▶ email-sleuth                   ───▶ 分析結果
（コマンドライン）          │                                   （stdout）
                           ├─ 構文検証
ファイル              ───▶├─ DNS検索                      ───▶ JSON/CSV
（--file オプション）       │    └─ MXレコード取得              （ファイル）
                           ├─ SMTP検証（オプション）
stdin                 ───▶└─ 結果集約
（パイプ）

                           ↓ 外部参照

                      DNSサーバー（MXレコード等）
                      SMTPサーバー（配送検証）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| recipe.toml | `recipes/wip/analysis/email-sleuth/recipe.toml` | 設定 | Redox用ビルドレシピ定義 |
| email-sleuth ソース | （外部Git） | ソース | 本体ソースコード |
| openssl | `recipes/` 配下 | 依存 | TLS/暗号化ライブラリ（問題箇所） |
