# 通知設計書 9-sms-server

## 概要

本ドキュメントは、Redox OS向けに移植されるSMSサーバー実装「sms-server」における通知・メッセージ配信機能の設計仕様を記述する。sms-serverはRust言語で開発されたSMSゲートウェイサーバーであり、SMS送受信機能を提供する。

### 本通知の処理概要

sms-serverは、SMSメッセージの送受信を処理するサーバーアプリケーションである。HTTPまたはその他のインターフェースを通じてSMS送信リクエストを受け付け、モデム/SIMカード経由で実際のSMSを送信する。また、受信したSMSをクライアントに通知する機能も持つ。

**業務上の目的・背景**：アプリケーションからのSMS送信を自動化する必要がある場合（二要素認証コードの送信、通知メッセージの送信、アラート配信など）に使用される。sms-serverはSMSゲートウェイとして機能し、アプリケーションとモデム/通信キャリア間の橋渡しを行う。受信したSMSもクライアントに通知することで、双方向のSMSコミュニケーションを実現する。

**通知の送信タイミング**：SMS送信リクエスト受信時、SMS送信完了/失敗時、新着SMS受信時にそれぞれ通知/イベントが発生する。サーバーログへの出力、Webhook呼び出し、WebSocket経由のリアルタイム通知などの方法で通知される。

**通知の受信者**：sms-serverを利用するアプリケーション開発者、システム管理者。SMS送信結果はAPI応答として返され、受信SMSはWebhookまたはポーリングで取得可能。

**通知内容の概要**：送信通知にはメッセージID、送信先電話番号、送信ステータス、タイムスタンプが含まれる。受信通知には送信元電話番号、メッセージ本文、受信時刻が含まれる。エラー通知にはエラーコードと詳細メッセージが含まれる。

**期待されるアクション**：クライアントアプリケーションは送信結果を確認し、失敗時はリトライまたはエラーハンドリングを行う。受信SMSについては内容を解析してビジネスロジックを実行する（返信、データ処理など）。

## 通知種別

API応答 / Webhook / WebSocket / ログ出力

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（API応答）/ 非同期（Webhook/WebSocket） |
| 優先度 | 設定可能 |
| リトライ | SMS送信にはリトライ機能あり |

### 送信先決定ロジック

SMS送信はリクエストで指定された電話番号宛。サーバーイベント通知は設定されたWebhook URLまたは接続中のWebSocketクライアントに送信。

## 通知テンプレート

### SMS送信完了通知

| 項目 | 内容 |
|-----|------|
| タイプ | message_sent |
| 内容 | メッセージID、宛先、ステータス、送信時刻 |

### SMS受信通知

| 項目 | 内容 |
|-----|------|
| タイプ | message_received |
| 内容 | 送信元、メッセージ本文、受信時刻 |

### 本文テンプレート

```
送信完了（JSON）:
{
  "type": "message_sent",
  "message_id": "{message_id}",
  "to": "{phone_number}",
  "status": "delivered",
  "timestamp": "{timestamp}"
}

受信通知（JSON）:
{
  "type": "message_received",
  "from": "{sender_number}",
  "body": "{message_body}",
  "timestamp": "{timestamp}"
}

エラー通知:
{
  "type": "error",
  "message_id": "{message_id}",
  "error_code": "{code}",
  "error_message": "{description}"
}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | - | - | SMSはテキストのみ |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| message_id | メッセージ識別子 | サーバー生成（UUID） | Yes |
| phone_number | 宛先電話番号 | リクエスト | Yes |
| sender_number | 送信元電話番号 | 受信SMS | Yes |
| message_body | メッセージ本文 | リクエスト/受信SMS | Yes |
| status | 送信ステータス | モデム応答 | Yes |
| timestamp | タイムスタンプ | システム時刻 | Yes |
| error_code | エラーコード | エラー処理 | エラー時 |
| error_message | エラー説明 | エラー処理 | エラー時 |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | POST /send | 有効なリクエスト | SMS送信リクエスト |
| モデムイベント | 新着SMS検出 | 受信メッセージあり | SMS受信通知 |
| 内部処理 | 送信完了/失敗 | 処理完了時 | ステータス通知 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 無効な電話番号 | フォーマット不正で送信拒否 |
| モデム未接続 | ハードウェア問題時 |
| レート制限超過 | 送信制限に達した場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[SMS送信リクエスト受信] --> B[リクエスト検証]
    B --> C{検証OK?}
    C -->|No| D[エラー応答]
    C -->|Yes| E[送信キューに追加]
    E --> F[モデムに送信]
    F --> G{送信成功?}
    G -->|No| H{リトライ可能?}
    H -->|Yes| I[リトライ待機]
    I --> F
    H -->|No| J[送信失敗通知]
    G -->|Yes| K[送信成功通知]
    D --> L[ログ記録]
    J --> L
    K --> L
    L --> M[終了]
```

### 受信フロー

```mermaid
flowchart TD
    A[モデムがSMS受信] --> B[メッセージパース]
    B --> C[データベースに保存]
    C --> D{Webhook設定あり?}
    D -->|Yes| E[Webhook呼び出し]
    D -->|No| F{WebSocket接続あり?}
    E --> F
    F -->|Yes| G[WebSocket通知]
    F -->|No| H[ログ記録のみ]
    G --> I[終了]
    H --> I
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| messages | 送受信メッセージ履歴 | SQLiteまたは設定DB |
| settings | サーバー設定 | オプション |

### テーブル別参照項目詳細

#### messages テーブル

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | メッセージID | プライマリキー |
| direction | 送信/受信 | フィルタ |
| phone_number | 電話番号 | 検索 |
| body | メッセージ本文 | 表示 |
| status | ステータス | フィルタ |
| created_at | 作成日時 | ソート |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| messages | INSERT | 新規メッセージ保存 |
| messages | UPDATE | ステータス更新 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| モデム接続エラー | ハードウェア問題 | 再接続試行、エラー通知 |
| 送信失敗 | 電波状況、キャリア問題 | リトライ後にエラー通知 |
| 無効な電話番号 | フォーマットエラー | 即座にエラー応答 |
| レート制限 | 送信制限超過 | 待機後リトライまたはエラー |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 設定可能（デフォルト3回） |
| リトライ間隔 | 設定可能（デフォルト指数バックオフ） |
| リトライ対象エラー | 一時的な送信失敗、タイムアウト |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 設定可能（キャリア制限考慮） |
| 1日あたり上限 | 設定可能 |

### 配信時間帯

設定で制限可能（夜間送信禁止など）。

## セキュリティ考慮事項

- API認証（APIキー/JWT）によるアクセス制御
- HTTPS経由でのAPI通信を推奨
- 電話番号のバリデーションによる不正送信防止
- レート制限によるスパム防止
- 送受信メッセージのログ保存時の暗号化検討

## 備考

- 現在WIP（Work In Progress）状態で、未コンパイル・未テスト
- Rust言語で実装、Cargoビルドテンプレートを使用
- モデム/SIMカード接続が必要（シリアルポート/USB）
- Redox OSへの移植にはシリアル通信ドライバのサポートが前提

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

sms-serverはRust製のオープンソースプロジェクトであり、Redoxプロジェクトではビルドレシピのみが存在する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | recipe.toml | `recipes/wip/tel/sms-server/recipe.toml` | ビルド設定、ソース取得元を確認 |

**読解のコツ**: template="cargo"を使用しており、標準的なCargoビルドが行われる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | recipe.toml | `recipes/wip/tel/sms-server/recipe.toml` | ビルドスクリプト内容を確認 |

**主要処理フロー**:
1. **行3**: GitHubからソースをクローン（https://github.com/morgverd/sms-server）
2. **行5**: template="cargo"で標準Cargoビルドを使用

#### Step 3: 関連プロジェクトを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | sms-terminal/recipe.toml | `recipes/wip/tel/sms-terminal/recipe.toml` | 関連するターミナルクライアント |

**読解のコツ**: sms-serverとsms-terminalは同じ作者（morgverd）のプロジェクトで、連携して使用することを想定している。

### プログラム呼び出し階層図

```
[sms-server]
    │
    ├─ 設定読み込み
    │      └─ config.toml / 環境変数
    │
    ├─ モデム接続
    │      ├─ シリアルポート初期化
    │      ├─ ATコマンド送信
    │      └─ モデム状態監視
    │
    ├─ HTTPサーバー
    │      ├─ POST /send（SMS送信）
    │      ├─ GET /messages（履歴取得）
    │      └─ WebSocket接続
    │
    └─ メッセージ処理
           ├─ 送信キュー管理
           ├─ 受信監視
           └─ ステータス通知
```

### データフロー図

```
[入力]                    [処理]                           [出力]

クライアント          ───▶ sms-server                     ───▶ モデム/SIMカード
（HTTP API）               │                                   （SMS送信）
                           ├─ リクエスト検証
Webhook設定           ───▶├─ キュー管理                   ───▶ Webhook
                           ├─ モデム通信                       （イベント通知）
                           └─ ステータス管理

モデム                ───▶ 受信処理                       ───▶ WebSocket
（受信SMS）                 ├─ パース                          （リアルタイム通知）
                           └─ DB保存
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| recipe.toml | `recipes/wip/tel/sms-server/recipe.toml` | 設定 | Redox用ビルドレシピ定義 |
| sms-server ソース | （外部Git） | ソース | 本体ソースコード |
| sms-terminal | `recipes/wip/tel/sms-terminal/` | 関連 | ターミナルクライアント |
